/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.tools.internal.ClassData;
import org.eclipse.swt.tools.internal.FieldData;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.MethodData;
import org.eclipse.swt.tools.internal.ParameterData;

public class MetaDataGenerator
extends JNIGenerator {
    public void generateCopyright() {
        this.generateMetaData("swt_properties_copyright");
    }

    public void generate(Class clazz) {
        this.output(MetaDataGenerator.toC(clazz.getName()));
        this.output("=");
        ClassData data = this.getMetaData().getMetaData(clazz);
        if (data != null) {
            this.output(data.toString());
        }
        this.outputln();
        Field[] fields = clazz.getDeclaredFields();
        this.generate(fields);
        Method[] methods = clazz.getDeclaredMethods();
        this.generate(methods);
        this.outputln();
    }

    public void generate(Field[] fields) {
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int mods = field.getModifiers();
            if ((mods & 1) != 0 && (mods & 0x10) == 0 && (mods & 8) == 0) {
                this.generate(field);
                this.outputln();
            }
            ++i;
        }
    }

    public void generate(Field field) {
        this.output(MetaDataGenerator.getClassName(field.getDeclaringClass()));
        this.output("_");
        this.output(field.getName());
        this.output("=");
        FieldData data = this.getMetaData().getMetaData(field);
        if (data != null) {
            this.output(data.toString());
        }
    }

    public void generate(Method[] methods) {
        MetaDataGenerator.sort(methods);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
                this.outputln();
                if (this.progress != null) {
                    this.progress.step();
                }
            }
            ++i;
        }
    }

    public void generate(Method method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(MetaDataGenerator.getClassName(method.getDeclaringClass()));
        buffer.append("_");
        if (MetaDataGenerator.isNativeUnique(method)) {
            buffer.append(method.getName());
        } else {
            buffer.append(MetaDataGenerator.getFunctionName(method));
        }
        String key = buffer.toString();
        this.output(key);
        this.output("=");
        MethodData methodData = this.getMetaData().getMetaData(method);
        if (methodData != null) {
            this.output(methodData.toString());
        }
        this.outputln();
        int length = method.getParameterTypes().length;
        int i = 0;
        while (i < length) {
            this.output(key);
            this.output("_");
            this.output(String.valueOf(i) + "=");
            ParameterData paramData = this.getMetaData().getMetaData(method, i);
            if (paramData != null) {
                this.output(paramData.toString());
            }
            this.outputln();
            ++i;
        }
    }

    public String getExtension() {
        return ".properties";
    }

    public String getOutputName() {
        return this.getMainClass().getName();
    }

    protected boolean getGenerate(Class clazz) {
        return true;
    }
}

