/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.swt.SWT;
import org.eclipse.swt.tools.internal.ItemData;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.MetaDataGenerator;
import org.eclipse.swt.tools.internal.NativesGenerator;
import org.eclipse.swt.tools.internal.ProgressMonitor;
import org.eclipse.swt.tools.internal.StatsGenerator;
import org.eclipse.swt.tools.internal.StructsGenerator;

public class JNIGeneratorApp {
    Class mainClass;
    ProgressMonitor progress;
    String mainClassName;
    String outputDir;
    String classpath;
    MetaData metaData;

    public String getClasspath() {
        return this.classpath;
    }

    public Class getMainClass() {
        return this.mainClass;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    String getMetaDataDir() {
        return "./JNI Generation/org/eclipse/swt/tools/internal/";
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    void generateSTATS_C(Class[] classes) {
        try {
            StatsGenerator gen = new StatsGenerator(false);
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            gen.generate();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + gen.getFileName());
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSTATS_H(Class[] classes) {
        try {
            StatsGenerator gen = new StatsGenerator(true);
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            gen.generate();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + gen.getFileName());
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSTRUCTS_H(Class[] classes) {
        try {
            StructsGenerator gen = new StructsGenerator(true);
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            gen.generate();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + gen.getFileName());
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSTRUCTS_C(Class[] classes) {
        try {
            StructsGenerator gen = new StructsGenerator(false);
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            gen.generate();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + gen.getFileName());
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSWT_C(Class[] classes) {
        try {
            NativesGenerator gen = new NativesGenerator();
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            gen.generate();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + gen.getFileName());
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateMetaData(Class[] classes) {
        try {
            MetaDataGenerator gen = new MetaDataGenerator();
            gen.setMainClass(this.mainClass);
            gen.setClasses(classes);
            gen.setMetaData(this.metaData);
            gen.setProgressMonitor(this.progress);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.setOutput(new PrintStream(out));
            gen.generate();
            if (!new File(this.getMetaDataDir()).exists()) {
                System.out.println("Warning: Meta data output dir does not exist");
                return;
            }
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.getMetaDataDir()) + gen.getFileName());
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    public void generate() {
        this.generate(null);
    }

    public void generate(ProgressMonitor progress) {
        if (this.mainClassName == null) {
            return;
        }
        if (progress != null) {
            progress.setMessage("Initializing...");
        }
        Class[] classes = this.getClasses();
        Class[] natives = this.getNativesClasses();
        Class[] structs = this.getStructureClasses();
        this.progress = progress;
        if (progress != null) {
            int nativeCount = 0;
            int i = 0;
            while (i < natives.length) {
                Class clazz = natives[i];
                Method[] methods = clazz.getDeclaredMethods();
                int j = 0;
                while (j < methods.length) {
                    Method method = methods[j];
                    if ((method.getModifiers() & 0x100) != 0) {
                        ++nativeCount;
                    }
                    ++j;
                }
                ++i;
            }
            int total = nativeCount * 4;
            total += classes.length;
            total += natives.length * 3;
            progress.setTotal(total += structs.length * 2);
            progress.setMessage("Generating structs.h ...");
        }
        this.generateSTRUCTS_H(structs);
        if (progress != null) {
            progress.setMessage("Generating structs.c ...");
        }
        this.generateSTRUCTS_C(structs);
        if (progress != null) {
            progress.setMessage("Generating natives ...");
        }
        this.generateSWT_C(natives);
        if (progress != null) {
            progress.setMessage("Generating stats.h ...");
        }
        this.generateSTATS_H(natives);
        if (progress != null) {
            progress.setMessage("Generating stats.c ...");
        }
        this.generateSTATS_C(natives);
        if (progress != null) {
            progress.setMessage("Generating meta data ...");
        }
        this.generateMetaData(classes);
        if (progress != null) {
            progress.setMessage("Done.");
        }
        this.progress = null;
    }

    boolean compare(InputStream is1, InputStream is2) throws IOException {
        int c1;
        do {
            int c2;
            if ((c1 = is1.read()) == (c2 = is2.read())) continue;
            return false;
        } while (c1 != -1);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void output(byte[] bytes, String fileName) throws IOException {
        FileInputStream is;
        block10: {
            is = null;
            try {
                try {
                    is = new FileInputStream(fileName);
                    if (!this.compare(new ByteArrayInputStream(bytes), new BufferedInputStream(is))) break block10;
                    Object var4_4 = null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (is == null) return;
            is.close();
            return;
        }
        Object var4_6 = null;
        try {}
        catch (IOException iOException) {}
        if (is != null) {
            is.close();
        }
        FileOutputStream out = new FileOutputStream(fileName);
        out.write(bytes);
        out.close();
    }

    String getPackageName(String className) {
        int dot = this.mainClassName.lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return this.mainClassName.substring(0, dot);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] getClassNames(String mainClassName) {
        String pkgName = this.getPackageName(mainClassName);
        String classpath = this.getClasspath();
        if (classpath == null) {
            classpath = System.getProperty("java.class.path");
        }
        String pkgPath = pkgName.replace('.', File.separatorChar);
        String pkgZipPath = pkgName.replace('.', '/');
        ArrayList<String> classes = new ArrayList<String>();
        int start = 0;
        int index = 0;
        while (true) {
            block17: {
                String[] entries;
                String path;
                block18: {
                    Object var15_16;
                    if (index >= classpath.length()) {
                        return classes.toArray(new String[classes.size()]);
                    }
                    index = classpath.indexOf(File.pathSeparatorChar, start);
                    if (index == -1) {
                        index = classpath.length();
                    }
                    if (!(path = classpath.substring(start, index)).toLowerCase().endsWith(".jar")) break block18;
                    ZipFile zipFile = null;
                    try {
                        try {
                            zipFile = new ZipFile(path);
                            entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                ZipEntry entry = entries.nextElement();
                                String name = entry.getName();
                                if (!name.startsWith(pkgZipPath) || !name.endsWith(".class")) continue;
                                String className = name.substring(pkgZipPath.length() + 1, name.length() - 6);
                                className.replace('/', '.');
                                classes.add(className);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        var15_16 = null;
                        try {
                            if (zipFile == null) throw throwable;
                            zipFile.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var15_16 = null;
                        try {}
                        catch (IOException iOException) {}
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        break block17;
                    }
                    break block17;
                }
                File file = new File(String.valueOf(path) + File.separator + pkgPath);
                if (file.exists()) {
                    entries = file.list();
                    int i = 0;
                    while (i < entries.length) {
                        String entry = entries[i];
                        File f = new File(file, entry);
                        if (f.isDirectory()) throw new Error("SUBDIR NOT DONE=" + f);
                        if (f.getAbsolutePath().endsWith(".class")) {
                            String className = entry.substring(0, entry.length() - 6);
                            classes.add(className);
                        }
                        ++i;
                    }
                }
            }
            start = index + 1;
        }
    }

    public Class[] getClasses() {
        if (this.mainClassName == null) {
            return new Class[0];
        }
        Object[] classNames = this.getClassNames(this.mainClassName);
        Arrays.sort(classNames);
        String packageName = this.getPackageName(this.mainClassName);
        Class[] classes = new Class[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            Object className = classNames[i];
            try {
                classes[i] = Class.forName(String.valueOf(packageName) + "." + (String)className, false, this.getClass().getClassLoader());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return classes;
    }

    public Class[] getNativesClasses() {
        if (this.mainClassName == null) {
            return new Class[0];
        }
        ArrayList<Class> result = new ArrayList<Class>();
        Class[] classes = this.getClasses();
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            Method[] methods = clazz.getDeclaredMethods();
            int j = 0;
            while (j < methods.length) {
                Method method = methods[j];
                int mods = method.getModifiers();
                if ((mods & 0x100) != 0) {
                    result.add(clazz);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new Class[result.size()]);
    }

    public Class[] getStructureClasses() {
        if (this.mainClassName == null) {
            return new Class[0];
        }
        ArrayList<Class> result = new ArrayList<Class>();
        Class[] classes = this.getClasses();
        int i = 0;
        while (i < classes.length) {
            block7: {
                Class clazz = classes[i];
                Method[] methods = clazz.getDeclaredMethods();
                int j = 0;
                while (j < methods.length) {
                    Method method = methods[j];
                    int mods = method.getModifiers();
                    if ((mods & 0x100) == 0) {
                        ++j;
                        continue;
                    }
                    break block7;
                }
                Field[] fields = clazz.getFields();
                boolean hasPublicFields = false;
                int j2 = 0;
                while (j2 < fields.length) {
                    Field field = fields[j2];
                    int mods = field.getModifiers();
                    if ((mods & 1) != 0 && (mods & 8) == 0) {
                        hasPublicFields = true;
                        break;
                    }
                    ++j2;
                }
                if (hasPublicFields) {
                    result.add(clazz);
                }
            }
            ++i;
        }
        return result.toArray(new Class[result.size()]);
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setMainClassName(String str) {
        this.mainClassName = str;
        this.metaData = new MetaData(this.mainClassName);
        String mainClasses = this.getMetaData().getMetaData("swt_main_classes", null);
        if (mainClasses != null) {
            String[] list = ItemData.split(mainClasses, ",");
            int i = 0;
            while (i < list.length) {
                if (this.mainClassName.equals(list[i].trim())) {
                    this.setOutputDir(list[i + 1].trim());
                }
                i += 2;
            }
        }
        if (this.mainClassName != null) {
            try {
                this.mainClass = Class.forName(this.mainClassName, false, this.getClass().getClassLoader());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setOutputDir(String str) {
        if (str != null && !str.endsWith("\\") && !str.endsWith("/")) {
            str = String.valueOf(str) + File.separator;
        }
        this.outputDir = str;
    }

    public static String getDefaultMainClass() {
        return "org.eclipse.swt.internal." + JNIGeneratorApp.getDefaultPlatform() + ".OS";
    }

    public static String getDefaultPlatform() {
        return SWT.getPlatform();
    }

    public static void main(String[] args) {
        JNIGeneratorApp gen = new JNIGeneratorApp();
        if (args.length > 0) {
            gen.setMainClassName(args[0]);
            if (args.length > 1) {
                gen.setOutputDir(args[1]);
            }
            if (args.length > 2) {
                gen.setClasspath(args[2]);
            }
        } else {
            gen.setMainClassName(JNIGeneratorApp.getDefaultMainClass());
        }
        gen.generate();
    }
}

