/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.tools.internal.ClassData;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ProgressMonitor;

public abstract class JNIGenerator {
    Class mainClass;
    Class[] classes;
    MetaData metaData;
    boolean isCPP;
    String delimiter = System.getProperty("line.separator");
    PrintStream output = System.out;
    ProgressMonitor progress;
    static HashMap uniqueCache = new HashMap();
    static Class uniqueClassCache;
    static Method[] uniqueMethodsCache;
    static /* synthetic */ Class class$0;

    public JNIGenerator() {
        this.metaData = new MetaData(new Properties());
    }

    String fixDelimiter(String str) {
        if (this.delimiter.equals("\n")) {
            return str;
        }
        int index = 0;
        int length = str.length();
        StringBuffer buffer = new StringBuffer();
        while (index != -1) {
            int start = index;
            if ((index = str.indexOf(10, start)) == -1) {
                buffer.append(str.substring(start, length));
                continue;
            }
            buffer.append(str.substring(start, index));
            buffer.append(this.delimiter);
            ++index;
        }
        return buffer.toString();
    }

    static String getClassName(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46) + 1;
        return name.substring(index, name.length());
    }

    static String getFunctionName(Method method) {
        return JNIGenerator.getFunctionName(method, method.getParameterTypes());
    }

    static String getFunctionName(Method method, Class[] paramTypes) {
        if ((method.getModifiers() & 0x100) == 0) {
            return method.getName();
        }
        String function = JNIGenerator.toC(method.getName());
        if (!JNIGenerator.isNativeUnique(method)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(function);
            buffer.append("__");
            if (paramTypes.length > 0) {
                int i = 0;
                while (i < paramTypes.length) {
                    Class paramType = paramTypes[i];
                    buffer.append(JNIGenerator.toC(JNIGenerator.getTypeSignature(paramType)));
                    ++i;
                }
            }
            return buffer.toString();
        }
        return function;
    }

    static int getByteCount(Class clazz) {
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Boolean.TYPE) {
            return 4;
        }
        if (clazz == Long.TYPE) {
            return 8;
        }
        if (clazz == Short.TYPE) {
            return 2;
        }
        if (clazz == Character.TYPE) {
            return 2;
        }
        if (clazz == Byte.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == Double.TYPE) {
            return 8;
        }
        return 4;
    }

    static String getTypeSignature(Class clazz) {
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return "Ljava/lang/String;";
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return "[" + JNIGenerator.getTypeSignature(componentType);
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    static String getTypeSignature1(Class clazz) {
        if (clazz == Void.TYPE) {
            return "Void";
        }
        if (clazz == Integer.TYPE) {
            return "Int";
        }
        if (clazz == Boolean.TYPE) {
            return "Boolean";
        }
        if (clazz == Long.TYPE) {
            return "Long";
        }
        if (clazz == Short.TYPE) {
            return "Short";
        }
        if (clazz == Character.TYPE) {
            return "Char";
        }
        if (clazz == Byte.TYPE) {
            return "Byte";
        }
        if (clazz == Float.TYPE) {
            return "Float";
        }
        if (clazz == Double.TYPE) {
            return "Double";
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return "String";
        }
        return "Object";
    }

    static String getTypeSignature2(Class clazz) {
        if (clazz == Void.TYPE) {
            return "void";
        }
        if (clazz == Integer.TYPE) {
            return "jint";
        }
        if (clazz == Boolean.TYPE) {
            return "jboolean";
        }
        if (clazz == Long.TYPE) {
            return "jlong";
        }
        if (clazz == Short.TYPE) {
            return "jshort";
        }
        if (clazz == Character.TYPE) {
            return "jchar";
        }
        if (clazz == Byte.TYPE) {
            return "jbyte";
        }
        if (clazz == Float.TYPE) {
            return "jfloat";
        }
        if (clazz == Double.TYPE) {
            return "jdouble";
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return "jstring";
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return String.valueOf(JNIGenerator.getTypeSignature2(componentType)) + "Array";
        }
        return "jobject";
    }

    static String getTypeSignature3(Class clazz) {
        if (clazz == Void.TYPE) {
            return "void";
        }
        if (clazz == Integer.TYPE) {
            return "int";
        }
        if (clazz == Boolean.TYPE) {
            return "boolean";
        }
        if (clazz == Long.TYPE) {
            return "long";
        }
        if (clazz == Short.TYPE) {
            return "short";
        }
        if (clazz == Character.TYPE) {
            return "char";
        }
        if (clazz == Byte.TYPE) {
            return "byte";
        }
        if (clazz == Float.TYPE) {
            return "float";
        }
        if (clazz == Double.TYPE) {
            return "double";
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return "String";
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return String.valueOf(JNIGenerator.getTypeSignature3(componentType)) + "[]";
        }
        return clazz.getName();
    }

    static String getTypeSignature4(Class clazz) {
        if (clazz == Void.TYPE) {
            return "void";
        }
        if (clazz == Integer.TYPE) {
            return "jint";
        }
        if (clazz == Boolean.TYPE) {
            return "jboolean";
        }
        if (clazz == Long.TYPE) {
            return "jlong";
        }
        if (clazz == Short.TYPE) {
            return "jshort";
        }
        if (clazz == Character.TYPE) {
            return "jchar";
        }
        if (clazz == Byte.TYPE) {
            return "jbyte";
        }
        if (clazz == Float.TYPE) {
            return "jfloat";
        }
        if (clazz == Double.TYPE) {
            return "jdouble";
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return "jstring";
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return String.valueOf(JNIGenerator.getTypeSignature4(componentType)) + " *";
        }
        return String.valueOf(JNIGenerator.getClassName(clazz)) + " *";
    }

    static synchronized boolean isNativeUnique(Method method) {
        Method[] methods;
        if ((method.getModifiers() & 0x100) == 0) {
            return false;
        }
        Object unique = uniqueCache.get(method);
        if (unique != null) {
            return (Boolean)unique;
        }
        boolean result = true;
        String name = method.getName();
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.equals(uniqueClassCache)) {
            methods = uniqueMethodsCache;
        } else {
            methods = clazz.getDeclaredMethods();
            uniqueClassCache = clazz;
            uniqueMethodsCache = methods;
        }
        int i = 0;
        while (i < methods.length) {
            Method mth = methods[i];
            if ((mth.getModifiers() & 0x100) != 0 && method != mth && !method.equals(mth) && name.equals(mth.getName())) {
                result = false;
                break;
            }
            ++i;
        }
        uniqueCache.put(method, new Boolean(result));
        return result;
    }

    static void sort(Method[] methods) {
        Arrays.sort(methods, new Comparator(){

            public int compare(Object a, Object b) {
                Method mth1 = (Method)a;
                Method mth2 = (Method)b;
                int result = mth1.getName().compareTo(mth2.getName());
                return result != 0 ? result : JNIGenerator.getFunctionName(mth1).compareTo(JNIGenerator.getFunctionName(mth2));
            }
        });
    }

    static void sort(Field[] fields) {
        Arrays.sort(fields, new Comparator(){

            public int compare(Object a, Object b) {
                return ((Field)a).getName().compareTo(((Field)b).getName());
            }
        });
    }

    static void sort(Class[] classes) {
        Arrays.sort(classes, new Comparator(){

            public int compare(Object a, Object b) {
                return ((Class)a).getName().compareTo(((Class)b).getName());
            }
        });
    }

    static String toC(String str) {
        int length = str.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            switch (c) {
                case '_': {
                    buffer.append("_1");
                    break;
                }
                case ';': {
                    buffer.append("_2");
                    break;
                }
                case '[': {
                    buffer.append("_3");
                    break;
                }
                case '.': {
                    buffer.append("_");
                    break;
                }
                case '/': {
                    buffer.append("_");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public abstract void generate(Class var1);

    public void generateCopyright() {
    }

    public void generateIncludes() {
    }

    public void generate() {
        Class clazz;
        if (this.classes == null) {
            return;
        }
        this.generateCopyright();
        this.generateIncludes();
        JNIGenerator.sort(this.classes);
        int i = 0;
        while (i < this.classes.length) {
            clazz = this.classes[i];
            ClassData data = this.getMetaData().getMetaData(clazz);
            if (data.getFlag("cpp")) {
                this.isCPP = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.classes.length) {
            clazz = this.classes[i];
            if (this.getGenerate(clazz)) {
                this.generate(clazz);
            }
            if (this.progress != null) {
                this.progress.step();
            }
            ++i;
        }
        this.output.flush();
    }

    public void generateMetaData(String key) {
        MetaData mt = this.getMetaData();
        String data = mt.getMetaData(key, null);
        if (data == null) {
            return;
        }
        if (data.length() == 0) {
            return;
        }
        this.outputln(this.fixDelimiter(data));
    }

    public Class[] getClasses() {
        return this.classes;
    }

    protected boolean getGenerate(Class clazz) {
        ClassData data = this.getMetaData().getMetaData(clazz);
        return !data.getFlag("no_gen");
    }

    public boolean getCPP() {
        return this.isCPP;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getExtension() {
        return this.getCPP() ? ".cpp" : ".c";
    }

    public String getFileName() {
        return String.valueOf(this.getOutputName()) + this.getSuffix() + this.getExtension();
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public String getOutputName() {
        return JNIGenerator.getClassName(this.getMainClass()).toLowerCase();
    }

    public Class getMainClass() {
        return this.mainClass;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public String getPlatform() {
        return SWT.getPlatform();
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progress;
    }

    public String getSuffix() {
        return "";
    }

    public void output(String str) {
        this.output.print(str);
    }

    public void outputln() {
        this.output(this.getDelimiter());
    }

    public void outputln(String str) {
        this.output(str);
        this.output(this.getDelimiter());
    }

    public void setClasses(Class[] classes) {
        this.classes = classes;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setMainClass(Class mainClass) {
        this.mainClass = mainClass;
    }

    public void setMetaData(MetaData data) {
        this.metaData = data;
    }

    public void setOutput(PrintStream output) {
        this.output = output;
    }

    public void setProgressMonitor(ProgressMonitor progress) {
        this.progress = progress;
    }
}

