/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.launcher;

public class Main {
    private static final String ENDSPLASH = "-endsplash";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String EXITDATA = "-exitdata";
    private static final String FEATURE = "-feature";
    private static final String DEBUG = "-debug";
    private static final String VM = "-vm";
    private static final String VMARGS = "-vmargs";
    private static String showSplashCmd = null;
    private static String endSplashCmd = null;
    private static String exitDataCmd = null;
    private static Process splashProcess = null;
    private static String featureDir = null;
    private static String vm = null;
    private static int vmargsIndex = 0;
    private static boolean debug = false;

    private static String getSplashPath() {
        return featureDir;
    }

    public static void endSplash() {
        if (splashProcess != null) {
            splashProcess.destroy();
        } else if (endSplashCmd != null) {
            try {
                if (debug) {
                    System.out.println("Eclipse: Executing '" + endSplashCmd + "'");
                }
                Runtime.getRuntime().exec(endSplashCmd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void showSplash() {
        block6: {
            if (showSplashCmd == null) {
                return;
            }
            String path = Main.getSplashPath();
            String[] cmd = new String[path != null ? 4 : 3];
            int sIndex = 0;
            int eIndex = showSplashCmd.indexOf(" -show");
            cmd[0] = showSplashCmd.substring(sIndex, eIndex);
            sIndex = eIndex + 1;
            eIndex = showSplashCmd.indexOf(" ", sIndex);
            cmd[1] = showSplashCmd.substring(sIndex, eIndex);
            cmd[2] = showSplashCmd.substring(eIndex + 1);
            if (path != null) {
                cmd[3] = path;
            }
            try {
                if (debug) {
                    System.out.print("Eclipse: Executing");
                    int i = 0;
                    while (i < cmd.length) {
                        System.out.print(" " + cmd[i]);
                        ++i;
                    }
                    System.out.println("");
                }
                splashProcess = Runtime.getRuntime().exec(cmd);
            }
            catch (Exception e) {
                if (!debug) break block6;
                System.out.println("Eclipse: Exception in showSplash\n" + e);
            }
        }
    }

    private static void setSharedData(String data, String[] args) {
        block11: {
            if (exitDataCmd == null) {
                return;
            }
            if (data == null) {
                String string;
                StringBuffer buf = new StringBuffer();
                buf.append(vm);
                buf.append('\n');
                int i = vmargsIndex;
                while (i < args.length) {
                    String string2 = args[i];
                    buf.append(string2);
                    buf.append('\n');
                    ++i;
                }
                String[] newArgs = new String[]{"-data", "/home/eclipse/newdata"};
                int i2 = 0;
                while (i2 < newArgs.length) {
                    string = newArgs[i2];
                    buf.append(string);
                    buf.append('\n');
                    ++i2;
                }
                i2 = 0;
                while (i2 < args.length) {
                    string = args[i2];
                    buf.append(string);
                    buf.append('\n');
                    ++i2;
                }
                data = buf.toString();
            }
            String[] cmd = new String[data != null ? 4 : 3];
            int sIndex = 0;
            int eIndex = exitDataCmd.indexOf(" -exitdata");
            cmd[0] = exitDataCmd.substring(sIndex, eIndex);
            sIndex = eIndex + 1;
            eIndex = exitDataCmd.indexOf(" ", sIndex);
            cmd[1] = exitDataCmd.substring(sIndex, eIndex);
            cmd[2] = exitDataCmd.substring(eIndex + 1);
            if (data != null) {
                cmd[3] = data;
            }
            try {
                if (debug) {
                    System.out.print("Eclipse: Executing");
                    int i = 0;
                    while (i < cmd.length) {
                        System.out.print(" " + cmd[i]);
                        ++i;
                    }
                    System.out.println("");
                }
                Process sharedProcess = Runtime.getRuntime().exec(cmd);
                sharedProcess.waitFor();
                if (debug) {
                    System.out.println("done");
                }
            }
            catch (Exception e) {
                if (!debug) break block11;
                System.out.println("Eclipse: Exception in showSplash\n" + e);
            }
        }
    }

    public static void main(String[] args) {
        int nRead;
        byte[] answer = new byte[500];
        boolean console = true;
        int index = 0;
        while (index < args.length) {
            if (args[index].equalsIgnoreCase(ENDSPLASH) && index + 1 < args.length) {
                endSplashCmd = args[index + 1];
            } else if (args[index].equalsIgnoreCase(SHOWSPLASH) && index + 1 < args.length) {
                showSplashCmd = args[index + 1];
            } else if (args[index].equalsIgnoreCase(EXITDATA) && index + 1 < args.length) {
                exitDataCmd = args[index + 1];
            } else if (args[index].equalsIgnoreCase(FEATURE) && index + 1 < args.length) {
                featureDir = args[index + 1];
            } else if (args[index].equalsIgnoreCase(VM) && index + 1 < args.length) {
                vm = args[index + 1];
            } else {
                if (args[index].equalsIgnoreCase(VMARGS) && index + 1 < args.length) {
                    vmargsIndex = index + 1;
                    break;
                }
                if (args[index].equalsIgnoreCase(DEBUG)) {
                    debug = true;
                }
            }
            ++index;
        }
        if (debug) {
            System.out.println("Eclipse: Program started.");
            index = 0;
            while (index < args.length) {
                System.out.println("    args[" + index + "] = '" + args[index] + "'");
                ++index;
            }
        }
        Main.showSplash();
        if (debug) {
            try {
                System.out.print("Eclipse: Hit return to end initialization. ");
                nRead = System.in.read(answer);
            }
            catch (Exception e) {}
        } else {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Main.endSplash();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (debug) {
            int exitCode = 0;
            try {
                System.out.println("Eclipse special exit codes:\n  0  - normal exit\n  13 - problem during startup\n  14 - wrong JVM being used\n  15 - workbench already running\n  16 - display error message in shared data\n  23 - restart previous command\n  24 - restart command shared data");
                System.out.print("Eclipse: Enter the exit code: ");
                nRead = System.in.read(answer);
                String value = new String(answer).trim();
                if (value.length() > 0) {
                    exitCode = Integer.parseInt(value);
                    switch (exitCode) {
                        case 13: {
                            Main.setSharedData("Problem during startup.", null);
                            exitCode = 16;
                            break;
                        }
                        case 14: {
                            Main.setSharedData("Wrong VM version > 1.3.1.", null);
                            exitCode = 16;
                            break;
                        }
                        case 15: {
                            Main.setSharedData("Workspace already in use.", null);
                            exitCode = 16;
                            break;
                        }
                        case 24: {
                            Main.setSharedData(null, args);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(exitCode);
        }
    }
}

