/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tools.internal.ClassData;
import org.eclipse.swt.tools.internal.ConstantsGenerator;
import org.eclipse.swt.tools.internal.FieldData;
import org.eclipse.swt.tools.internal.ItemData;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIGeneratorApp;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.MetaDataGenerator;
import org.eclipse.swt.tools.internal.MethodData;
import org.eclipse.swt.tools.internal.NativesGenerator;
import org.eclipse.swt.tools.internal.ParameterData;
import org.eclipse.swt.tools.internal.SizeofGenerator;
import org.eclipse.swt.tools.internal.StructsGenerator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class JNIGeneratorAppUI {
    Display display;
    Shell shell;
    Combo mainClassCb;
    Combo outputDirCb;
    Table classesLt;
    Table membersLt;
    Table paramsLt;
    FileDialog fileDialog;
    TableEditor paramTextEditor;
    TableEditor paramListEditor;
    TableEditor memberTextEditor;
    TableEditor memberListEditor;
    TableEditor classTextEditor;
    TableEditor classListEditor;
    Text paramEditorTx;
    Text memberEditorTx;
    Text classEditorTx;
    List paramEditorLt;
    List memberEditorLt;
    List classEditorLt;
    JNIGeneratorApp app;
    static final int CLASS_NAME_COLUMN = 0;
    static final int CLASS_EXCLUDE_COLUMN = 1;
    static final int FIELD_NAME_COLUMN = 0;
    static final int FIELD_CAST_COLUMN = 1;
    static final int FIELD_ACCESSOR_COLUMN = 2;
    static final int FIELD_FLAGS_COLUMN = 3;
    static final int FIELD_EXCLUDE_COLUMN = 4;
    static final int METHOD_NAME_COLUMN = 0;
    static final int METHOD_FLAGS_COLUMN = 1;
    static final int METHOD_EXCLUDE_COLUMN = 2;
    static final int PARAM_INDEX_COLUMN = 0;
    static final int PARAM_TYPE_COLUMN = 1;
    static final int PARAM_CAST_COLUMN = 2;
    static final int PARAM_FLAGS_COLUMN = 3;

    public JNIGeneratorAppUI() {
        this(new JNIGeneratorApp());
    }

    public JNIGeneratorAppUI(JNIGeneratorApp app) {
        this.app = app;
    }

    void cleanup() {
    }

    void generateStructsHeader() {
        StructsGenerator gen = new StructsGenerator();
        gen.setMetaData(this.app.getMetaData());
        Class[] classes = this.getSelectedClasses();
        gen.generateHeaderFile(classes);
    }

    void generateStructs() {
        StructsGenerator gen = new StructsGenerator();
        gen.setMetaData(this.app.getMetaData());
        Class[] classes = this.getSelectedClasses();
        gen.generateSourceFile(classes);
    }

    void generateSizeof() {
        SizeofGenerator gen = new SizeofGenerator();
        gen.setMetaData(this.app.getMetaData());
        gen.generate(this.getSelectedClasses());
    }

    void generateMetaData() {
        MetaDataGenerator gen = new MetaDataGenerator();
        gen.setMetaData(this.app.getMetaData());
        Method[] methods = this.getSelectedMethods();
        if (methods.length != 0) {
            gen.generate(methods);
        } else {
            gen.generate(this.getSelectedClasses());
        }
    }

    void generateNatives() {
        NativesGenerator gen = new NativesGenerator();
        gen.setMetaData(this.app.getMetaData());
        Method[] methods = this.getSelectedMethods();
        if (methods.length != 0) {
            gen.generate(methods);
        } else {
            gen.generate(this.getSelectedClasses());
        }
    }

    void generateConstants() {
        ConstantsGenerator gen = new ConstantsGenerator();
        gen.setMetaData(this.app.getMetaData());
        Field[] fields = this.getSelectedFields();
        if (fields.length != 0) {
            gen.generate(fields);
        } else {
            gen.generate(this.getSelectedClasses());
        }
    }

    Class[] getSelectedClasses() {
        TableItem[] items = this.classesLt.getSelection();
        Class[] classes = new Class[items.length];
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            classes[i] = ((ClassData)item.getData()).getClazz();
            ++i;
        }
        return classes;
    }

    Method[] getSelectedMethods() {
        TableItem[] selection = this.membersLt.getSelection();
        Method[] methods = new Method[selection.length];
        int count = 0;
        int i = 0;
        while (i < selection.length) {
            TableItem item = selection[i];
            Object data = item.getData();
            if (data instanceof MethodData) {
                Method method = ((MethodData)data).getMethod();
                methods[count++] = method;
            }
            ++i;
        }
        if (count != methods.length) {
            Method[] result = new Method[count];
            System.arraycopy(methods, 0, result, 0, count);
            methods = result;
        }
        return methods;
    }

    Field[] getSelectedFields() {
        TableItem[] selection = this.membersLt.getSelection();
        Field[] fields = new Field[selection.length];
        int count = 0;
        int i = 0;
        while (i < selection.length) {
            TableItem item = selection[i];
            Object data = item.getData();
            if (data instanceof FieldData) {
                Field field = ((FieldData)data).getField();
                fields[count++] = field;
            }
            ++i;
        }
        if (count != fields.length) {
            Field[] result = new Field[count];
            System.arraycopy(fields, 0, result, 0, count);
            fields = result;
        }
        return fields;
    }

    public void open() {
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setText("JNI Generator");
        GridLayout shellLayout = new GridLayout();
        shellLayout.numColumns = 2;
        this.shell.setLayout((Layout)shellLayout);
        Composite panel = new Composite((Composite)this.shell, 0);
        GridData data = new GridData(1808);
        panel.setLayoutData((Object)data);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 1;
        panel.setLayout((Layout)panelLayout);
        Listener updateMainClassListener = new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.updateMainClass();
                if (!JNIGeneratorAppUI.this.updateOutputDir()) {
                    return;
                }
                JNIGeneratorAppUI.this.updateClasses();
                JNIGeneratorAppUI.this.updateMembers();
                JNIGeneratorAppUI.this.updateParameters();
            }
        };
        this.createMainClassPanel(panel, updateMainClassListener);
        this.createOutputDirPanel(panel, updateMainClassListener);
        this.createClassesPanel(panel);
        this.createMembersPanel(panel);
        this.createParametersPanel(panel);
        this.createActionButtons((Composite)this.shell);
        Point preferredSize = this.shell.computeSize(-1, -1);
        this.shell.setSize(this.shell.getSize().x, preferredSize.y);
        ((GridData)this.classesLt.getLayoutData()).heightHint = -1;
        ((GridData)this.membersLt.getLayoutData()).heightHint = -1;
        ((GridData)this.paramsLt.getLayoutData()).heightHint = -1;
        this.updateMainClass();
        this.updateClasses();
        this.updateMembers();
        this.updateParameters();
    }

    void createMainClassPanel(Composite panel, Listener updateListener) {
        Label mainClassLb = new Label(panel, 0);
        mainClassLb.setText("Main Class:");
        this.mainClassCb = new Combo(panel, 4);
        String mainClass = this.app.getMainClass();
        this.mainClassCb.setText(mainClass == null ? "" : mainClass);
        GridData data = new GridData(768);
        this.mainClassCb.setLayoutData((Object)data);
        this.mainClassCb.addListener(13, updateListener);
        this.mainClassCb.addListener(14, updateListener);
    }

    void createOutputDirPanel(Composite panel, Listener updateListener) {
        Label outputDirLb = new Label(panel, 0);
        outputDirLb.setText("Output Dir:");
        this.outputDirCb = new Combo(panel, 4);
        String outputDir = this.app.getOutputDir();
        this.outputDirCb.setText(outputDir == null ? "" : outputDir);
        GridData data = new GridData(768);
        this.outputDirCb.setLayoutData((Object)data);
        this.outputDirCb.addListener(13, updateListener);
        this.outputDirCb.addListener(14, updateListener);
    }

    void createClassesPanel(Composite panel) {
        Label classesLb = new Label(panel, 0);
        classesLb.setText("Classes:");
        this.classesLt = new Table(panel, 68386);
        GridData data = new GridData(1808);
        data.heightHint = this.classesLt.getItemHeight() * 6;
        this.classesLt.setLayoutData((Object)data);
        this.classesLt.setHeaderVisible(true);
        this.classesLt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 32) {
                    JNIGeneratorAppUI.this.updateGenerate((TableItem)e.item);
                } else {
                    JNIGeneratorAppUI.this.updateMembers();
                    JNIGeneratorAppUI.this.updateParameters();
                }
            }
        });
        TableColumn column = new TableColumn(this.classesLt, 0, 0);
        column.setText("Class");
    }

    void createMembersPanel(Composite panel) {
        Label membersLb = new Label(panel, 0);
        membersLb.setText("Members:");
        this.membersLt = new Table(panel, 68386);
        GridData data = new GridData(1808);
        data.heightHint = this.membersLt.getItemHeight() * 6;
        this.membersLt.setLayoutData((Object)data);
        this.membersLt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 32) {
                    JNIGeneratorAppUI.this.updateGenerate((TableItem)e.item);
                } else {
                    JNIGeneratorAppUI.this.updateParameters();
                }
            }
        });
        this.memberTextEditor = new TableEditor(this.membersLt);
        this.memberTextEditor.grabHorizontal = true;
        this.memberEditorTx = new Text((Composite)this.membersLt, 4);
        this.memberTextEditor.setEditor((Control)this.memberEditorTx);
        Listener memberTextListener = new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.memberEditorTx.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.memberTextEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.memberTextEditor.getColumn();
                ItemData memberData = (ItemData)item.getData();
                String text = JNIGeneratorAppUI.this.memberEditorTx.getText();
                MetaData metaData = JNIGeneratorAppUI.this.app.getMetaData();
                if (memberData instanceof FieldData) {
                    FieldData fieldData = (FieldData)memberData;
                    switch (column) {
                        case 1: {
                            fieldData.setCast(text);
                            item.setText(column, fieldData.getCast());
                            break;
                        }
                        case 2: {
                            fieldData.setAccessor(text);
                            item.setText(column, fieldData.getAccessor());
                            break;
                        }
                        case 4: {
                            fieldData.setExclude(text);
                            item.setText(column, fieldData.getExclude());
                        }
                    }
                    metaData.setMetaData(fieldData.getField(), fieldData);
                    JNIGeneratorAppUI.this.membersLt.getColumn(column).pack();
                } else if (memberData instanceof MethodData) {
                    MethodData methodData = (MethodData)memberData;
                    switch (column) {
                        case 2: {
                            methodData.setExclude(text);
                            item.setText(column, methodData.getExclude());
                        }
                    }
                    metaData.setMetaData(methodData.getMethod(), methodData);
                    JNIGeneratorAppUI.this.membersLt.getColumn(column).pack();
                }
            }
        };
        this.memberEditorTx.addListener(14, memberTextListener);
        this.memberEditorTx.addListener(16, memberTextListener);
        this.memberListEditor = new TableEditor(this.membersLt);
        this.memberEditorLt = new List((Composite)this.membersLt, 2050);
        this.memberListEditor.setEditor((Control)this.memberEditorLt);
        Listener memberListListener = new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.memberEditorLt.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.memberListEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.memberListEditor.getColumn();
                ItemData data = (ItemData)item.getData();
                String[] flags = JNIGeneratorAppUI.this.memberEditorLt.getSelection();
                data.setFlags(flags);
                item.setText(column, JNIGeneratorAppUI.this.getFlagsString(data.getFlags()));
                item.setChecked(data.isGenerate());
                MetaData metaData = JNIGeneratorAppUI.this.app.getMetaData();
                if (data instanceof FieldData) {
                    FieldData fieldData = (FieldData)data;
                    metaData.setMetaData(fieldData.getField(), fieldData);
                    JNIGeneratorAppUI.this.membersLt.getColumn(column).pack();
                } else if (data instanceof MethodData) {
                    MethodData methodData = (MethodData)data;
                    metaData.setMetaData(methodData.getMethod(), methodData);
                    JNIGeneratorAppUI.this.membersLt.getColumn(column).pack();
                }
            }
        };
        this.memberEditorLt.addListener(14, memberListListener);
        this.memberEditorLt.addListener(16, memberListListener);
        this.membersLt.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (e.button != 1) {
                    return;
                }
                Point pt = new Point(e.x, e.y);
                TableItem item = JNIGeneratorAppUI.this.membersLt.getItem(pt);
                if (item == null) {
                    return;
                }
                int column = -1;
                int i = 0;
                while (i < JNIGeneratorAppUI.this.membersLt.getColumnCount()) {
                    if (item.getBounds(i).contains(pt)) {
                        column = i;
                        break;
                    }
                    ++i;
                }
                if (column == -1) {
                    return;
                }
                ItemData itemData = (ItemData)item.getData();
                if (itemData instanceof FieldData) {
                    FieldData data = (FieldData)itemData;
                    if (column == 1 || column == 2 || column == 4) {
                        JNIGeneratorAppUI.this.memberTextEditor.setColumn(column);
                        JNIGeneratorAppUI.this.memberTextEditor.setItem(item);
                        String text = "";
                        switch (column) {
                            case 1: {
                                text = data.getCast();
                                break;
                            }
                            case 2: {
                                text = data.getAccessor();
                                break;
                            }
                            case 4: {
                                text = data.getExclude();
                            }
                        }
                        JNIGeneratorAppUI.this.memberEditorTx.setText(text);
                        JNIGeneratorAppUI.this.memberEditorTx.selectAll();
                        JNIGeneratorAppUI.this.memberEditorTx.setVisible(true);
                        JNIGeneratorAppUI.this.memberEditorTx.setFocus();
                    } else if (column == 3) {
                        JNIGeneratorAppUI.this.memberListEditor.verticalAlignment = JNIGeneratorAppUI.this.membersLt.getClientArea().contains(pt.x, pt.y + JNIGeneratorAppUI.this.memberEditorLt.getSize().y) ? 128 : 1024;
                        JNIGeneratorAppUI.this.memberListEditor.setColumn(column);
                        JNIGeneratorAppUI.this.memberListEditor.setItem(item);
                        JNIGeneratorAppUI.this.memberEditorLt.setItems(FieldData.getAllFlags());
                        Point size = JNIGeneratorAppUI.this.memberEditorLt.computeSize(-1, -1);
                        JNIGeneratorAppUI.this.memberListEditor.minimumWidth = size.x;
                        JNIGeneratorAppUI.this.memberListEditor.minimumHeight = size.y;
                        JNIGeneratorAppUI.this.memberEditorLt.setSelection(data.getFlags());
                        JNIGeneratorAppUI.this.memberEditorLt.setVisible(true);
                        JNIGeneratorAppUI.this.memberEditorLt.setFocus();
                    }
                } else if (itemData instanceof MethodData) {
                    MethodData data = (MethodData)itemData;
                    if (column == 2) {
                        JNIGeneratorAppUI.this.memberTextEditor.setColumn(column);
                        JNIGeneratorAppUI.this.memberTextEditor.setItem(item);
                        JNIGeneratorAppUI.this.memberEditorTx.setText(data.getExclude());
                        JNIGeneratorAppUI.this.memberEditorTx.selectAll();
                        JNIGeneratorAppUI.this.memberEditorTx.setVisible(true);
                        JNIGeneratorAppUI.this.memberEditorTx.setFocus();
                    } else if (column == 1) {
                        JNIGeneratorAppUI.this.memberListEditor.verticalAlignment = JNIGeneratorAppUI.this.membersLt.getClientArea().contains(pt.x, pt.y + JNIGeneratorAppUI.this.memberEditorLt.getSize().y) ? 128 : 1024;
                        JNIGeneratorAppUI.this.memberListEditor.setColumn(column);
                        JNIGeneratorAppUI.this.memberListEditor.setItem(item);
                        JNIGeneratorAppUI.this.memberEditorLt.setItems(MethodData.getAllFlags());
                        Point size = JNIGeneratorAppUI.this.memberEditorLt.computeSize(-1, -1);
                        JNIGeneratorAppUI.this.memberListEditor.minimumWidth = size.x;
                        JNIGeneratorAppUI.this.memberListEditor.minimumHeight = size.y;
                        JNIGeneratorAppUI.this.memberEditorLt.setSelection(data.getFlags());
                        JNIGeneratorAppUI.this.memberEditorLt.setVisible(true);
                        JNIGeneratorAppUI.this.memberEditorLt.setFocus();
                    }
                }
            }
        });
    }

    void createParametersPanel(Composite panel) {
        Label paramsLb = new Label(panel, 0);
        paramsLb.setText("Parameters:");
        this.paramsLt = new Table(panel, 68354);
        GridData data = new GridData(1808);
        int itemHeight = this.paramsLt.getItemHeight();
        data.heightHint = itemHeight * 6;
        this.paramsLt.setLayoutData((Object)data);
        this.paramsLt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 32) {
                    JNIGeneratorAppUI.this.updateGenerate((TableItem)e.item);
                }
            }
        });
        TableColumn column = new TableColumn(this.paramsLt, 0, 0);
        column = new TableColumn(this.paramsLt, 0, 1);
        column.setText("Type");
        column = new TableColumn(this.paramsLt, 0, 2);
        column.setText("Cast");
        column = new TableColumn(this.paramsLt, 0, 3);
        column.setText("Flags");
        this.paramTextEditor = new TableEditor(this.paramsLt);
        this.paramTextEditor.grabHorizontal = true;
        this.paramEditorTx = new Text((Composite)this.paramsLt, 4);
        this.paramTextEditor.setEditor((Control)this.paramEditorTx);
        Listener paramTextListener = new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.paramEditorTx.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.paramTextEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.paramTextEditor.getColumn();
                ParameterData paramData = (ParameterData)item.getData();
                if (column == 2) {
                    String text = JNIGeneratorAppUI.this.paramEditorTx.getText();
                    paramData.setCast(text);
                    item.setText(column, paramData.getCast());
                    MetaData metaData = JNIGeneratorAppUI.this.app.getMetaData();
                    metaData.setMetaData(paramData.getMethod(), paramData.getParameter(), paramData);
                    JNIGeneratorAppUI.this.paramsLt.getColumn(column).pack();
                }
            }
        };
        this.paramEditorTx.addListener(14, paramTextListener);
        this.paramEditorTx.addListener(16, paramTextListener);
        this.paramListEditor = new TableEditor(this.paramsLt);
        this.paramEditorLt = new List((Composite)this.paramsLt, 2050);
        this.paramEditorLt.setItems(ParameterData.getAllFlags());
        Point size = this.paramEditorLt.computeSize(-1, -1);
        this.paramListEditor.minimumWidth = size.x;
        this.paramListEditor.minimumHeight = size.y;
        this.paramListEditor.setEditor((Control)this.paramEditorLt);
        Listener paramListListener = new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.paramEditorLt.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.paramListEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.paramListEditor.getColumn();
                ParameterData paramData = (ParameterData)item.getData();
                if (column == 3) {
                    String[] flags = JNIGeneratorAppUI.this.paramEditorLt.getSelection();
                    paramData.setFlags(flags);
                    item.setText(column, JNIGeneratorAppUI.this.getFlagsString(paramData.getFlags()));
                    MetaData metaData = JNIGeneratorAppUI.this.app.getMetaData();
                    metaData.setMetaData(paramData.getMethod(), paramData.getParameter(), paramData);
                    JNIGeneratorAppUI.this.paramsLt.getColumn(column).pack();
                }
            }
        };
        this.paramEditorLt.addListener(14, paramListListener);
        this.paramEditorLt.addListener(16, paramListListener);
        this.paramsLt.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (e.button != 1) {
                    return;
                }
                Point pt = new Point(e.x, e.y);
                TableItem item = JNIGeneratorAppUI.this.paramsLt.getItem(pt);
                if (item == null) {
                    return;
                }
                int column = -1;
                int i = 0;
                while (i < JNIGeneratorAppUI.this.paramsLt.getColumnCount()) {
                    if (item.getBounds(i).contains(pt)) {
                        column = i;
                        break;
                    }
                    ++i;
                }
                if (column == -1) {
                    return;
                }
                ParameterData data = (ParameterData)item.getData();
                if (column == 2) {
                    JNIGeneratorAppUI.this.paramTextEditor.setColumn(column);
                    JNIGeneratorAppUI.this.paramTextEditor.setItem(item);
                    JNIGeneratorAppUI.this.paramEditorTx.setText(data.getCast());
                    JNIGeneratorAppUI.this.paramEditorTx.selectAll();
                    JNIGeneratorAppUI.this.paramEditorTx.setVisible(true);
                    JNIGeneratorAppUI.this.paramEditorTx.setFocus();
                } else if (column == 3) {
                    JNIGeneratorAppUI.this.paramListEditor.verticalAlignment = JNIGeneratorAppUI.this.paramsLt.getClientArea().contains(pt.x, pt.y + JNIGeneratorAppUI.this.paramEditorLt.getSize().y) ? 128 : 1024;
                    JNIGeneratorAppUI.this.paramListEditor.setColumn(column);
                    JNIGeneratorAppUI.this.paramListEditor.setItem(item);
                    JNIGeneratorAppUI.this.paramEditorLt.setSelection(data.getFlags());
                    JNIGeneratorAppUI.this.paramEditorLt.setVisible(true);
                    JNIGeneratorAppUI.this.paramEditorLt.setFocus();
                }
            }
        });
    }

    Button createActionButton(Composite parent, String text, Listener listener) {
        Button action = new Button(parent, 8);
        action.setText(text);
        GridData data = new GridData(768);
        action.setLayoutData((Object)data);
        action.addListener(13, listener);
        return action;
    }

    void createActionButtons(Composite parent) {
        Composite actionsPanel = new Composite(parent, 0);
        GridData data = new GridData(1040);
        actionsPanel.setLayoutData((Object)data);
        GridLayout actionsLayout = new GridLayout();
        actionsLayout.numColumns = 1;
        actionsPanel.setLayout((Layout)actionsLayout);
        this.createActionButton(actionsPanel, "Generate All", new Listener(){

            public void handleEvent(Event e) {
                if (!JNIGeneratorAppUI.this.updateOutputDir()) {
                    return;
                }
                Cursor cursor = new Cursor((Device)JNIGeneratorAppUI.this.shell.getDisplay(), 1);
                JNIGeneratorAppUI.this.shell.setCursor(cursor);
                JNIGeneratorAppUI.this.app.generate();
                JNIGeneratorAppUI.this.shell.setCursor(null);
                cursor.dispose();
            }
        });
        Label separator = new Label(actionsPanel, 258);
        data = new GridData(768);
        separator.setLayoutData((Object)data);
        separator = new Label(actionsPanel, 258);
        data = new GridData(768);
        separator.setLayoutData((Object)data);
        this.createActionButton(actionsPanel, "Generate Structs Header", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateStructsHeader();
            }
        });
        this.createActionButton(actionsPanel, "Generate Structs", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateStructs();
            }
        });
        this.createActionButton(actionsPanel, "Generate Natives", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateNatives();
            }
        });
        this.createActionButton(actionsPanel, "Generate Constants", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateConstants();
            }
        });
        this.createActionButton(actionsPanel, "Generate Sizeof", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateSizeof();
            }
        });
        this.createActionButton(actionsPanel, "Generate Meta Data", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateMetaData();
            }
        });
    }

    public void run() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.cleanup();
    }

    String getPackageString(String className) {
        int dot = this.app.getMainClass().lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return this.app.getMainClass().substring(0, dot);
    }

    String getClassString(Class clazz) {
        String name = JNIGenerator.getTypeSignature3(clazz);
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1, name.length());
    }

    String getFlagsString(String[] flags) {
        if (flags.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        while (j < flags.length) {
            String flag = flags[j];
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            buffer.append(flag);
            ++j;
        }
        return buffer.toString();
    }

    String getMethodString(Method method) {
        String pkgName = this.getPackageString(method.getDeclaringClass().getName());
        StringBuffer buffer = new StringBuffer();
        buffer.append(method.getName());
        buffer.append("(");
        Class<?>[] params = method.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            String string;
            Class<?> param = params[i];
            if (i != 0) {
                buffer.append(",");
            }
            if ((string = JNIGenerator.getTypeSignature3(param)).startsWith(pkgName)) {
                string = string.substring(pkgName.length() + 1);
            }
            buffer.append(string);
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    String getFieldString(Field field) {
        return field.getName();
    }

    void updateClasses() {
        this.classesLt.removeAll();
        MetaData metaData = this.app.getMetaData();
        Class[] classes = this.app.getClasses();
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            ClassData classData = metaData.getMetaData(clazz);
            TableItem item = new TableItem(this.classesLt, 0);
            item.setData((Object)classData);
            item.setText(0, this.getClassString(clazz));
            item.setChecked(classData.isGenerate());
            ++i;
        }
        TableColumn[] columns = this.classesLt.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            TableColumn column = columns[i2];
            column.pack();
            ++i2;
        }
    }

    void updateMembers() {
        TableColumn column;
        this.membersLt.removeAll();
        MetaData metaData = this.app.getMetaData();
        this.membersLt.setHeaderVisible(false);
        TableColumn[] columns = this.membersLt.getColumns();
        int i = 0;
        while (i < columns.length) {
            TableColumn column2 = columns[i];
            column2.dispose();
            ++i;
        }
        int[] indices = this.classesLt.getSelectionIndices();
        if (indices.length != 1) {
            return;
        }
        TableItem classItem = this.classesLt.getItem(indices[0]);
        ClassData classData = (ClassData)classItem.getData();
        Class clazz = classData.getClazz();
        boolean hasNatives = false;
        Method[] methods = clazz.getDeclaredMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            Method method = methods[i2];
            int mods = method.getModifiers();
            hasNatives = (mods & 0x100) != 0;
            if (hasNatives) break;
            ++i2;
        }
        this.membersLt.setRedraw(false);
        if (hasNatives) {
            column = new TableColumn(this.membersLt, 0, 0);
            column.setText("Method");
            column = new TableColumn(this.membersLt, 0, 1);
            column.setText("Flags");
            JNIGenerator.sort(methods);
            int i3 = 0;
            while (i3 < methods.length) {
                Method method = methods[i3];
                if ((method.getModifiers() & 0x100) != 0) {
                    MethodData methodData = metaData.getMetaData(method);
                    TableItem item = new TableItem(this.membersLt, 0);
                    item.setData((Object)methodData);
                    item.setText(0, this.getMethodString(method));
                    item.setChecked(methodData.isGenerate());
                    item.setText(1, this.getFlagsString(methodData.getFlags()));
                }
                ++i3;
            }
        } else {
            column = new TableColumn(this.membersLt, 0, 0);
            column.setText("Field");
            column = new TableColumn(this.membersLt, 0, 1);
            column.setText("Cast");
            column = new TableColumn(this.membersLt, 0, 2);
            column.setText("Accessor");
            column = new TableColumn(this.membersLt, 0, 3);
            column.setText("Flags");
            Field[] fields = clazz.getDeclaredFields();
            int i4 = 0;
            while (i4 < fields.length) {
                Field field = fields[i4];
                int mods = field.getModifiers();
                if ((mods & 1) != 0 && (mods & 0x10) == 0 && (mods & 8) == 0) {
                    FieldData fieldData = metaData.getMetaData(field);
                    TableItem item = new TableItem(this.membersLt, 0);
                    item.setData((Object)fieldData);
                    item.setText(0, this.getFieldString(field));
                    item.setChecked(fieldData.isGenerate());
                    item.setText(1, fieldData.getCast());
                    item.setText(2, fieldData.getAccessor());
                    item.setText(3, this.getFlagsString(fieldData.getFlags()));
                }
                ++i4;
            }
        }
        columns = this.membersLt.getColumns();
        i = 0;
        while (i < columns.length) {
            TableColumn column3 = columns[i];
            column3.pack();
            ++i;
        }
        this.membersLt.setHeaderVisible(true);
        this.membersLt.setRedraw(true);
    }

    void updateParameters() {
        this.paramsLt.removeAll();
        MetaData metaData = this.app.getMetaData();
        int[] indices = this.membersLt.getSelectionIndices();
        if (indices.length != 1) {
            this.paramsLt.setHeaderVisible(false);
            return;
        }
        this.paramsLt.setRedraw(false);
        TableItem memberItem = this.membersLt.getItem(indices[0]);
        Object data = memberItem.getData();
        if (!(data instanceof MethodData)) {
            return;
        }
        MethodData methodData = (MethodData)memberItem.getData();
        Method method = methodData.getMethod();
        Class<?>[] params = method.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            Class<?> param = params[i];
            ParameterData paramData = metaData.getMetaData(method, i);
            TableItem item = new TableItem(this.paramsLt, 0);
            item.setData((Object)paramData);
            item.setText(0, String.valueOf(i));
            item.setText(1, this.getClassString(param));
            item.setText(2, paramData.getCast());
            item.setText(3, this.getFlagsString(paramData.getFlags()));
            ++i;
        }
        TableColumn[] columns = this.paramsLt.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            TableColumn column = columns[i2];
            column.pack();
            ++i2;
        }
        this.paramsLt.setRedraw(true);
        this.paramsLt.setHeaderVisible(true);
    }

    void updateGenerate(TableItem item) {
        MetaData metaData = this.app.getMetaData();
        ItemData itemData = (ItemData)item.getData();
        itemData.setGenerate(item.getChecked());
        if (itemData instanceof ClassData) {
            ClassData data = (ClassData)itemData;
            metaData.setMetaData(data.getClazz(), data);
        } else if (itemData instanceof FieldData) {
            FieldData data = (FieldData)itemData;
            item.setText(3, this.getFlagsString(data.getFlags()));
            metaData.setMetaData(data.getField(), data);
        } else if (itemData instanceof MethodData) {
            MethodData data = (MethodData)itemData;
            item.setText(1, this.getFlagsString(data.getFlags()));
            metaData.setMetaData(data.getMethod(), data);
        } else if (itemData instanceof ParameterData) {
            ParameterData data = (ParameterData)itemData;
            item.setText(3, this.getFlagsString(data.getFlags()));
            metaData.setMetaData(data.getMethod(), data.getParameter(), data);
        }
    }

    boolean updateOutputDir() {
        String outputDirStr = this.outputDirCb.getText();
        File file = new File(outputDirStr);
        if (!file.exists()) {
            MessageBox dialog = new MessageBox(this.shell, 33);
            dialog.setMessage("Output directory does not exist.");
            dialog.open();
            return false;
        }
        if (!file.isDirectory()) {
            MessageBox dialog = new MessageBox(this.shell, 33);
            dialog.setMessage("Output directory is not a directory.");
            dialog.open();
            return false;
        }
        if (outputDirStr.length() > 0) {
            if (!outputDirStr.equals(this.app.getOutputDir())) {
                this.app.setOutputDir(outputDirStr);
            }
            if (this.outputDirCb.indexOf(outputDirStr) == -1) {
                this.outputDirCb.add(outputDirStr);
            }
        }
        return true;
    }

    void updateMainClass() {
        String mainClassStr = this.mainClassCb.getText();
        if (mainClassStr.length() > 0) {
            if (!mainClassStr.equals(this.app.getMainClass())) {
                this.app.setMainClass(mainClassStr);
            }
            if (this.mainClassCb.indexOf(mainClassStr) == -1) {
                this.mainClassCb.add(mainClassStr);
            }
        }
    }

    public static void main(String[] args) {
        JNIGeneratorApp gen = new JNIGeneratorApp();
        if (args.length > 0) {
            gen.setMainClass(args[0]);
            if (args.length > 1) {
                gen.setOutputDir(args[1]);
            }
        } else {
            gen.setMainClass(JNIGeneratorApp.getDefaultMainClass());
            gen.setOutputDir(JNIGeneratorApp.getDefaultOutputDir());
        }
        JNIGeneratorAppUI ui = new JNIGeneratorAppUI(gen);
        ui.open();
        ui.run();
    }
}

