/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.swt.SWT;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.MetaDataGenerator;
import org.eclipse.swt.tools.internal.NativesGenerator;
import org.eclipse.swt.tools.internal.StatsGenerator;
import org.eclipse.swt.tools.internal.StructsGenerator;

public class JNIGeneratorApp {
    String mainClass;
    String outputDir;
    String classpath;
    MetaData metaData;

    public String getClasspath() {
        return this.classpath;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    String getMetaDataDir() {
        return "./JNI Generation/org/eclipse/swt/tools/internal/";
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    void generateSTATS_C() {
        try {
            String outputName = this.getClassName(this.mainClass).toLowerCase();
            String inc = "#include \"swt.h\"\n#include \"os_structs.h\"\n";
            this.metaData.setMetaData("swt_includes", inc);
            StatsGenerator gen = new StatsGenerator();
            gen.setMetaData(this.metaData);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            gen.setOutput(print);
            gen.generateSourceFile(this.getNativesClasses());
            print.flush();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + outputName + "_stats.c");
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSTATS_H() {
        try {
            String outputName = this.getClassName(this.mainClass).toLowerCase();
            String inc = "";
            this.metaData.setMetaData("swt_includes", inc);
            StatsGenerator gen = new StatsGenerator();
            gen.setMetaData(this.metaData);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            gen.setOutput(print);
            gen.generateHeaderFile(this.getNativesClasses());
            print.flush();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + outputName + "_stats.h");
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSTRUCTS_H() {
        try {
            String outputName = this.getClassName(this.mainClass).toLowerCase();
            this.metaData.setMetaData("swt_includes", "#include \"" + outputName + ".h\"\n");
            StructsGenerator gen = new StructsGenerator();
            gen.setMetaData(this.metaData);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            gen.setOutput(print);
            gen.generateHeaderFile(this.getStructureClasses());
            print.flush();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + outputName + "_structs.h");
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSTRUCTS_C() {
        try {
            String outputName = this.getClassName(this.mainClass).toLowerCase();
            String inc = "#include \"swt.h\"\n#include \"" + outputName + "_structs.h\"\n";
            this.metaData.setMetaData("swt_includes", inc);
            StructsGenerator gen = new StructsGenerator();
            gen.setMetaData(this.metaData);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            gen.setOutput(print);
            gen.generateSourceFile(this.getStructureClasses());
            print.flush();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + outputName + "_structs.c");
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateSWT_C() {
        try {
            String outputName = this.getClassName(this.mainClass).toLowerCase();
            String inc = "#include \"swt.h\"\n#include \"" + outputName + "_structs.h\"\n";
            this.metaData.setMetaData("swt_includes", inc);
            NativesGenerator gen = new NativesGenerator();
            gen.setMetaData(this.metaData);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            gen.setOutput(print);
            gen.generate(this.getNativesClasses());
            print.flush();
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.outputDir) + outputName + ".c");
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    void generateAllMetaData() {
        try {
            MetaDataGenerator gen = new MetaDataGenerator();
            gen.setMetaData(this.metaData);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            gen.setOutput(print);
            gen.generate(this.getClasses());
            print.flush();
            if (!new File(this.getMetaDataDir()).exists()) {
                System.out.println("Warning: Meta data output dir does not exist");
                return;
            }
            if (out.size() > 0) {
                this.output(out.toByteArray(), String.valueOf(this.getMetaDataDir()) + this.mainClass + ".properties");
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    public void generate() {
        if (this.mainClass == null) {
            return;
        }
        this.generateSTRUCTS_H();
        this.generateSTRUCTS_C();
        this.generateSWT_C();
        this.generateSTATS_H();
        this.generateSTATS_C();
        this.generateAllMetaData();
    }

    boolean compare(InputStream is1, InputStream is2) throws IOException {
        int c1;
        do {
            int c2;
            if ((c1 = is1.read()) == (c2 = is2.read())) continue;
            return false;
        } while (c1 != -1);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void output(byte[] bytes, String fileName) throws IOException {
        FileInputStream is;
        block10: {
            is = null;
            try {
                try {
                    is = new FileInputStream(fileName);
                    if (!this.compare(new ByteArrayInputStream(bytes), new BufferedInputStream(is))) break block10;
                    Object var4_4 = null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (is == null) return;
            is.close();
            return;
        }
        Object var4_6 = null;
        try {}
        catch (IOException iOException) {}
        if (is != null) {
            is.close();
        }
        FileOutputStream out = new FileOutputStream(fileName);
        out.write(bytes);
        out.close();
    }

    String getClassName(String className) {
        int dot = this.mainClass.lastIndexOf(46);
        if (dot == -1) {
            return className;
        }
        return this.mainClass.substring(dot + 1);
    }

    String getPackageName(String className) {
        int dot = this.mainClass.lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return this.mainClass.substring(0, dot);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] getClassNames(String mainClassName) {
        String pkgName = this.getPackageName(mainClassName);
        String classpath = this.getClasspath();
        if (classpath == null) {
            classpath = System.getProperty("java.class.path");
        }
        String pkgPath = pkgName.replace('.', File.separatorChar);
        String pkgZipPath = pkgName.replace('.', '/');
        ArrayList<String> classes = new ArrayList<String>();
        int start = 0;
        int index = 0;
        while (true) {
            block19: {
                String[] entries;
                String path;
                block20: {
                    Object var15_16;
                    if (index >= classpath.length()) {
                        return classes.toArray(new String[classes.size()]);
                    }
                    index = classpath.indexOf(File.pathSeparatorChar, start);
                    if (index == -1) {
                        index = classpath.length();
                    }
                    if (!(path = classpath.substring(start, index)).toLowerCase().endsWith(".jar")) break block20;
                    ZipFile zipFile = null;
                    try {
                        try {
                            zipFile = new ZipFile(path);
                            entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                ZipEntry entry = entries.nextElement();
                                String name = entry.getName();
                                if (!name.startsWith(pkgZipPath) || !name.endsWith(".class")) continue;
                                String className = name.substring(pkgZipPath.length() + 1, name.length() - 6);
                                className.replace('/', '.');
                                classes.add(className);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        var15_16 = null;
                        try {
                            if (zipFile == null) throw throwable;
                            zipFile.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var15_16 = null;
                        try {}
                        catch (IOException iOException) {}
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        break block19;
                    }
                    break block19;
                }
                File file = new File(String.valueOf(path) + File.separator + pkgPath);
                if (file.exists()) {
                    entries = file.list();
                    int i = 0;
                    while (i < entries.length) {
                        String entry = entries[i];
                        File f = new File(file, entry);
                        if (!f.isDirectory()) {
                            if (f.getAbsolutePath().endsWith(".class")) {
                                String className = entry.substring(0, entry.length() - 6);
                                classes.add(className);
                            }
                        } else {
                            System.out.println("SUBDIR NOT DONE=" + f);
                        }
                        ++i;
                    }
                }
            }
            start = index + 1;
        }
    }

    public Class[] getClasses() {
        if (this.mainClass == null) {
            return new Class[0];
        }
        Object[] classNames = this.getClassNames(this.mainClass);
        Arrays.sort(classNames);
        String packageName = this.getPackageName(this.mainClass);
        Class[] classes = new Class[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            Object className = classNames[i];
            try {
                classes[i] = Class.forName(String.valueOf(packageName) + "." + (String)className, false, this.getClass().getClassLoader());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return classes;
    }

    public Class[] getNativesClasses() {
        if (this.mainClass == null) {
            return new Class[0];
        }
        ArrayList<Class> result = new ArrayList<Class>();
        Class[] classes = this.getClasses();
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            Method[] methods = clazz.getDeclaredMethods();
            int j = 0;
            while (j < methods.length) {
                Method method = methods[j];
                int mods = method.getModifiers();
                if ((mods & 0x100) != 0) {
                    result.add(clazz);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new Class[result.size()]);
    }

    public Class[] getStructureClasses() {
        if (this.mainClass == null) {
            return new Class[0];
        }
        ArrayList<Class> result = new ArrayList<Class>();
        Class[] classes = this.getClasses();
        int i = 0;
        while (i < classes.length) {
            block4: {
                Class clazz = classes[i];
                Method[] methods = clazz.getDeclaredMethods();
                int j = 0;
                while (j < methods.length) {
                    Method method = methods[j];
                    int mods = method.getModifiers();
                    if ((mods & 0x100) == 0) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                result.add(clazz);
            }
            ++i;
        }
        return result.toArray(new Class[result.size()]);
    }

    MetaData loadMetaData() {
        int index = 0;
        Properties propeties = new Properties();
        int length = this.mainClass.length();
        while (index < length) {
            if ((index = this.mainClass.indexOf(46, index)) == -1) {
                index = length;
            }
            try {
                InputStream is = this.getClass().getResourceAsStream(String.valueOf(this.mainClass.substring(0, index)) + ".properties");
                propeties.load(is);
                is.close();
            }
            catch (Exception exception) {}
            ++index;
        }
        return new MetaData(propeties);
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setMainClass(String str) {
        this.mainClass = str;
        this.metaData = this.loadMetaData();
    }

    public void setOutputDir(String str) {
        this.outputDir = str;
    }

    public static String getDefaultMainClass() {
        return "org.eclipse.swt.internal." + JNIGeneratorApp.getDefaultPlatform() + ".OS";
    }

    public static String getDefaultOutputDir() {
        return "../org.eclipse.swt/Eclipse SWT PI/" + JNIGeneratorApp.getDefaultPlatform() + "/library/";
    }

    public static String getDefaultPlatform() {
        return SWT.getPlatform();
    }

    public static void main(String[] args) {
        JNIGeneratorApp gen = new JNIGeneratorApp();
        if (args.length > 0) {
            gen.setMainClass(args[0]);
            if (args.length > 1) {
                gen.setOutputDir(args[1]);
            }
            if (args.length > 2) {
                gen.setClasspath(args[2]);
            }
        } else {
            gen.setMainClass(JNIGeneratorApp.getDefaultMainClass());
            gen.setOutputDir(JNIGeneratorApp.getDefaultOutputDir());
        }
        gen.generate();
    }
}

