/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.tools.internal.MetaData;

public abstract class JNIGenerator {
    String delimiter = System.getProperty("line.separator");
    PrintStream output = System.out;
    MetaData metaData = new MetaData(new Properties());
    static /* synthetic */ Class class$0;

    String fixDelimiter(String str) {
        if (this.delimiter.equals("\n")) {
            return str;
        }
        int index = 0;
        int length = str.length();
        StringBuffer buffer = new StringBuffer();
        while (index != -1) {
            int start = index;
            if ((index = str.indexOf(10, start)) == -1) {
                buffer.append(str.substring(start, length));
                continue;
            }
            buffer.append(str.substring(start, index));
            buffer.append(this.delimiter);
            ++index;
        }
        return buffer.toString();
    }

    static String getClassName(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46) + 1;
        return name.substring(index, name.length());
    }

    static String getFunctionName(Method method) {
        return JNIGenerator.getFunctionName(method, method.getParameterTypes());
    }

    static String getFunctionName(Method method, Class[] paramTypes) {
        String function = JNIGenerator.toC(method.getName());
        if (!JNIGenerator.isUnique(method, 256)) {
            function = String.valueOf(function) + "__";
            if (paramTypes.length > 0) {
                int i = 0;
                while (i < paramTypes.length) {
                    Class paramType = paramTypes[i];
                    function = String.valueOf(function) + JNIGenerator.toC(JNIGenerator.getTypeSignature(paramType));
                    ++i;
                }
            }
        }
        return function;
    }

    static int getByteCount(Class clazz) {
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Boolean.TYPE) {
            return 4;
        }
        if (clazz == Long.TYPE) {
            return 8;
        }
        if (clazz == Short.TYPE) {
            return 2;
        }
        if (clazz == Character.TYPE) {
            return 2;
        }
        if (clazz == Byte.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == Double.TYPE) {
            return 8;
        }
        return 4;
    }

    static String getTypeSignature(Field field) {
        Class<?> clazz = field.getType();
        return JNIGenerator.getTypeSignature(clazz);
    }

    static String getTypeSignature(Class clazz) {
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return "[" + JNIGenerator.getTypeSignature(componentType);
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    static String getTypeSignature1(Field field) {
        Class<?> clazz = field.getType();
        return JNIGenerator.getTypeSignature1(clazz);
    }

    static String getTypeSignature1(Class clazz) {
        if (clazz == Integer.TYPE) {
            return "Int";
        }
        if (clazz == Boolean.TYPE) {
            return "Boolean";
        }
        if (clazz == Long.TYPE) {
            return "Long";
        }
        if (clazz == Short.TYPE) {
            return "Short";
        }
        if (clazz == Character.TYPE) {
            return "Char";
        }
        if (clazz == Byte.TYPE) {
            return "Byte";
        }
        if (clazz == Float.TYPE) {
            return "Float";
        }
        if (clazz == Double.TYPE) {
            return "Double";
        }
        return "Object";
    }

    static String getTypeSignature2(Field field) {
        Class<?> clazz = field.getType();
        return JNIGenerator.getTypeSignature2(clazz);
    }

    static String getTypeSignature2(Class clazz) {
        if (clazz == Void.TYPE) {
            return "void";
        }
        if (clazz == Integer.TYPE) {
            return "jint";
        }
        if (clazz == Boolean.TYPE) {
            return "jboolean";
        }
        if (clazz == Long.TYPE) {
            return "jlong";
        }
        if (clazz == Short.TYPE) {
            return "jshort";
        }
        if (clazz == Character.TYPE) {
            return "jchar";
        }
        if (clazz == Byte.TYPE) {
            return "jbyte";
        }
        if (clazz == Float.TYPE) {
            return "jfloat";
        }
        if (clazz == Double.TYPE) {
            return "jdouble";
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return String.valueOf(JNIGenerator.getTypeSignature2(componentType)) + "Array";
        }
        return "jobject";
    }

    static String getTypeSignature4(Class clazz) {
        if (clazz == Void.TYPE) {
            return "void";
        }
        if (clazz == Integer.TYPE) {
            return "jint";
        }
        if (clazz == Boolean.TYPE) {
            return "jboolean";
        }
        if (clazz == Long.TYPE) {
            return "jlong";
        }
        if (clazz == Short.TYPE) {
            return "jshort";
        }
        if (clazz == Character.TYPE) {
            return "jchar";
        }
        if (clazz == Byte.TYPE) {
            return "jbyte";
        }
        if (clazz == Float.TYPE) {
            return "jfloat";
        }
        if (clazz == Double.TYPE) {
            return "jdouble";
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return String.valueOf(JNIGenerator.getTypeSignature4(componentType)) + " *";
        }
        return String.valueOf(JNIGenerator.getClassName(clazz)) + " *";
    }

    static String getTypeSignature3(Field field) {
        Class<?> clazz = field.getType();
        return JNIGenerator.getTypeSignature3(clazz);
    }

    static String getTypeSignature3(Class clazz) {
        if (clazz == Void.TYPE) {
            return "void";
        }
        if (clazz == Integer.TYPE) {
            return "int";
        }
        if (clazz == Boolean.TYPE) {
            return "boolean";
        }
        if (clazz == Long.TYPE) {
            return "long";
        }
        if (clazz == Short.TYPE) {
            return "short";
        }
        if (clazz == Character.TYPE) {
            return "char";
        }
        if (clazz == Byte.TYPE) {
            return "byte";
        }
        if (clazz == Float.TYPE) {
            return "float";
        }
        if (clazz == Double.TYPE) {
            return "double";
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return "String";
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return String.valueOf(JNIGenerator.getTypeSignature3(componentType)) + "[]";
        }
        return clazz.getName();
    }

    static boolean isUnique(Method method, int modifierMask) {
        Class<?> clazz = method.getDeclaringClass();
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method mth = methods[i];
            if ((method.getModifiers() & modifierMask) != 0 && !method.equals(mth) && method.getName().equals(mth.getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static void sort(Method[] methods) {
        Arrays.sort(methods, new Comparator(){

            public int compare(Object a, Object b) {
                Method mth1 = (Method)a;
                Method mth2 = (Method)b;
                int result = mth1.getName().compareTo(mth2.getName());
                return result != 0 ? result : JNIGenerator.getFunctionName(mth1).compareTo(JNIGenerator.getFunctionName(mth2));
            }
        });
    }

    static void sort(Field[] fields) {
        Arrays.sort(fields, new Comparator(){

            public int compare(Object a, Object b) {
                return ((Field)a).getName().compareTo(((Field)b).getName());
            }
        });
    }

    static void sort(Class[] classes) {
        Arrays.sort(classes, new Comparator(){

            public int compare(Object a, Object b) {
                return ((Class)a).getName().compareTo(((Class)b).getName());
            }
        });
    }

    static String toC(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '_': {
                    buf.append("_1");
                    break;
                }
                case ';': {
                    buf.append("_2");
                    break;
                }
                case '[': {
                    buf.append("_3");
                    break;
                }
                case '.': {
                    buf.append("_");
                    break;
                }
                case '/': {
                    buf.append("_");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public String getPlatform() {
        return SWT.getPlatform();
    }

    public abstract void generate(Class var1);

    public void generateMetaData(String key) {
        MetaData mt = this.getMetaData();
        String data = mt.getMetaData(key, null);
        if (data == null) {
            return;
        }
        this.output(this.fixDelimiter(data));
        this.outputDelimiter();
    }

    public void generate(Class[] classes) {
        JNIGenerator.sort(classes);
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            this.generate(clazz);
            ++i;
        }
    }

    public void output(String str) {
        this.output.print(str);
    }

    public void outputDelimiter() {
        this.output(this.getDelimiter());
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOutput(PrintStream output) {
        this.output = output;
    }

    public void setMetaData(MetaData data) {
        this.metaData = data;
    }
}

