/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class ItemData {
    HashMap params;

    public ItemData(String str) {
        this.parse(str);
    }

    static String[] split(String str, String separator) {
        StringTokenizer tk = new StringTokenizer(str, separator);
        ArrayList<Object> result = new ArrayList<Object>();
        while (tk.hasMoreElements()) {
            result.add(tk.nextElement());
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getFlags() {
        Object flags = this.getParam("flags");
        if (flags == null) {
            return new String[0];
        }
        if (flags instanceof String[]) {
            return (String[])flags;
        }
        String[] result = ItemData.split((String)flags, " ");
        this.params.put("flags", result);
        return result;
    }

    public boolean getFlag(String flag) {
        String[] flags = this.getFlags();
        int i = 0;
        while (i < flags.length) {
            if (flags[i].equals(flag)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getParam(String key) {
        Object value = this.params.get(key);
        return value == null ? "" : value;
    }

    public boolean isGenerate() {
        return !this.getFlag("no_gen");
    }

    public void parse(String str) {
        this.params = new HashMap();
        if (str.length() == 0) {
            return;
        }
        String[] params = ItemData.split(str, ",");
        int i = 0;
        while (i < params.length) {
            String param = params[i];
            int equals = param.indexOf(61);
            if (equals == -1) {
                System.out.println();
            }
            String key = param.substring(0, equals).trim();
            String value = param.substring(equals + 1).trim();
            this.setParam(key, value);
            ++i;
        }
    }

    public void setFlags(String[] flags) {
        this.setParam("flags", flags);
    }

    public void setFlag(String flag, boolean value) {
        String[] flags = this.getFlags();
        HashSet<String> set = new HashSet<String>(Arrays.asList(flags));
        if (value) {
            set.add(flag);
        } else {
            set.remove(flag);
        }
        this.setFlags(set.toArray(new String[set.size()]));
    }

    public void setGenerate(boolean value) {
        this.setFlag("no_gen", !value);
    }

    public void setParam(String key, Object value) {
        this.params.put(key, value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Set set = this.params.keySet();
        Object[] keys = set.toArray(new String[set.size()]);
        Arrays.sort(keys);
        int j = 0;
        while (j < keys.length) {
            Object key = keys[j];
            Object value = this.params.get(key);
            String valueStr = "";
            if (value instanceof String) {
                valueStr = (String)value;
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                StringBuffer valueBuffer = new StringBuffer();
                int i = 0;
                while (i < values.length) {
                    if (i != 0) {
                        valueBuffer.append(" ");
                    }
                    valueBuffer.append(values[i]);
                    ++i;
                }
                valueStr = valueBuffer.toString();
            } else {
                valueStr = value.toString();
            }
            if (valueStr.length() > 0) {
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                buffer.append((String)key);
                buffer.append("=");
                buffer.append(valueStr);
            }
            ++j;
        }
        return buffer.toString();
    }
}

