#!/usr/bin/perl

my $srcdir=".";
my $badtarget=0;
my $hascont=0;

while($_=<>) {
    chomp;

    if (/\\(\s*)$/) {
	$hascont = 1;
    } else {
	$hascont = 0;
    }

    if ($badtarget != 0) {
	if (/^\t/) {
	    next;
	} else {
	    $badtarget=0;
	}
    }

    if (/^(\S*)Makefile:/) {
	print "Makefile: Makefile.in configure\n\t./configure\n\n";
	$badtarget=1;
	next;
    }

    if (/^(\S*)Makefile\.in:/) {
	print "Makefile.in: Makefile.am\n\t\$(AUTOMAKE)\n\n";
	$badtarget=1;
	next;
    }

    if (/^(\S*)config\.status:/) {
	$badtarget=1;
	next;
    }

    if (/^(\S*)configure:/) {
	print "configure: configure.in\n\t\$(AUTOCONF)\n\n";
	$badtarget=1;
	next;
    }

    if (/srcdir\s*=\s*(.*)/) {
	$srcdir=$1;
    }

    if (/CPPFLAGS\s*=\s*(.*)/) {
	$_="CPPFLAGS = \`./cppflags`";
    }

    # eliminate the stupid test -f of automake 1.6
    s/\`test -f.*echo.*srcdir.*\$</\$</;

    # eliminate annoying -I. -I. on the flags
    while(/(.*-I\..*)-I\.(.*)/) {
	$_ = $1.$2;
    }

    # same thing when $srcdir = .
    if ($srcdir eq ".") {
	while(/(.*-I\..*)-I\$\(srcdir\)(.*)/) {
	    $_ = $1.$2;
	}
    }

    print "$_\n";
}

