/* $Id: main.cc,v 1.12 2002/04/23 07:55:09 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <iostream.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk_imlib.h>
#include <sys/types.h>
#include <signal.h>
#include "mainwindow.h"
#include "global.h"
#include "sound.h"
#include "help.h"

static void dump_tables(int signum) {
  // dump all internal tables to stderr when SIGUSR1 is received
  /*
  global.dumpGames();
  global.dumpBoards();
  global.dumpPanes();
  */
  global.report();
}

int main(int argc,char **argv) {
  list<int>::iterator zomb;
  int i;
  MainWindow *z;

  if (strstr(argv[0],"beeper")) {
    SoundSlave slave;
    slave.waitForEvents();
    return 0;
  }

  strncpy(global.argv0,argv[0],511);
  global.argv0[511]=0;

  signal(SIGPIPE,SIG_IGN);
  signal(SIGUSR1,dump_tables); // for debugging

  gtk_init(&argc,&argv);
  gdk_rgb_init();
  gdk_imlib_init();

  for(i=1;i<argc;i++) {
    if (!strcmp(argv[i],"-log"))
      global.CommLog=1;
    if (!strcmp(argv[i],"-debug"))
      global.DebugLog=1;
  }

  global.LogAppend("------------ started -------------");

  global.statOS();
  global.ensureDirectories();
  z=new MainWindow();
  z->show();
  z->restoreDesk();

  if (global.PopupHelp)
    (new Help::GettingStarted())->show();

  gtk_main();
  
  for(zomb=global.TheOffspring.begin();zomb!=global.TheOffspring.end();
      zomb++)
    kill(*zomb,SIGKILL);

  global.LogAppend("finished gracefully");

  return 0;
}
