/* $Id: help.cc,v 1.12 2002/06/26 01:06:59 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>

#include "util.h"
#include "tstring.h"
#include "global.h"
#include "help.h"
#include "mainwindow.h"

namespace Help {

  KeysDialog::KeysDialog() : ModalDialog("Help: Keys") {
    GtkWidget *v,*label,*bhb,*hs,*ok;
    char z[1024];
    
    v=gtk_vbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(widget),v);
    
    strcpy(z,
	   "Anywhere:\n"\
	   "F3: Go to previous pane.\n"\
	   "F4: Go to next pane.\n"\
	   "F5: Go to the main board pane.\n"\
	   "F6: Go to the console pane.\n"\
	   "F7: Go to the seek graph pane (if available).\n"\
	   "F8: Input focus on input box.\n"\
	   "Page Up/Page Down: scrolls the text console (must be visible)\n"\
	   "Ctrl+(Left Arrow): Backward 1 halfmove\n"\
	   "Ctrl+(Right Arrow): Forward 1 halfmove\n"\
	   "Ctrl+F: Find Upwards(main console buffer)\n"\
	   "Ctrl+G: Find Previous\n"\
	   "\nInput box:\n"\
	   "Up/Down (arrows): move thru input history\n"\
	   "Enter: send text line\n"\
	   "Esc: switch Chat/Command Mode");
    
    label=gtk_label_new(z);
    gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
    gtk_box_pack_start(GTK_BOX(v),label,TRUE,TRUE,4);
    
    hs=gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(v),hs,FALSE,FALSE,4);
    
    bhb=gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(bhb), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing(GTK_BUTTON_BOX(bhb), 5);
    
    gtk_box_pack_start(GTK_BOX(v),bhb,FALSE,FALSE,4);

    ok=gtk_button_new_with_label("Close");
    GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(bhb),ok,TRUE,TRUE,0);
    
    gtk_widget_grab_default(ok);
    
    gtk_widget_show(ok);
    gtk_widget_show(bhb);
    gtk_widget_show(hs);
    gtk_widget_show(label);
    gtk_widget_show(v);
    setDismiss(GTK_OBJECT(ok),"clicked");
  }

  DebugDialog::DebugDialog() : ModalDialog("Help: Debug Info") {
    GtkWidget *v,*label,*hs,*bhb,*ok,*txt;
    char z[2048],y[256],x[256],w[256];
    struct stat s;
    EboardFileFinder eff;

    v=gtk_vbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(widget),v);
    
    z[0]=0;

    // gtk
    sprintf(y,"GTK+ version %d.%d.%d\n",
	    gtk_major_version,
	    gtk_minor_version,
	    gtk_micro_version);
    strcat(z,y);

    // imlib
    sprintf(y,"Imlib version %s\n",grabOutput("imlib-config --version"));
    strcat(z,y);

    // gcc (c++) if any
    sprintf(y,"GCC says:  %s\n",
	    grabOutput("c++ --version 2>&1"));
    strcat(z,y);

    // perl
    sprintf(y,"Perl says:  %s\n",
	    grabOutput("perl -v | grep version"));
    strcat(z,y);

    // expect
    sprintf(y,"expect says:  %s\n",
	    grabOutput("expect -d -c exit 2>&1"));
    strcat(z,y);    

    // kernel
    sprintf(y,"kernel info: %s\n",
	    grabOutput("uname -srm"));
    strcat(z,y);

    // timeseal
    sprintf(x,"timeseal.%s",global.SystemType);
    if (!eff.find(x,y)) strcpy(y,x);

    if (lstat(y,&s)==0) {
      sprintf(w,"Found %s\n",y); strcpy(x,w);
      sprintf(w,"Size %d bytes, Last Modified %s",
	      s.st_size, ctime(&(s.st_mtime)) );
      strcat(x,w);
      sprintf(w,"Mode %0.4o. (seems it i%s enough to be run by eboard)\n",
	      s.st_mode,
	      ( S_ISREG(s.st_mode)
		&&
		(
		 ( S_IXUSR&s.st_mode && s.st_uid==getuid() )
		 ||
		 ( S_IXGRP&s.st_mode && s.st_gid==getgid() )
		 ||
		 ( S_IXOTH&s.st_mode ) 
		 )
		) ? "s" : "s NOT"
	      );
      strcat(x,w);
      
    } else {
      sprintf(x,"%s Not Found (errno %d)",y,errno);
    }

    sprintf(y,"\nFICS timeseal:\n%s\n",x);
    strcat(z,y);

    label=gtk_label_new(z);
    gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
    gtk_box_pack_start(GTK_BOX(v),label,TRUE,TRUE,4);

    hs=gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(v),hs,FALSE,FALSE,4);
    
    bhb=gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(bhb), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing(GTK_BUTTON_BOX(bhb), 5);
    
    gtk_box_pack_start(GTK_BOX(v),bhb,FALSE,FALSE,4);

    ok=gtk_button_new_with_label("Close");
    txt=gtk_button_new_with_label("Write to Console");
    GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(txt,GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(bhb),txt,TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(bhb),ok,TRUE,TRUE,0);
    
    gtk_widget_grab_default(ok);
    
    gtk_widget_show(ok);
    gtk_widget_show(txt);
    gtk_widget_show(bhb);
    gtk_widget_show(hs);
    gtk_widget_show(label);
    gtk_widget_show(v);
    setDismiss(GTK_OBJECT(ok),"clicked");

    gtk_signal_connect(GTK_OBJECT(txt),"clicked",
		       GTK_SIGNAL_FUNC(debugdlg_writecons),
		       (gpointer) this);

    strcpy(pipedata,z);
  }

  char * DebugDialog::grabOutput(char *cmdline) {
    FILE *f;
    bool ok = false;
    char *c;
    f=popen(cmdline,"r");
    if (f) {
      if (fgets(pipedata,127,f))
	ok=true;
      pclose(f);
    }
    if (!ok)
      strcpy(pipedata,"unable to retrieve");
    else
      while( (c=index(pipedata,'\n'))!=NULL)
	*c=0;
    return pipedata;
  }

  void debugdlg_writecons(GtkWidget *w, gpointer data) {
    DebugDialog *me;
    tstring t;
    string *c;
    char z[512];

    me = (DebugDialog *) data;
    t.set(me->pipedata);
    global.output->append("=== START DEBUG INFO ===",0xc0ff00);
    while( (c=t.token("\n")) != 0) {
      memset(z,0,512);
      c->copy(z,511);
      global.output->append(z, global.Colors.TextBright);
    }
    global.output->append("=== END DEBUG INFO ===",0xc0ff00);
  }


  GettingStarted::GettingStarted() : NonModalDialog("Help: Getting Started ") {
    GtkWidget *v, *bhb, *ok;

    gtk_window_set_default_size(GTK_WINDOW(widget),580,500);
    v=gtk_vbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(widget),v);

    text=gtk_text_new(0,0);
    gtk_box_pack_start(GTK_BOX(v),text,TRUE,TRUE,0);

    bhb=gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(bhb), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing(GTK_BUTTON_BOX(bhb), 5);
    
    gtk_box_pack_start(GTK_BOX(v),bhb,FALSE,FALSE,4);

    ok=gtk_button_new_with_label("Close");
    GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(bhb),ok,TRUE,TRUE,0);
    
    gtk_widget_grab_default(ok);
    
    gtk_widget_show(ok);
    gtk_widget_show(bhb);
    gtk_widget_show(text);
    gtk_widget_show(v);
    setDismiss(GTK_OBJECT(ok),"clicked");

    compose();
  }

  void GettingStarted::compose() {
    GdkFont *fl, *fm, *fs, *f;
    GdkColor blue, *pc;
    char *T,*p,*q;

    blue.red=0;
    blue.green=0;
    blue.blue=0xffff;

    fl=global.loadFont(EF_ClockFont);
    fm=global.loadFont(EF_PlayerFont);
    fs=global.loadFont(EF_InfoFont);

    // codes: 200 large  201 medium  202 small  203 blue  204 black

    T="\200Getting Started\n"\
      "\201Common Tasks in eboard\n\n"\
      "Playing against the computer\n"\
      "\202eboard does not \"play chess\" itself, but rather is works as interface to programs that do,\n"\
      "called \"engines\", which don't have a graphical interface themselves. You need an engine to\n"\
      "play against the computer. GNU Chess, Crafty and Sjeng are chess engines that are available at\n"\
      "no cost.\n"\
      "Once you have one of them installed, open the \203Peer\204 menu, then the \203Play against\n"\
      "engine\204 submenu, and select the appropriate option depending on which engine you have\n"
      "installed.\n\n"\
      "\201Playing Chess on the Internet\n"\
      "\202Eboard supports the FICS protocol. FICS runs at freechess.org, but other servers, such as\n"\
      "US Chess Live, use FICS's software and should work with eboard too. ICC is not supported.\n"\
      "To connect to FICS, open the \203Peer\204 menu, click \203Connect to FICS\204. To connect to\n"\
      "other servers, open the \203Peer\204 menu, click \203Connect to Other Server...\204.\n"\
      "While you can login as guest on FICS, you'll enjoy it better as a registered user. Registration\n"\
      "is done through FICS's site at \203http://www.freechess.org\204, and it's free.\n\n"\
      "\201Browsing PGN Games\n"\
      "\202PGN is the most common file format to store chess games. It can store moves and comments\n"\
      "(annotations). To open this kind of file within eboard, open the \203Windows\204 menu, click\n"\
      "\203Games on Client\204. In the Local Game List dialog, click \203Load PGN...\204. To browse a\n"\
      "game, \203select it\204 and click \203Display\204. A new tab will be created in the main window\n"\
      "with the game."\
      "\200";

    q=T;
    f=fs;
    pc=0;
    for(p=T;*p;p++) {

      if (*p < 0) {

	if (p-q) gtk_text_insert(GTK_TEXT(text),f,pc,0,q,p-q);
	for(q=p;*q < 0;q++) ;

	switch(*p) {
	case '\200': f=fl; break;
	case '\201': f=fm; break;
	case '\202': f=fs; break;
	case '\203': pc=&blue; break;
	case '\204': pc=0; break;
	}

      }

    }

    if (fs) gdk_font_unref(fs);
    if (fm) gdk_font_unref(fm);
    if (fl) gdk_font_unref(fl);

  }

} // namespace Help

