/* $Id: clock.h,v 1.7 2002/04/18 03:52:19 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef CLOCK_H
#define CLOCK_H 1

#include <sys/time.h>
#include <unistd.h>
#include <gtk/gtk.h>

#include "stl.h"
#include "eboard.h"
#include "time.h"

class ClockHost {
 public:
  virtual void updateClock()=0;
};

class ChessClock : public UpdateInterface {
 public:
  ChessClock();
  ~ChessClock();

  // activep: -1: white running  0: stopped   1: black running
  void setClock(int whitesec,int blacksec,int activep,int countdown);
  void setHost(ClockHost *hostp);
  void setAnotherHost(ClockHost *hostp);
  void setMirror(ChessClock *dest);

  // -1: white running  0: stopped   1: black running
  int  getActive();
  int  getValue(int black);

  bool lowTimeWarning(piece mycolor);

  void update();
  
  int id;  

 private:
  int value[2],val_ref[2];
  time_t t_ref[2];
  int active;
  int countdownf;
  ClockHost *host, *host2;
  ChessClock *mirror;
  struct timeval LastWarning;

  static int freeid;
};


class ClockMaster {
 public:
  ClockMaster();
  void append(ChessClock *clockp);
  void remove(ChessClock *clockp);

 private:
  void update();

  list<ChessClock *> clocks;
  int timeout_on;
  int timeout_id;

  friend gint clockmaster_timeout(gpointer data);
};


#endif
