/* $Id: board.h,v 1.40 2002/04/23 07:55:09 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef BOARD_H
#define BOARD_H

#include "stl.h"
#include "eboard.h"
#include "widgetproxy.h"
#include "pieces.h"
#include "position.h"
#include "chess.h"
#include "clock.h"
#include "notebook.h"
#include "animate.h"

// foreign classes referenced here
class ChessGame;

class DropSource {
 public:
  DropSource(piece p, int x1,int y1,int w,int h, bool d=true);
  bool hit(int x,int y);

  int X,Y,X2,Y2;
  piece P;
  bool dragged;
};

class TargetManager {
 public:
  void cleanTargets();
  void addTarget(DropSource *ds);
  DropSource *hitTarget(int x,int y);

 private:
  vector<DropSource *> targets;
};

class RootBoard {
 protected:
  void clockString(int val,char *z);
};

class Board : public WidgetProxy,
	      public ClockHost,
	      public RootBoard,
	      public NotebookInsider,
              public TargetManager,
	      public PieceChangeListener
{
 public:
  Board();
  ~Board();

  void repaint();

  void  setSensitive(bool state);
  void  setPartnerGame();
  void  setSelColor(int color);
  void  clearSel();
  void  setFlipped(bool flip);
  void  setFlipInversion(bool v);
  bool  getFlipInversion();
  void  setClock(int wsecs,int bsecs,int actv,int cdown);
  void  setInfo(int idx,char *s);
  void  setInfo(int idx,string &s);
  void  setCanMove(bool value);
  void  stopClock();
  void  reset();
  
  void  setGame(ChessGame *game);
  ChessGame *getGame();
  void  reloadFonts();

  void freeze();
  void thaw();
  void queueRepaint();
  void invalidate();

  virtual void show();

  void update(bool sndflag=false);
  virtual void updateClock();

  virtual void pieceSetChanged();

  void walkBack1();
  void walkBackAll();
  void walkForward1();
  void walkForwardAll();
  void openMovelist();
  bool hasGame();

  bool effectiveFlip();

  void dump();

  void supressNextAnimation();

  bool FreeMove; // editing positions, examining games
  bool EditMode; // explicit edit mode (with pieces to drop and additional commands)
 
  static Board * PopupOwner;

 private:
  GtkWidget *yidget;

  PieceSet *cur;
  GdkPixmap *buffer,*clkbar;
  GdkGC *clkgc, *wgc;
  GdkFont *f1,*f2,*f3;
  rgbptr scrap;

  bool canselect;
  bool allowMove;
  bool FlipInvert;
  bool flipped;
  bool repaint_due;
  bool update_queue;

  int sel_color;
  int frozen_lvl;
  int LockAnimate;

  vector<SMove *> LastMove;

  list<AnimatedPiece *> animes;
  int gotAnimationLoop;

  Position position;
  Position currently_rendered;
  Position fake;

  ChessGame *mygame;
  ChessClock clock;
  LayoutBox C;

  int hilite_ch, clock_ch;

  // selection/highlight
  int ax[2],ay[2],sp;

  // premove
  int premoveq;
  int pmx[2],pmy[2];
  piece pmp;  

  // dragged piece info
  bool  dr_active;
  bool  dr_fromstock;
  int   dr_ox, dr_oy, dr_c, dr_r;
  piece dr_p;
  int   dr_step;
  int   dr_dirty[2];
  bool  dr_fto;

  // info lines
  string info[6];

  int dropsq[2];

  int sqside;
  int borx, bory; // borders (when coordinates are shown)
  int morey; // extra y space for extruded sets

  stack<bool> UpdateStack;

  // inline calculations
  int Width()  { return( (sqside<<3) + (borx<<1) ); }
  int Height() { return( (sqside<<3) + (bory<<1) + morey); }

  void popupDropMenu(int col,int row,int sx,int sy,guint32 etime);
  void popupProtocolMenu(int x,int y, guint32 etime);
  void renderClock();
  void sendMove();
  void outlineRectangle(GdkGC *gc, int x,int y,int color,int pen);
  void drawBall(GdkGC *gc, int x,int y,int color,int radius);
  void drop(piece p);
  void drawCoordinates(GdkPixmap *dest,GdkGC *gc,int side);

  void composeVecBoard(GdkGC *gc);
  void pasteVecBoard();

  friend gboolean board_animate(gpointer data);
  friend gboolean vec_board_animate(gpointer data);

  friend gboolean board_expose_event(GtkWidget *widget,GdkEventExpose *ee,
				     gpointer data);
  friend gboolean board_configure_event(GtkWidget *widget,
					GdkEventConfigure *ce,
					gpointer data);
  friend gboolean board_button_press_event(GtkWidget *widget,
					   GdkEventButton *be,
					   gpointer data);
  friend gboolean board_button_release_event(GtkWidget *widget,
					     GdkEventButton *be,
					     gpointer data);
  friend gboolean board_motion_event(GtkWidget *widget,
				     GdkEventMotion *em,
				     gpointer data);

  friend void drop_callbackP(GtkMenuItem *item,gpointer data);
  friend void drop_callbackR(GtkMenuItem *item,gpointer data);
  friend void drop_callbackN(GtkMenuItem *item,gpointer data);
  friend void drop_callbackB(GtkMenuItem *item,gpointer data);
  friend void drop_callbackQ(GtkMenuItem *item,gpointer data);

  friend void menu_whitep(GtkMenuItem *item, gpointer data);
  friend void menu_blackp(GtkMenuItem *item, gpointer data);
  friend void menu_gamep(GtkMenuItem *item, gpointer data);

};

class EditBoard : public Board {
 public:
  EditBoard(ChessGame *cg);
};

#endif

