/* $Id: animate.h,v 1.5 2001/08/05 03:33:01 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef ANIMATE_H
#define ANIMATE_H 1

#include <gtk/gtk.h>
#include "eboard.h"
#include "pieces.h"

class AnimatedPiece {
 public:
  virtual void create(GdkWindow *parent,PieceSet *set,int sqside)=0;
  virtual void lemming()=0;
  virtual void destroy()=0;
  virtual void step()=0;
  
  int over();

  int getX();
  int getY();
  piece getPiece();
  bool getSoundHold();

 protected:
  piece Piece;
  int X0,Y0,X,Y,XF,YF,DX,DY;
  int steps,ower;
  int square;
  bool SoundHold;
};


class FlatAnimatedPiece : public AnimatedPiece {
 public:
  FlatAnimatedPiece(piece p,int x0,int y0,int xf,int yf,int s,bool sndhold);
  virtual void create(GdkWindow *parent,PieceSet *set,int sqside);
  virtual void lemming();
  virtual void destroy();
  virtual void step();
};

#endif
