/* $Id: position.h,v 1.21 2001/06/18 16:41:22 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef POSITION_H
#define POSITION_H 1

#include "eboard.h"
#include "stl.h"

class SMove {
 public:
  SMove(piece p,int sx,int sy,int dx,int dy);
  int distance();
  int valid();
  int SX,SY,DX,DY;
  piece Piece;
};

class Position {
 public:
  Position();  

  int operator==(Position &p);
  int operator!=(Position &p);
  Position operator=(Position &p);

  void  setStartPos();
  void  setPiece(int col,int row,piece p);
  piece getPiece(int col,int row);  
  void  setLastMove(char *s);
  char *getLastMove();
  char *getMaterialString(variant Vr=REGULAR);
  char *getHouseString();

  const char *getFEN();
  void setFEN(const char *fen);

  int  getStockCount(piece p);
  void clearStock();
  void incStockCount(piece p);
  void decStockCount(piece p);

  void  print();
  void  diff(Position &np,vector<SMove *> &sl);
  void  intersection(Position &b);

  void moveAnyNotation(char *m,piece color,variant Vr=REGULAR);
  void moveStdNotation(char *m,piece color,variant Vr=REGULAR);
  void moveCartesian(int x1,int y1,int x2,int y2,variant Vr=REGULAR);
  void moveDrop(piece p,int x2,int y2);

  void stdNotationForMove(int x1,int y1,int x2,int y2,piece prom,char *m,
			  variant Vr=REGULAR);
  void SANstring(char *src,char *dest);

  // randomly changes the position to make it "different"
  void  invalidate();

  // checking

  bool isMoveLegalCartesian(int x0,int y0,int x1,int y1,piece mycolor,variant vari);
  bool isDropLegal(piece p,int x1,int y1,piece mycolor,variant vari);

  bool maycastle[4]; // 0=white short, 1=black short, 2=white long, 3=black long
  int  ep[2]; // enpassant square (ep[0]=-1 for none, ep[0]=-2 for allow any)

 private:
  piece square[8][8];
  char LastMove[32];
  char MaterialString[32];
  char HouseString[64];
  int  House[5][2]; // {crazy,bug}house stock (P,R,N,B,Q)

  void locate(piece p,int *src,int *dest,int istake,variant Vr=REGULAR);
  void ambiguityCheck(piece p, piece c,int destx,int desty,
		      int exclx,int excly,
		      vector<int> & ambx, vector<int> & amby);
  bool canMove(piece p,piece c,int sx,int sy,int dx,int dy);
  bool isInCheck(piece c,variant Vr=REGULAR);
  bool isSquareInCheck(int x,int y,piece dc,variant Vr=REGULAR);
  void checkCastlingPossibility();

  bool isMate(piece c,variant Vr=REGULAR);

  void stdNotationForMoveInternal(int x1,int y1,int x2,int y2,char *m);
};

#endif
