/* easytag.h - 2000/04/28 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000-2002  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __EASYTAG_H__
#define __EASYTAG_H__


/* 'include' and 'define' created by autoconf/automake */
#include "../config.h"

#define APPNAME            "EasyTAG"
#define AUTHOR             "Jerome Couderc"    // Note: do not use accents
#define EMAIL              "j.couderc@ifrance.com"
#define WEBPAGE            "http://easytag.sourceforge.net"
/*#define VERSION "0.15.1" //Now version is defined into ../configure.h.in */

#define MAX_STRING_LEN     1024


/***************
 * Declaration *
 ***************/

/* Variable to force to quit recursive functions (reading dirs) or stop saving files */
gboolean Main_Stop_Button_Pressed;

GtkWidget *MainWindow;
GtkWidget *MenuArea;
GtkWidget *ToolArea;
GtkWidget *BrowseArea;
GtkWidget *FileArea;
GtkWidget *TagArea;
GtkWidget *StatusArea;
GtkWidget *ProgressArea;
GtkWidget *ReadOnlyStatusIconBox;
GtkWidget *BrokenStatusIconBox;
GtkWidget *MainWindowHPaned;

/* File Area */
GtkWidget *FileFrame;
GtkWidget *FileIndex;
GtkWidget *FileEntry;
GtkWidget *HeaderInfosTable;    /* declarated here to show/hide file header infos */
GtkWidget *VersionLabel;
GtkWidget *VersionValueLabel;
GtkWidget *BitrateLabel;
GtkWidget *BitrateValueLabel;
GtkWidget *SampleRateLabel;
GtkWidget *SampleRateValueLabel;
GtkWidget *ModeLabel;
GtkWidget *ModeValueLabel;
GtkWidget *SizeLabel;
GtkWidget *SizeValueLabel;
GtkWidget *DurationLabel;
GtkWidget *DurationValueLabel;

/* TAG Area */
GtkWidget *TagFrame;
GtkWidget *TitleEntry;
GtkWidget *ArtistEntry;
GtkWidget *AlbumEntry;
GtkWidget *YearEntry;
GtkWidget *TrackEntry;
GtkWidget *TrackTotalEntry;
GtkWidget *CommentEntry;
GtkWidget *GenreEntry;
/* Mini buttons */
GtkWidget *TitleMButton;
GtkWidget *ArtistMButton;
GtkWidget *AlbumMButton;
GtkWidget *YearMButton;
GtkWidget *TrackMButton;
GtkWidget *TrackMButtonSequence;
GtkWidget *CommentMButton;
GtkWidget *GenreMButton;

GdkCursor *MouseCursor;

gchar *HOME_VARIABLE;
gchar *INIT_DIRECTORY;

#ifndef errno
extern int errno;
#endif

/* A flag to start/avoid a new reading while an other one is running */
gboolean ReadingDirectory;


/**************
 * Prototypes *
 **************/
void Action_Select_Prev_File  (void);
void Action_Select_Next_File  (void);
void Action_Select_First_File (void);
void Action_Select_Last_File  (void);
void Action_Select_Nth_File_By_Key      (gulong key);
void Action_Select_Nth_File_By_Position (gulong num_item);

void Action_Scan_File         (void);
void Action_Remove_Tag        (void);
gint Action_Undo_File         (void);
gint Action_Redo_File         (void);
void Action_Save_File         (void);
gint Action_Save_File_With_Answer (gboolean multiple_files);

void Action_Scan_All_Files    (void);
void Action_Remove_All_Tags   (void);
void Action_Undo_All_Files    (void);
void Action_Redo_All_Files    (void);
void Action_Save_All_Files    (void);
gint Action_Save_All_Files_With_Answer (void);

void Action_Main_Stop_Button_Pressed (void);

void File_Area_Set_Sensitive (gboolean activate);
void Tag_Area_Set_Sensitive  (gboolean activate);

gboolean Delete_File (gchar *filename);
void Read_Directory  (gchar *path);
void Quit_MainWindow (void);
void Update_Command_Buttons_Sensivity (void);
void Attach_Popup_Menu_To_Tag_Entries (GtkEntry *entry);

void Clear_File_Entry_Field (void);
void Clear_Tag_Entry_Fields (void);
void Clear_Header_Fields    (void);


#endif /* __EASYTAG_H__ */
