/* browser.h - 2000/04/28 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000-2002  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __BROWSER_H__
#define __BROWSER_H__


#include "et_core.h"

/****************
 * Declarations *
 ****************/

/*
 * Data attached to each row of the tree
 */
typedef struct _DirNode DirNode;
struct _DirNode
{
    gboolean scanned;
    gchar   *path;
};


/*
 * Data attached to each row of the list
 */
typedef struct _FileRow FileRow;
struct _FileRow
{
    gint   key;                            // Value contained into ETFile
    gchar *path;     // Read only data!    // Value contained into ETFile
    ET_File *ETFile; // Pointer to the corresponding ETFile structure
};


GtkWidget *CheckMenuItemBrowseSubdirPopupMenu;
GtkWidget *BrowserEntry;
GtkWidget *BrowserHPaned;



/**************
 * Prototypes *
 **************/

GtkWidget  *Create_Browser_Items    (GtkWidget *parent);
gint        Browser_Tree_Select_Dir (gchar *current_path);
void        Browser_Tree_Rebuild    (gchar *path_to_load);
void        Browser_Tree_Collapse   (void);
//gint        Browser_Tree_Width (void);
//gint        Browser_Tree_Height (void);

void        Browser_List_Load_Files           (void);
void        Browser_List_Refresh_Whole_List   (void);
void        Browser_List_Refresh_File_In_List (ET_File *ETFile);
void        Browser_List_Clear          (void);
void        Browser_List_Select_File    (gint row);
void        Browser_List_Scroll_Vertical(GtkCList *clist, GtkScrollType scroll_type,
                                         gfloat position, gpointer user_data);
void        Browser_List_Set_Foregroung_Row_Color (guint row);

void        Browser_Entry_Set_Text      (gchar *text);

void        Browser_Area_Set_Sensitive  (gboolean activate);

void        Browser_Load_Home_Directory            (void);
void        Browser_Load_Default_Directory         (void);
void        Browser_Reload_Directory               (void);
gchar      *Browser_Tree_Get_Path_Of_Selected_Node (void);
void        Set_Current_Path_As_Default            (void);
gchar      *Browser_Get_Current_Path               (void);

void        Browser_Open_Rename_Directory_Window (void);
void        Browser_Open_Run_Program_Tree_Window (void);
void        Browser_Open_Run_Program_List_Window (void);


#endif /* __BROWSER_H__ */
