/* scan.h - 2000/06/16 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000-2002  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SCAN_H__
#define __SCAN_H__


#include "et_core.h"

/****************
 * Declarations *
 ****************/
GtkWidget *ScannerWindow;
GtkWidget *SWScanButton;    // To enable/disable it in easytag.c
GtkWidget *SWScanAllButton; // To enable/disable it in easytag.c

typedef enum
{
    SCANNER_FILL_TAG = 0,
    SCANNER_RENAME_FILE,
    SCANNER_PROCESS_FIELDS
} Scanner_Option_Menu_Items_Value;


/**************
 * Prototypes *
 **************/

void Scan_Tag_With_Mask         (ET_File *ETFile);
void Scan_Rename_File_With_Mask (ET_File *ETFile);
void Scan_Process_Fields        (ET_File *ETFile);
void Scan_Select_Mode_And_Run_Scanner (void);

void Scan_Process_Fields_All_Uppercase (gchar *text);
void Scan_Process_Fields_All_Downcase (gchar *text);
void Scan_Process_Fields_Letter_Uppercase (gchar *text);
void Scan_Process_Fields_First_Letters_Uppercase (gchar *text);
void Scan_Process_Fields_Remove_Space (gchar *text);
void Scan_Process_Fields_Insert_Space (gchar *text);
void Scan_Process_Fields_Keep_One_Space (gchar *text);

void Scan_Convert_Underscore_Into_Space (gchar *string);
void Scan_Convert_P20_Into_Space (gchar *string);
void Scan_Convert_Space_Into_Undescore (gchar *string);

void Init_ScannerWindow (void);
void Open_ScannerWindow (Scanner_Option_Menu_Items_Value scanner_type);
gboolean Scanner_Option_Menu_Get_Active_Menu_Item (Scanner_Option_Menu_Items_Value item);
void Scan_Apply_Changes (void);

void Scan_Display_Info (void);
void Scan_Set_Scanner_Window_Init_Position (void);

void Scan_Rename_File_Generate_Preview (void);


/* For debugging */
void Scan_Display_Data_List (GList *list);
void Scan_Display_Data_List_Masks_List (void);


#endif /* __SCAN_H__ */
