/* prefs.h - 2000/05/06 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000-2002  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __PREFS_H__
#define __PREFS_H__


/***************
 * Declaration *
 ***************/

GtkWidget *OptionsWindow;
GtkWidget *OptionsNoteBook;
gint OptionsNoteBook_Scanner_Page_Num;    /* Contains the number of the page "Scanner Option" */


/* Widgets included in config */
/* Common */
GtkWidget *LoadOnStartup;
GtkWidget *DefaultPathToMp3;
GtkWidget *BrowserLineStyleOptionMenu;
GtkWidget *BrowserExpanderStyleOptionMenu;
GtkWidget *WriteId3v1Tag;
GtkWidget *WriteId3v2Tag;
GtkWidget *StripTagWhenEmptyFields;
GtkWidget *BrowseSubdir;
GtkWidget *OpenSelectedBrowserNode;
GtkWidget *KeepTreeBrowserInMemory;
GtkWidget *SaveConfigBeforeExit;

/* User interface */
GtkWidget *SetMainWindowSize;
GtkWidget *MainWindowHeight;
GtkWidget *MainWindowWidth;
GtkWidget *MainWindowButton;
GtkWidget *SetPaneHandlePosition1;
GtkWidget *PaneHandlePosition1;
GtkWidget *PaneHandleButton1;
GtkWidget *SetPaneHandlePosition2;
GtkWidget *PaneHandlePosition2;
GtkWidget *PaneHandleButton2;

GtkWidget *ShowHeaderInfos;
GtkWidget *UseColoredTooltips;

/* Misc */
GtkWidget *ReplaceIllegalCharactersInFilename;
GtkWidget *DateAutoCompletion;
GtkWidget *NumberTrackFormated;
GtkWidget *OggTagWriteXmmsComment;
GtkWidget *SortingFileOptionMenu;
GtkWidget *SortingFileCaseSensitive;
GtkWidget *UseCharacterSetTranslation;
GtkWidget *FileCharacterSetEntry;
GtkWidget *UserCharacterSetEntry;

GtkWidget *MessageBoxPositionNone;
GtkWidget *MessageBoxPositionCenter;
GtkWidget *MessageBoxPositionMouse;

GtkWidget *FilePlayerEntry;

/* Scanner */
GtkWidget *ConvertUnderscoreAndP20IntoSpace;
GtkWidget *ConvertSpaceIntoUnderscore;
GtkWidget *OverwriteTagField;
GtkWidget *OpenScannerWindowOnStartup;
GtkWidget *ScannerWindowOnTop;

GtkWidget *SetDefaultComment;
GtkWidget *DefaultComment;

GtkWidget *SetScannerWindowPosition;
GtkWidget *ScannerWindowX;
GtkWidget *ScannerWindowY;
GtkWidget *ScannerWindowButton;

/* Confirmation */
GtkWidget *ConfirmBeforeExit;
GtkWidget *ConfirmWriteTag;
GtkWidget *ConfirmRenameFile;
GtkWidget *ConfirmWritePlayList;



/**************
 * Prototypes *
 **************/

void Init_OptionsWindow (void);
void Open_OptionsWindow (void);

void File_Selection_Window_For_File      (GtkWidget *widget);
void File_Selection_Window_For_Directory (GtkWidget *widget);


#endif /* __PREFS_H__ */
