/*
    Dysnomia 0.3.4 (BETA)
    Copyright (C) 2007 Benjamin Renaut

    Dysnomia is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    Dysnomia is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Dysnomia; if not, write to the Free Software Foundation,
    Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    -----

    solozerk@sekren.org
    http://www.dysnomia-project.org/
    IRC: #dysnomia@irc.code-libre.org
*/

#ifndef __DYSNOMIA_MAIN_HPP
#define __DYSNOMIA_MAIN_HPP

#include "deezer.hpp"

#include "wx/wxprec.h"
#include "wx/listctrl.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif


class DysnomiaApp : public wxApp
{
public:
  virtual bool OnInit();
  virtual int OnExit();
};


class DysnomiaFrame : public wxFrame
{
public:
  DysnomiaFrame(const wxString& title, const wxPoint& pos, const wxSize& size,
		  long style = wxDEFAULT_FRAME_STYLE);

  void OnQuit(wxCommandEvent& event);
  void OnAbout(wxCommandEvent& event);
  void OnHelp(wxCommandEvent& event);
  void OnSearch(wxCommandEvent& event);
  void OnDownload(wxCommandEvent& event);

private:
  wxBoxSizer* sizer_frame;
  wxBoxSizer* sizer_search;
  wxTextCtrl* searchbox;
  wxButton* button_search;
  wxButton* button_download;
  wxListCtrl* list_search;
  wxMenu *menuOptions;

  vector<song>* actual_song_list;

  DECLARE_EVENT_TABLE()
};

enum
{
  Dysnomia_Quit = 1,
  Dysnomia_Help = 2,
  Dysnomia_Search = 3,
  Dysnomia_Download = 4,
  Dysnomia_NormalDownload = 5,
  Dysnomia_CacheDownload = 6,
  Dysnomia_SearchBox = 7,
  Dysnomia_About = wxID_ABOUT
};


BEGIN_EVENT_TABLE(DysnomiaFrame, wxFrame)
    EVT_MENU(Dysnomia_Quit,  DysnomiaFrame::OnQuit)
    EVT_MENU(Dysnomia_Help, DysnomiaFrame::OnHelp)
    EVT_MENU(Dysnomia_About, DysnomiaFrame::OnAbout)
    EVT_BUTTON(Dysnomia_Search, DysnomiaFrame::OnSearch)
    EVT_BUTTON(Dysnomia_Download, DysnomiaFrame::OnDownload)
    EVT_TEXT_ENTER(Dysnomia_SearchBox, DysnomiaFrame::OnSearch)
END_EVENT_TABLE()


IMPLEMENT_APP(DysnomiaApp)


#endif //__DYSNOMIA_MAIN_HPP
