/*
    Dysnomia 0.3.4 (BETA)
    Copyright (C) 2007 Benjamin Renaut

    Dysnomia is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    Dysnomia is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Dysnomia; if not, write to the Free Software Foundation,
    Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    -----

    solozerk@sekren.org
    http://www.dysnomia-project.org/
    IRC: #dysnomia@irc.code-libre.org
*/

#include "main.hpp"


bool DysnomiaApp::OnInit()
{
  DysnomiaFrame *frame = new DysnomiaFrame(_T("Dysnomia 0.3.4 (BETA)"),
					   wxPoint(50, 50), wxSize(650, 600),
                       wxMINIMIZE_BOX | wxMAXIMIZE_BOX | wxSYSTEM_MENU | 
                       wxCAPTION | wxCLOSE_BOX | wxCLIP_CHILDREN);
  
  srand((int)time(NULL));
  if(curl_global_init(CURL_GLOBAL_WIN32))
  {
    cerr<<"Error : unable to initialize curl."<<endl;
    exit(42);
  }
  
  frame->Show(TRUE);
  return TRUE;
}


int DysnomiaApp::OnExit()
{
  curl_global_cleanup();
  return(42);    // THE answer.
}


DysnomiaFrame::DysnomiaFrame(const wxString& title, const wxPoint& pos, const wxSize& size, long style)
       : wxFrame(NULL, -1, title, pos, size, style)
{
  actual_song_list=NULL;

#if wxUSE_MENUS
  wxMenu *menuFile = new wxMenu;
  menuOptions = new wxMenu;
  wxMenu *helpMenu = new wxMenu;
  helpMenu->Append(Dysnomia_Help, _T("&Help\tF1"), _T("Help"));
  helpMenu->Append(Dysnomia_About, _T("&About Dysnomia\tF2"), _T("Informations about Dysnomia"));

#if wxCHECK_VERSION(2, 8, 0)
#ifdef _UNICODE
  menuFile->AppendSubMenu(menuOptions, _T("&Options"), _T("Download options"));
#else
  menuFile->AppendSubMenu(menuOptions, _T("&Options"), _T("Download options"));
#endif
#else
#ifdef _UNICODE
  menuFile->Append(-1, _T("&Options"), menuOptions, _T("Download options"));
#else
  menuFile->Append(-1, _T("&Options"), menuOptions, _T("Download options"));
#endif
#endif

#ifdef _UNICODE
  menuOptions->AppendRadioItem(Dysnomia_NormalDownload, _T("Regular download"), _T("\"Regular\" download : same behaviour as the deezer.com flash applet"));
#else
  menuOptions->AppendRadioItem(Dysnomia_NormalDownload, _T("Regular download"), _T("\"Regular\" download : same behaviour as the deezer.com flash applet"));
#endif
#ifdef _UNICODE
  menuOptions->AppendRadioItem(Dysnomia_CacheDownload, _T("Alternative download"), _T("Download by directly accesing deezer's cache"));
#else
  menuOptions->AppendRadioItem(Dysnomia_CacheDownload, _T("Alternative download"), _T("Download by directly accesing deezer's cache"));
#endif
  menuFile->Append(Dysnomia_Quit, _T("&Quit\tCtrl-X"), _T("Quit the program"));
  wxMenuBar *menuBar = new wxMenuBar();
  menuBar->Append(menuFile, _T("&File"));
  menuBar->Append(helpMenu, _T("&Help"));
  SetMenuBar(menuBar);
#endif

#if wxUSE_STATUSBAR
  CreateStatusBar(1);
#endif

#ifdef __WINDOWS__
  SetBackgroundColour(wxColour(212, 208, 200));
#endif

  sizer_frame=new wxBoxSizer(wxVERTICAL);
  sizer_search=new wxBoxSizer(wxHORIZONTAL);
  searchbox=new wxTextCtrl(this, Dysnomia_SearchBox, _("tryad"), wxDefaultPosition, wxSize(530, 30), wxTE_PROCESS_ENTER);
  button_search=new wxButton(this, Dysnomia_Search, _("Search"), wxDefaultPosition, wxSize(100, 30));
#ifdef _UNICODE
  button_download=new wxButton(this, Dysnomia_Download, _("Download"), wxDefaultPosition, wxSize(640, 30));
#else
  button_download=new wxButton(this, Dysnomia_Download, _("Download"), wxDefaultPosition, wxSize(640, 30));
#endif
  
#ifdef __WINDOWS__
  list_search=new wxListCtrl(this, -1, wxDefaultPosition, wxSize(639, 463), wxLC_REPORT|wxLC_VRULES|wxLC_HRULES);
#else
  list_search=new wxListCtrl(this, -1, wxDefaultPosition, wxSize(640, 470), wxLC_REPORT|wxLC_VRULES|wxLC_HRULES);
#endif

#ifdef __WINDOWS__
  list_search->InsertColumn(0, _("Artist"), wxLIST_FORMAT_LEFT, 213);
  list_search->InsertColumn(1, _("Title"), wxLIST_FORMAT_LEFT, 211);
  list_search->InsertColumn(2, _("Album"), wxLIST_FORMAT_LEFT, 211);
#else
  list_search->InsertColumn(0, _("Artist"), wxLIST_FORMAT_LEFT, 214);
  list_search->InsertColumn(1, _("Title"), wxLIST_FORMAT_LEFT, 213);
  list_search->InsertColumn(2, _("Album"), wxLIST_FORMAT_LEFT, 214);
#endif

  sizer_search->Add(searchbox, 0, wxALL|wxALIGN_LEFT, 3);
  sizer_search->Add(button_search, 0, wxALL|wxALIGN_RIGHT, 3);
  sizer_frame->Add(sizer_search, 0, wxALL|wxALIGN_TOP, 3);
  sizer_frame->Add(list_search, 0, wxALL|wxALIGN_TOP, 0);
  sizer_frame->Add(button_download, 0, wxALL|wxALIGN_TOP, 0);

  SetSizer(sizer_frame);
}


void DysnomiaFrame::OnQuit(wxCommandEvent& WXUNUSED(event))
{
  curl_global_cleanup();
  Close(TRUE);
}


void DysnomiaFrame::OnAbout(wxCommandEvent& WXUNUSED(event))
{
  wxString msg;
#ifdef _UNICODE
  msg.Printf( _T("Dysnomia 0.3.4 (BETA)\n")
	      _T("by Solozerk <solozerk@sekren.org>\nhttp://www.dysnomia-project.org/\nDysnomia is licensed under GPL - see COPYING file\n\nBETA version - This program is not stable and is likely to have a lot of bugs.\n\nUsing Dysnomia to download songs that are not freely copyable is *ILLEGAL*, you shouldn't use it for that. If you use it to do that, you take all responsability - see README file."));
#else
  msg.Printf( _T("Dysnomia 0.3.4 (BETA)\n")
	      _T("by Solozerk <solozerk@sekren.org>\nhttp://www.dysnomia-project.org/\nDysnomia is licensed under GPL - see COPYING file\n\nBETA version - This program is not stable and is likely to have a lot of bugs.\n\nUsing Dysnomia to download songs that are not freely copyable is *ILLEGAL*, you shouldn't use it for that. If you use it to do that, you take all responsability - see README file."));	      
#endif  
  wxMessageBox(msg, _T("About Dysnomia"), wxOK | wxICON_INFORMATION, this);
}


void DysnomiaFrame::OnHelp(wxCommandEvent& WXUNUSED(event))
{
  wxString msg;
#ifdef _UNICODE
  msg.Printf( _T("Type in a search expression (\"tryad\" for example), then click on the \"Search\" button. A list of songs will be displayed.\nSelect the songs you wish to download.\n\nWhen you're done, click on the \"Download\" button to proceed to the download. A dialog will then ask you where you want to download the files.\n\nUsing Dysnomia to download songs that are not freely copyable is *ILLEGAL*, you shouldn't use it for that. If you use it to do that, you take all responsability - see README file."));
#else
  msg.Printf( _T("Type in a search expression (\"tryad\" for example), then click on the \"Search\" button. A list of songs will be displayed.\nSelect the songs you wish to download.\n\nWhen you're done, click on the \"Download\" button to proceed to the download. A dialog will then ask you where you want to download the files.\n\nUsing Dysnomia to download songs that are not freely copyable is *ILLEGAL*, you shouldn't use it for that. If you use it to do that, you take all responsability - see README file."));
#endif
  
  wxMessageBox(msg, _T("Help"), wxOK | wxICON_QUESTION, this);
}


void DysnomiaFrame::OnSearch(wxCommandEvent& WXUNUSED(event))
{
  SetStatusText(_T("Search in progress..."));

  if(actual_song_list!=NULL)
    delete actual_song_list;

  actual_song_list=search_deezer((searchbox->GetValue()).fn_str());

  if((actual_song_list->size())==0)
  {
    list_search->DeleteAllItems();
    wxString msg;
#ifdef _UNICODE
    msg.Printf( _T("There was no result for your search."));  
    wxMessageBox(msg, _T("No result"), wxOK | wxICON_INFORMATION, this);
#else
    msg.Printf( _T("There was no result for your search."));  
    wxMessageBox(msg, _T("No result"), wxOK | wxICON_INFORMATION, this);
#endif
  }
  else
  {
    list_search->DeleteAllItems();
    for(unsigned int i=0; i<actual_song_list->size(); ++i)
    {
#ifdef _UNICODE
      list_search->InsertItem(i, wxConvUTF8.cMB2WC((*actual_song_list)[i].artist.c_str()));
      list_search->SetItem(i, 1, wxConvUTF8.cMB2WC((*actual_song_list)[i].title.c_str()));
      list_search->SetItem(i, 2, wxConvUTF8.cMB2WC((*actual_song_list)[i].album.c_str()));
#else
      list_search->InsertItem(i, (*actual_song_list)[i].artist.c_str());
      list_search->SetItem(i, 1, (*actual_song_list)[i].title.c_str());
      list_search->SetItem(i, 2, (*actual_song_list)[i].album.c_str());
#endif
    }
  }

  SetStatusText(_T(""));
}


void DysnomiaFrame::OnDownload(wxCommandEvent& WXUNUSED(event))
{
#ifdef _UNICODE
  wxString dir = wxDirSelector(_("Where do you want to download the files ?"));
#else
  wxString dir = wxDirSelector(_("Where do you want to download the files ?"));
#endif
  
  if(dir!=_(""))
  {
#ifdef _UNICODE
    SetStatusText(_T("Download in progress..."));
#else
    SetStatusText(_T("Download in progress..."));
#endif
    long item = -1;
    for(;;)
    {
      item = list_search->GetNextItem(item, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
      if(item==-1)
	break;
      if(menuOptions->IsChecked(Dysnomia_NormalDownload))
        deezer_download(dir.mb_str(wxConvUTF8), (*actual_song_list)[item].unique_id.c_str(), (*actual_song_list)[item].title.c_str());
      else
        deezer_cache_download(dir.mb_str(wxConvUTF8), (*actual_song_list)[item].unique_id.c_str(), (*actual_song_list)[item].title.c_str());
    }
    wxString msg;
#ifdef _UNICODE
    msg.Printf( _T("Download finished."));  
    wxMessageBox(msg, _T("Download finished"), wxOK | wxICON_INFORMATION, this);
#else
    msg.Printf( _T("Download finished."));  
    wxMessageBox(msg, _T("Download finished"), wxOK | wxICON_INFORMATION, this);
#endif
    SetStatusText(_T(""));
  }
}
