/*
    Dysnomia 0.3.4 (BETA)
    Copyright (C) 2007 Benjamin Renaut

    Dysnomia is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    Dysnomia is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Dysnomia; if not, write to the Free Software Foundation,
    Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    -----

    solozerk@sekren.org
    http://www.dysnomia-project.org/
    IRC: #dysnomia@irc.code-libre.org
*/


#ifndef __DYSNOMIA_DEEZER_HPP
#define __DYSNOMIA_DEEZER_HPP


#include "wx/wx.h"
#ifdef __WINDOWS__
#include <unistd.h>
#else
#include <arpa/inet.h>
#endif
#include <iostream>
#include <vector>
#include <string>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>
using namespace std;


const char amfphp_search_serialized_part1[]="\x0\x0\x0\x0\x0\x1\x0\x19rp_search_release7.search\x0\x2/1\x0\x0";
const char amfphp_search_serialized_part2[]="\xa\x0\x0\x0\x1\x2";

const char amfphp_initsession_serialized[]="\x0\x0\x0\x0\x0\x1\x0\x1erp_search_release7.initSession\x0\x2\x2f\x31\x0\x0\x0\x5\xa\x0\x0\x0\x0";
const char amfphp_getkey_serialized_part1[]="\x0\x0\x0\x0\x0\x1\x0\x19rp_search_release7.getKey\x0\x2\x2f\x32\x0\x0";
const char amfphp_getkey_serialized_part2[]="\xa\x0\x0\x0\x2\x2";
const char amfphp_getkey_serialized_part3[]="\x2";

// The search request XOR crypting key (v 7c).

const unsigned int deezer_search_key[216]={199, 69, 204, 11, 92, 6, 26, 169, 236, 36, 137, 44, 116, 167, 190, 156, 230, 162, 95, 174, 252, 124, 94, 240, 54, 207, 85, 24, 27, 199, 254, 51, 224, 194, 28, 235, 121, 81, 235, 59, 99, 42, 141, 1, 238, 109, 136, 29, 126, 132, 35, 5, 154, 93, 222, 225, 117, 201, 237, 7, 77, 118, 71, 224, 58, 20, 230, 173, 135, 123, 219, 59, 215, 188, 175, 46, 134, 101, 58, 7, 131, 71, 29, 29, 215, 137, 118, 123, 116, 124, 26, 179, 79, 71, 195, 228, 1, 66, 190, 16, 153, 122, 172, 243, 37, 84, 52, 224, 0, 80, 179, 48, 241, 77, 226, 162, 115, 21, 189, 116, 32, 187, 3, 132, 155, 14, 206, 44, 94, 53, 122, 118, 184, 32, 117, 153, 217, 126, 206, 80, 48, 107, 10, 210, 235, 104, 76, 134, 62, 78, 62, 96, 152, 13, 143, 151, 99, 213, 62, 149, 149, 98, 248, 84, 172, 204, 101, 133, 108, 223, 19, 237, 196, 92, 114, 66, 78, 169, 10, 16, 149, 64, 164, 194, 191, 166, 217, 250, 18, 182, 205, 251, 65, 72, 223, 158, 157, 8, 137, 30, 77, 91, 147, 6, 149, 227, 172, 139, 216, 122, 187, 118, 4, 119, 208, 245};

// There is now two different keys here.
// Besides, two RC4 are now applied to the session_id/streaming key, which is no
// more useful (that is, totally useless) than one.

// The streaming key XOR crypting key, v 7b
const unsigned int deezer_streaming_key[24]={246, 73, 184, 214, 95, 23, 185, 121, 202, 15, 39, 120, 193, 190, 236, 170, 61, 82, 73, 102, 90, 123, 129, 8};
// The session id XOR crypting key, v 7b
const unsigned int deezer_sessions_key[24]={9, 55, 125, 125, 15, 147, 226, 60, 114, 144, 166, 8, 83, 184, 57, 234, 171, 13, 71, 134, 167, 42, 119, 142};


#define TEMP_SEARCHRESULTS_FILENAME "/tmp/tmp_searchresults"

#define TYPE_STREAMING 0
#define TYPE_SESSION   1


struct song
{
public:
  string artist;
  string title;
  string album;
  string imgurl;
  string unique_id;

  song(string m_artist, string m_title, string m_album, string m_imgurl, string m_unique_id)
  {
    artist=m_artist;
    title=m_title;
    album=m_album;
    imgurl=m_imgurl;
    unique_id=m_unique_id;
  }
};


vector<song>* search_deezer(const char* search);
void deezer_download(const char* dir, const char* id, const char* name);
void deezer_cache_download(const char* dir, const char* id, const char* name);


#endif //__DYSNOMIA_DEEZER_HPP
