/*
 DSPAM
 COPYRIGHT (C) 2002-2004 NETWORK DWEEBS CORPORATION

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
   This file contains Win32-specific support functions.
 */

#ifdef HAVE_CONFIG_H
#include <auto-config.h>
#endif

#include <stdlib.h>
#include "util.h"

#include "dir_win32.h"

/*
   POSIX open/read/closedir() emulation.
 */

DIR *opendir(const char *filename)
{
  DIR *dir = malloc(sizeof(DIR));
  if ( dir )
  {
    dir->hFind = INVALID_HANDLE_VALUE;
    strlcpy(dir->dirname, filename, sizeof(dir->dirname));
  }

  return dir;
}

struct dirent *readdir(DIR *dir)
{
  WIN32_FIND_DATA fdata;
  struct dirent *de;

  if ( dir->hFind == INVALID_HANDLE_VALUE )
  {
    dir->hFind = FindFirstFile(dir->dirname, &fdata);
    if ( dir->hFind == INVALID_HANDLE_VALUE )
      return NULL;
  }
  else
  {
    if ( !FindNextFile(dir->hFind, &fdata) )
      return NULL;
  }

  de = malloc(sizeof(struct dirent));
  strlcpy(de->d_name, fdata.cFileName, sizeof(de->d_name));

  return de;
}

void closedir(DIR *dir)
{
  FindClose(dir->hFind);
  free(dir);
}

/*
   DSPAM_HOME
 */
static char dspam_home[MAX_PATH];

void dspam_set_home(const char *home)
{
  strlcpy(dspam_home, home, sizeof(dspam_home));
}

const char *dspam_get_home(void)
{
  /* check if we have a valid home */
  if ( !dspam_home[0] )
  {
    /*
      determine it ourselves if we don't: note that the proper way to do this
      would be by using SHGetFolderPath() but this function is not available on
      earlier Windows systems and so we'd have to load it dynamically from
      shell32.dll which is slightly painful, so let those who really want to do
      it call our dspam_set_home() themselves instead and use the easy way here
     */
    const char *home = getenv("DSPAM_HOME");
    if ( !home )
        home = getenv("HOME");
    if ( home )
      dspam_set_home(home);
    else
    {
      const char *homedrive = getenv("HOMEDRIVE");
      const char *homepath = getenv("HOMEPATH");
      if ( homedrive && homepath )
      {
        strlcpy(dspam_home, homedrive, sizeof(dspam_home));
        strlcat(dspam_home, homepath, sizeof(dspam_home));
      }
      else
      {
        /* what else can we do? */
        dspam_set_home("C:\\dspam");
      }
    }
  }

  return dspam_home;
}

