/*
  decode_nntp.c

  Network News Transport Protocol.
  
  Copyright (c) 2000 Felix von Leitner <felix@convergence.de>
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_nntp.c,v 1.2 2000/06/14 16:16:00 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

int
decode_nntp(u_char *buf, int len)
{
	char *p;
	
	Buf[0] = '\0';
	
	for (p = strtok(buf, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
		if (strncasecmp(p, "AUTHINFO ", 9) == 0) {
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
		}
	}
	return (strlen(Buf));
}

