/*
  decode_mountd.c

  RPC mountd.

  Outputs filehandle in nfsshell format. :-)
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_mountd.c,v 1.3 2000/06/14 07:14:53 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <sys/param.h>
#include <rpc/rpc.h>
#include <rpcsvc/mount.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rpc.h"
#include "decode.h"

int
decode_mountd(u_char *buf, int len)
{
	struct rpc_msg msg;
	struct xid_map *xm;
	XDR xdrs;
	char *p, *dir, *fh;
	struct fhstatus fhstat;
	int i, hdrlen;
	
	memset(&msg, 0, sizeof(msg));
	
	if ((hdrlen = rpc_decode(buf, len, &msg)) == 0)
		return (0);

	Buf[0] = '\0';
	
	if (msg.rm_direction == CALL &&
	    msg.rm_call.cb_prog == MOUNTPROG &&
	    msg.rm_call.cb_proc == MOUNTPROC_MNT) {
		xdrmem_create(&xdrs, buf + hdrlen, len - hdrlen, XDR_DECODE);
		dir = NULL;
		if (xdr_string(&xdrs, &dir, MAXPATHLEN)) {
			xid_map_enter(msg.rm_xid, MOUNTPROG, MOUNTVERS,
				      MOUNTPROC_MNT, (void *) dir);
		}
		xdr_destroy(&xdrs);
	}
	else if (msg.rm_direction == REPLY &&
		 (xm = xid_map_find(msg.rm_xid)) != NULL) {
		if (msg.rm_reply.rp_stat == MSG_ACCEPTED &&
		    msg.acpted_rply.ar_stat == SUCCESS) {
			xdrmem_create(&xdrs, buf + hdrlen, len - hdrlen,
				      XDR_DECODE);
			if (xdr_fhstatus(&xdrs, &fhstat)) {
				if (fhstat.fhs_status == 0) {
					snprintf(Buf, sizeof(Buf), "%s [",
						 (char *)xm->data);
					fh = Buf + strlen(Buf);
					p = fhstat.fhstatus_u.fhs_fhandle;
					
					for (i = 0; i < FHSIZE; i++)
						sprintf(fh + (i * 3), "%.2x ",
							p[i] & 0xff);
					fh[(i * 3) - 1] = '\0';
					strlcat(Buf, "]\n", sizeof(Buf));
				}
			}
			xdr_destroy(&xdrs);
		}
		free(xm->data);
		memset(xm, 0, sizeof(*xm));
	}
	return (strlen(Buf));
}
