/*
  decode_irc.c

  Internet Relay Chat.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_irc.c,v 1.3 2000/06/17 16:29:50 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

int
decode_irc(u_char *buf, int len)
{
	int got_auth = 0;
	char *p, *q;
	
	Buf[0] = '\0';
	
	for (p = strtok(buf, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
		if (p[0] == ';') {
			if ((q = strchr(p, ' ')) == NULL)
				continue;
			q++;
		}
		else q = p;
		
		if (strncasecmp(q, "USER ", 5) == 0 ||
		    strncasecmp(q, "NICK ", 5) == 0) {
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
		}
		else if (strncasecmp(q, "PASS ", 5) == 0 ||
			 strncasecmp(q, "OPER ", 5) == 0 ||
			 (strncasecmp(q, "MODE ", 5) == 0 &&
			  strstr(q, " +k ") != NULL) ||
			 (strncasecmp(q, "JOIN ", 5) == 0 &&
			  (q = strchr(q + 5, ' ')) != NULL && q[1] != '\0')) {
			got_auth = 1;
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
		}
	}
	return (got_auth ? strlen(Buf) : 0);
}
