/*
  decode_imap.c

  Internet Mail Access Protocol.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
  
  $Id: decode_imap.c,v 1.2 2000/06/14 16:16:00 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

int
decode_imap(u_char *buf, int len)
{
	char *p;
	
	Buf[0] = '\0';
	
	for (p = strtok(buf, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
		if ((p = strchr(p, ' ')) != NULL) {
			p++;
			if (strncasecmp(p, "LOGIN ", 6) == 0) {
				strlcat(Buf, p, sizeof(Buf));
				strlcat(Buf, "\n", sizeof(Buf));
			}
		}
	}
	return (strlen(Buf));
}

