/*
  decode_citrix.c

  Citrix ICA.

  http://www.securityfocus.com/templates/archive.pike?list=1&date=200 \
  0-04-15&msg=Pine.BSO.4.20.0003290949280.2640-100000@naughty.monkey.org
  
  Thanks to Jeremie Kass <jeremie@monkey.org> for providing me with
  traffic traces.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_citrix.c,v 1.2 2000/06/14 16:15:59 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

int
decode_citrix(u_char *buf, int len)
{
	static u_char ica_magic[] = { 0x32, 0x26, 0x85, 0x92, 0x58 };
	u_char key, *p, *end;
	int i, lines;
	
	end = buf + len;
	i = 0;
	
	for (p = buf; p != NULL && end - p > 60 && i < sizeof(Buf); ) {
		if ((p = bufbuf(p, len, ica_magic, 5)) == NULL)
			break;
		
		key = p[17]; p += 60;
		Buf[i++] = (key | 'C') ^ p[0];
		lines = 0;
		
		for (p++; p < end; p += 2) {
			if (i > sizeof(Buf) - 1)
				break;
			
			if ((Buf[i++] = p[0] ^ p[1] ^ key) == '\0') {
				Buf[i - 1] = '\n';
				if (++lines >= 3)
					break;
			}
		}
	}
	Buf[i] = '\0';
	
	return (i);
}
