/*
  tcp_raw.h

  Raw (best-effor, half-duplex) TCP reassembly. Haaacccck.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
  
  $Id: tcp_raw.h,v 1.1 2000/05/18 20:20:04 dugsong Exp $
*/

#ifndef TCP_RAW_H
#define TCP_RAW_H

typedef void (*tcp_raw_callback_t)(u_long src, u_long dst,
				   u_short sport, u_short dport,
				   u_char *buf, int len);

struct iovec   *tcp_raw_input(struct ip *ip, struct tcphdr *tcp, int len);

void		tcp_raw_timeout(int timeout, tcp_raw_callback_t callback);

#endif /* TCP_RAW_H */
