/*
  decode_snmp.c

  Simple Network Management Protocol.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_snmp.c,v 1.1 2000/05/16 17:31:14 dugsong Exp $
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "asn1.h"
#include "decode.h"

int
decode_snmp(u_char *buf, int len)
{
	u_char *p = buf;
	int i, vers;
	
	if (len < 20) return (0);
	
	if (asn1_type(&p) != ASN1_SEQUENCE)
		return (0);
	i = asn1_len(&p);		/* XXX - skip sequence length */
	
	if (asn1_type(&p) != ASN1_INTEGER)
		return (0);
	if (asn1_len(&p) != 1)		/* XXX - check version length */
		return (0);
	vers = *p++;
	
	if (asn1_type(&p) != ASN1_STRING)
		return (0);
	i = asn1_len(&p);
	if ((p - buf) + i > len)
		return (0);
	p[i] = '\0';
	
	snprintf(Buf, sizeof(Buf), "[version %d]\n%s\n", vers + 1, p);
	
	return (strlen(Buf));
}

