/*
  decode_pop.c

  Post Office Protocol.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_pop.c,v 1.1 2000/05/16 17:31:14 dugsong Exp $
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "base64.h"
#include "options.h"
#include "decode.h"

int
decode_poppass(u_char *buf, int len)
{
	char *p;
	
	Buf[0] = '\0';
	
	for (p = strtok(buf, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
		if (strncasecmp(p, "user ", 5) == 0 ||
		    strncasecmp(p, "pass ", 5) == 0 ||
		    strncasecmp(p, "newpass ", 8) == 0) {
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
		}
	}
	if (strip_lines(Buf, Opt_lines) < 3)
		return (0);
	
	return (strlen(Buf));
}

int
decode_pop(u_char *buf, int len)
{
	char *p;
	int i, j;
	
	Buf[0] = '\0';
	
	for (p = strtok(buf, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
		if (strncasecmp(p, "AUTH PLAIN", 10) == 0 ||
		    strncasecmp(p, "AUTH LOGIN", 10) == 0) {
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
			
			/* Decode SASL auth. */
			for (i = 0; i < 2 && (p = strtok(NULL, "\r\n")); i++) {
				strlcat(Buf, p, sizeof(Buf));
				j = base64_pton(p, p, strlen(p));
				p[j] = '\0';
				strlcat(Buf, " [", sizeof(Buf));
				strlcat(Buf, p, sizeof(Buf));
				strlcat(Buf, "]\n", sizeof(Buf));
			}
		}
		/* Save regular POP2, POP3 auth info. */
		else if (strncasecmp(p, "USER ", 5) == 0 ||
			 strncasecmp(p, "PASS ", 5) == 0 ||
			 strncasecmp(p, "HELO ", 5) == 0) {
			strlcat(Buf, p, sizeof(Buf));
			strlcat(Buf, "\n", sizeof(Buf));
		}
	}
	return (strlen(Buf));
}

