/*
  decode_oracle.c

  Oracle SQL*Net v2/Net8.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_oracle.c,v 1.1 2000/05/16 17:31:14 dugsong Exp $
*/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

/* XXX - dag nasty. anyone have protocol specs? */
int
decode_oracle(u_char *buf, int len)
{
	u_char *p, *q;
	u_short i, j;
	
	p = buf;
	
	/* Save TNS connect string. */
	i = ntohs(*(u_short *)p);
	if (i >= len) return (0);
	for (q = p + i; q != p && q[-1]; q--) ;
	p[i] = '\0';
	strlcpy(Buf, q, sizeof(Buf));
	strlcat(Buf, "\n", sizeof(Buf));
	p += i;
	
	/* XXX - skip initial username message. */
	if ((p = bufbuf(p, len, "(TNS V", 6)) == NULL) return (0);
	if ((i = len - (p - buf)) <= 0) return (0);
	if ((p = memchr(p, ')', i)) == NULL) return (0);
	
	/* Parse auth messages. */
	for (p++; p - buf < len; p += i) {
		i = ntohs(*(u_short *)p);
		if (i > len - (p - buf) || i < 56)	/* XXX */
			break;
		if (memcmp(p + 4, "\x06\x00\x00\x00\x00\x00\x03\x3a", 8) != 0)
			continue;
		j = ntohs(*(u_short *)(p + 19));
		for (q = p + i; q != p && q[-1]; q--) ;
		q[j] = '\0';
		strlcat(Buf, q, sizeof(Buf));
		strlcat(Buf, "\n", sizeof(Buf));
	}
	return (strlen(Buf));
}
