/*
 * Contains functions to read /etc/resolv.conf style configuration files
 *
 * (c) NLnet Labs, 2004
 * 
 * See the file LICENSE for the license
 */

/**
 * Mapping of ip string to (a number of) hostname(s)
 */
struct t_hostlist_host {
	/** IP address. */
	char *ip_addr;
	/** Array of hostnames. */
	struct zone_list *names;
};

/**
 * List of ip - (number of) hostname(s) combinations.
 */ 
struct t_hostlist {
	/** Number of entries (max 1000). */
	int size;
	/** Array of entries. */
	struct t_hostlist_host *hosts[1000];
};

struct t_hostlist_host *hostlist_host_create (const char *);
int hostlist_host_add_name (struct t_hostlist_host *, const char *);
void hostlist_host_destroy (struct t_hostlist_host *);
struct t_hostlist *hostlist_create (void);
int hostlist_add_host (struct t_hostlist *, struct t_hostlist_host *);
void hostlist_destroy(struct t_hostlist *);
const char *hostlist_get_ipaddr(struct t_hostlist *,const  char *);
void hostlist_print(struct t_hostlist *);

struct t_hostlist *read_hosts_file(const char *filename);
struct t_rr *read_resolv_conf_ns(const char *filename);
struct zone_list *read_resolv_conf_search(const char *filename);
struct t_rr *read_resolv_conf_dnskey(const char *filename);
struct zone_list *read_resolv_conf_must_be_secure(const char *filename);

