/* print.h
 *
 * conversion function for printing the
 * internals to screen
 *
 * (c) NLnet Labs, 2004
 *  
 * See the file LICENSE for the license
 *
 */

/* print an rr to screen
 * follow = 1; follow the linked list
 */
void print_rr(struct t_rr *, int);
void print_rr_short(struct t_rr *, int);
void print_rr_sec(struct t_rr *, t_section);

/*
 * prints packet to screen
 */
void print_packet(struct t_dpacket *);
void print_packet_header(struct t_dpacket *);
void print_packet_body(struct t_dpacket *);
void print_packet_footer(struct t_dpacket *);
/* do not print all information. Only show auth section */
void print_packet_dense(struct t_dpacket *);

/* print the rdata */
void print_rdata(struct t_rdata *);

/* print a ns (which is a t_rr) */
void print_ns(struct t_rr *,int);

void print_rd(struct t_rdata *);
void print_flags(struct t_dpacket *);
void print_spaces(uint16_t);
void print_piece(uint8_t *, uint16_t, uint16_t);

void prettyprint_rr_sec(struct t_rr*, t_section, int, unsigned int);
void prettyprint_packet(struct t_dpacket *);
void prettyprint_packet_body(struct t_dpacket *);
void prettyprint_rr(struct t_rr *, int, int, unsigned int);
 
/* return the longest dname */
unsigned int get_longest_dname(struct t_rr *, int);
