/* axfr.c
 *
 * code to do an axfr
 *
 * (c) NLnet Labs, 2004
 *
 * See the file LICENSE for the license
 *
 */

#include "common.h"

int
axfr(struct t_dpacket *p, struct t_rr *nameserver)
{
	struct timeval tv_s, tv_e;
	struct t_dpacket *reply_packet;
	int psocket = 0;
	struct t_rr *lastrr;
	gettimeofday(&tv_s, NULL);
	reply_packet = send_axfr_packet(p, nameserver, 1, &psocket);

	if (!reply_packet){
		warning("No response");
		return RET_FAIL;
	}

	if (reply_packet->flags.rcode+1 != RCODE_NOERROR) {

		print_packet_header(reply_packet);
		prettyprint_packet_body(reply_packet);

		psocket = 0;
	} else {
		print_packet_header(reply_packet);

		lastrr = reply_packet->rrs;
		if (lastrr) {
			if(lastrr->section != SEC_QUESTION) {
				prettyprint_rr(lastrr, NO_FOLLOW, 0, 0);
			}
			while (lastrr->next) {
				lastrr = lastrr->next;
				if(lastrr->section != SEC_QUESTION) {
					prettyprint_rr(lastrr, NO_FOLLOW, 0, 0);
				}
			}
			if (lastrr->type == TYPE_SOA && rr_size(reply_packet->rrs) > 2) {
				psocket = 0;
			}
		}
	}

	while (psocket != 0) {
		dpacket_destroy(reply_packet);
		reply_packet = send_axfr_packet(p, nameserver, 0, &psocket);
		if (reply_packet) {
			lastrr = reply_packet->rrs;
			if (lastrr) {
				prettyprint_rr(lastrr, NO_FOLLOW, 0, 0);
				while(lastrr->next != NULL) {
					lastrr = lastrr->next;
					prettyprint_rr(lastrr, NO_FOLLOW, 0, 0);
				}
				if (lastrr->type == TYPE_SOA) {
					//prettyprint_rr(lastrr, NO_FOLLOW, 0, 0);
					psocket = 0;
				}
			}
		} else {
			warning("no packet");
			return RET_FAIL;
		}
	}

	/* shutdown the socket */
	shutdown(psocket, SHUT_RDWR);
	close(psocket);
	/* set end time */
	gettimeofday(&tv_e, NULL);

	reply_packet->querytime = (tv_e.tv_sec - tv_s.tv_sec)*1000;
	reply_packet->querytime += (tv_e.tv_usec - tv_s.tv_usec)/1000;
	print_packet_footer(reply_packet);
	if (reply_packet) {
		dpacket_destroy(reply_packet);
	}
	return RET_SUC;
}
