/* serverside.h   Server-side parts of Dopewars                         */
/* Copyright (C)  1998-2000  Ben Webb                                   */
/*                Email: ben@bellatrix.pcl.ox.ac.uk                     */
/*                WWW: http://bellatrix.pcl.ox.ac.uk/~ben/dopewars/     */

/* This program is free software; you can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License          */
/* as published by the Free Software Foundation; either version 2       */
/* of the License, or (at your option) any later version.               */

/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */

/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston,               */
/*                   MA  02111-1307, USA.                               */


#ifndef __SERVERSIDE_H__
#define __SERVERSIDE_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "dopewars.h"

#define NOFORCE    0
#define FORCECOPS  1
#define FORCEBITCH 2

#define AT_FIRST   1
#define AT_SHOOT   2

extern struct PLAYER *FirstServer;

void CleanUpServer();
void BreakHandle();
void ClientLeftServer(struct PLAYER *Play);
int CheckServerSockets(fd_set *readfs,char WantQuit);
void ServerLoop();
void HandleServerMessage(char *buf,struct PLAYER *ReallyFrom);
void FinishGame(struct PLAYER *Play,char *Message);
void SendHighScores(struct PLAYER *Play,char AddCurrent,char *Message);
void SendEvent(struct PLAYER *To);
int SendCopOffer(struct PLAYER *To,char Force);
int OfferObject(struct PLAYER *To,char ForceBitch);
void SendDrugsHere(struct PLAYER *To,char DisplayBusts);
void GenerateDrugsHere(struct PLAYER *To,char *Deal);
void BuyObject(struct PLAYER *From,char *data);
int RandomOffer(struct PLAYER *To);
void HandleAnswer(struct PLAYER *From,struct PLAYER *To,char *answer);
void ClearPrices(struct PLAYER *Play);
void StartOfficerHardass(struct PLAYER *Play,int ResyncNum,
                         char *LoneMessage,char *DeputyMessage);
void OfficerHardass(struct PLAYER *Play,char *LoneMessage,char *DeputyMessage);
void FireAtHardass(struct PLAYER *Play,char FireType);
void FinishFightWithHardass(struct PLAYER *Play,char *Message);
int LoseBitch(struct PLAYER *Play,Inventory *Guns,Inventory *Drugs);
void GainBitch(struct PLAYER *Play);
void AttackPlayer(struct PLAYER *Attack,struct PLAYER *Defend,char AttackType);
void BreakoffCombat(struct PLAYER *Attack,char LeftGame);
void SetFightTimeout(struct PLAYER *Play);
void ClearFightTimeout(struct PLAYER *Play);
int GetMinimumTimeout(struct PLAYER *First);
void HandleTimeouts(struct PLAYER *First);

#endif
