/* dopewars.h  Common structures and stuff for Dopewars                 */
/* Copyright (C)  1998-2000  Ben Webb                                   */
/*                Email: ben@bellatrix.pcl.ox.ac.uk                     */
/*                WWW: http://bellatrix.pcl.ox.ac.uk/~ben/dopewars/     */

/* This program is free software; you can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License          */
/* as published by the Free Software Foundation; either version 2       */
/* of the License, or (at your option) any later version.               */

/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */

/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston,               */
/*                   MA  02111-1307, USA.                               */


#ifndef __DOPEWARS_H__
#define __DOPEWARS_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

/* Be careful not to include both sys/time.h and time.h on those systems */
/* which don't like it */
#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include "dopeos.h"

/* Make price_t be a long long if the type is supported by the compiler */
#if SIZEOF_LONG_LONG == 0
typedef long price_t;
#else
typedef long long price_t;
#endif

#define NMLEN 20

struct COPS {
   int EscapeProb,DeputyEscape,HitProb,DeputyHit,Damage,Toughness;
   int DropProb;
};

struct NAMES {
   char Bitch[NMLEN],Bitches[NMLEN],Gun[NMLEN],Guns[NMLEN];
   char Drug[NMLEN],Drugs[NMLEN],Month[NMLEN],Year[NMLEN];
   char Officer[NMLEN],ReserveOfficer[NMLEN];
};

struct METASERVER {
   int Active;
   int Port;
   char Name[160];
   char Path[160];
   char LocalName[160];
   char Password[80];
   char Comment[160];
};

struct PRICES {
   price_t Spy,Tipoff;
};

struct BITCH {
   price_t MinPrice,MaxPrice;
};

extern int ClientSock,ListenSock;
extern char Network,Client,Server,NotifyMetaServer,AIPlayer;
extern int Port,Sanitized;
extern int NumLocation,NumGun,NumDrug;
extern char HiScoreFile[80],ServerName[80];
extern char Pager[80];
extern char WantHelp,WantVersion,WantAntique,WantColour,WantNetwork;
extern int LoanSharkLoc,BankLoc,GunShopLoc,RoughPubLoc;
extern int DrugSortMethod,FightTimeout,MaxClients,AITurnPause;
extern struct PRICES Prices;
extern struct BITCH Bitch;
extern price_t StartCash,StartDebt;
extern struct COPS Cops;
extern struct NAMES Names;
extern struct METASERVER MetaServer;
extern int NumTurns;

#define DM_NONE       0
#define DM_STREET     1
#define DM_FIGHT      2
#define DM_DEAL       3

#define DS_ATOZ       1
#define DS_ZTOA       2
#define DS_CHEAPFIRST 3
#define DS_CHEAPLAST  4
#define DS_MAX        5

#define NAMELEN      37
#define BUFLEN       600
#define NUMSUBWAY    31
#define NUMHISCORE   18
#define NUMSTOPPEDTO 5
#define NUMPLAYING   18
#define NUMDISCOVER  3

#define NUMDRUG      12
#define NUMGUN       4
#define NUMLOCATION  8

#define ESCAPE  0
#define DEFECT  1
#define SHOT    2

#define MINTRENCHPRICE 200
#define MAXTRENCHPRICE 300

#define ACID    0
#define COCAINE 1
#define HASHISH 2
#define HEROIN  3
#define LUDES   4
#define MDA     5
#define OPIUM   6
#define PCP     7
#define PEYOTE  8
#define SHROOMS 9
#define SPEED   10 
#define WEED    11

#define DEFLOANSHARK 1
#define DEFBANK      1
#define DEFGUNSHOP   2
#define DEFROUGHPUB  2

#define METAVERSION 1

#define FIRSTTURN   1
#define DEADHARDASS 2
#define TIPPEDOFF   4
#define SPIEDON     8
#define SPYINGON    16
#define FIGHTING    32
#define CANSHOOT    64
#define TRADING     128

#define LISTONLY    0
#define PAGETO      1
#define SELECTTIP   2
#define SELECTSPY   3

#define F_STAND     0
#define F_FIGHT     1
#define F_RUN       2

#define E_NONE       0
#define E_SUBWAY     1
#define E_OFFOBJECT  2
#define E_WEED       3
#define E_SAYING     4
#define E_LOANSHARK  5
#define E_BANK       6
#define E_GUNSHOP    7
#define E_ROUGHPUB   8
#define E_HIREBITCH  9
#define E_ARRIVE     10
#define E_MAX        11

#define E_FINISH     100

#define E_OUTOFSYNC  120
#define E_ATTACK     121
#define E_WAITATTACK 122
#define E_FREEFORALL 123
#define E_DEFEND     124
#define E_COPS       125
#define E_DOCTOR     126
#define E_MAXOOS     127

struct GUN {
   char Name[80];
   price_t Price;
   int Space;
   int Damage;
};
extern struct GUN DefaultGun[NUMGUN],*Gun;

struct HISCORE {
   char Time[80];
   price_t Money;
   char Dead;
   char Name[80];
};

struct LOCATION {
   char Name[NMLEN];
   int PolicePresence;
   int MinDrug,MaxDrug;
};
extern struct LOCATION DefaultLocation[NUMLOCATION],*Location;

#define STRLEN 80
struct DRUG {
   char Name[NMLEN];
   price_t MinPrice,MaxPrice;
   int Cheap,Expensive;
   char CheapStr[STRLEN];
};
extern struct DRUG DefaultDrug[NUMDRUG],*Drug;

struct DRUGS {
   char ExpensiveStr1[STRLEN],ExpensiveStr2[STRLEN];
   int CheapDivide,ExpensiveMultiply;
};
extern struct DRUGS Drugs;

struct INVENTORY {
   price_t Price;
   int Carried;
};
typedef struct INVENTORY Inventory;

struct PLAYER;
struct TDopeEntry {
   struct PLAYER *Play;
   int Turns;
};
typedef struct TDopeEntry DopeEntry;

struct TDopeList {
   DopeEntry *Data;
   int Number;
};
typedef struct TDopeList DopeList;

struct PLAYER {
   int Turn;
   price_t Cash,Debt,Bank;
   int Health;
   int CoatSize;
   char IsAt;
   Inventory *Guns,*Drugs,Bitches;
   struct PLAYER *Attacked;
   char Flags;
   char Name[NAMELEN+1];
   int fd;
   int EventNum,ResyncNum;
   int Cops;
   time_t Timeout;
   price_t DocPrice;
   DopeList SpyList;
   DopeList TipList;
   struct PLAYER *OnBehalfOf;
   struct PLAYER *Next;
};

#define NUMGLOB 66
#define GNLEN   30
#define GHLEN   60
struct GLOBALS {
   int *IntVal;
   price_t *PriceVal;
   char *StringVal;
   int LenMax;
   char Name[GNLEN];
   char Help[GHLEN];

   void **StructListPt,*StructStaticPt;
   int LenStruct;
   char NameStruct[GNLEN];
   int *MaxIndex;
};

extern struct GLOBALS Globals[NUMGLOB];
extern struct PLAYER *Player,Noone;
extern char *Discover[NUMDISCOVER];
extern char *Playing[NUMPLAYING];
extern char *SubwaySaying[NUMSUBWAY];
extern char *StoppedTo[NUMSTOPPEDTO];

void RemovePlayer(struct PLAYER *Play,struct PLAYER **First);
struct PLAYER *GetPlayerByName(char *Name,struct PLAYER *First);
struct PLAYER *AddPlayer(int fd,struct PLAYER **First);
int CountPlayers(struct PLAYER *First);
void UpdatePlayer(struct PLAYER *Play);
void CopyPlayer(struct PLAYER *Dest,struct PLAYER *Src);
char IsValidPlayer(struct PLAYER *Play,struct PLAYER *First);
void clear_bottom();
void clear_exceptfor(int skip);
void nice_wait();
void InitialisePlayer(struct PLAYER *Play);
void ClearInventory(Inventory *Guns,Inventory *Drugs);
int IsCarryingRandom(struct PLAYER *Play,int amount);
void ChangeSpaceForInventory(Inventory *Guns,Inventory *Drugs,
                             struct PLAYER *Play);
void InitList(DopeList *List);
void AddListEntry(DopeList *List,DopeEntry *NewEntry);
void RemoveListEntry(DopeList *List,int Entry);
int GetListEntry(DopeList *List,struct PLAYER *Play);
void RemoveListPlayer(DopeList *List,struct PLAYER *Play);
void RemoveAllEntries(DopeList *List,struct PLAYER *Play);
void ClearList(DopeList *List);
struct PLAYER *ListPlayers(struct PLAYER *Play,char Select,char *Prompt);
void clear_line(int line);
int TotalGunsCarried(struct PLAYER *Player);
int read_string(FILE *fp,char *buf,int maxlen);
int brandom(int bot,int top);
void display_message(char *buf);
void print_location(char *text);
int GetKey(char *allowed);
void AddInventory(Inventory *Cumul,Inventory *Add,int Length);
void TruncateInventoryFor(Inventory *Guns,Inventory *Drugs,
                          struct PLAYER *Play);
void PrintInventory(Inventory *Guns,Inventory *Drugs);
void DisplaySpyReports(char *Data,struct PLAYER *From);
void change_name(char nullname);
void clear_screen();
char *FormatPrice(price_t price,char *buffer);
void nice_input(char *prompt,char *str,int maxlen,int sy,int sx,
                char digitsonly,char displaystr);
char IsInventoryClear(Inventory *Guns,Inventory *Drugs);
void print_status(struct PLAYER *Play,char DispDrug);
price_t strtoprice(char *buf);
char *pricetostr(price_t price,char *buf,int maxlen);
int ReadNameValue(FILE *fp,char *name,int namelen,
                  char *value,int valuelen,char *sname,
                  int snamelen,int *Index,char *HasEquals);
int ParseNameValue(char *line,char *name,int namelen,
                  char *value,int valuelen,char *sname,
                  int snamelen,int *Index,char *HasEquals);
void ReportError(char *text);
char HandleOption(char *name,char *sname,int Index,char *value,
                  char *ErrorSuffix,char Display,char InGame,char HasEquals);
void *ResizeStruct(void *Ptr,int *OldNum,int NewNum,int SizeOne);
int GetNextDrugIndex(int OldIndex,struct PLAYER *Play);
void DisplayFightMessage(char *text);
char *InitialCaps(char *string,char *buf);
char StartsWithVowel(char *string);

#endif
