/* dopewars.c    dopewars - general purpose routines and initialisation */ 
/* Copyright (C)  1998-2000  Ben Webb                                   */
/*                Email: ben@bellatrix.pcl.ox.ac.uk                     */
/*                WWW: http://bellatrix.pcl.ox.ac.uk/~ben/dopewars/     */

/* This program is free software; you can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License          */
/* as published by the Free Software Foundation; either version 2       */
/* of the License, or (at your option) any later version.               */

/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */

/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston,               */
/*                   MA  02111-1307, USA.                               */

#include "dopewars.h"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <string.h>
#include <errno.h>
#include <signal.h>
#include "dopeos.h"
#include "message.h"
#include "serverside.h"
#include "clientside.h"
#include "AIPlayer.h"

SCREEN *cur_screen;

#define CM_SERVER 0
#define CM_PROMPT 1
#define CM_META   2
#define CM_SINGLE 3
char ConnectMethod=CM_SERVER;
struct SERVERLIST {
   char *Name;
   int Port;
   char *Comment;
   char *Version;
   struct SERVERLIST *Next;
};

int ClientSock,ListenSock;     
char Network,Client,Server,NotifyMetaServer,AIPlayer;
/* dopewars acting as standalone TCP server:
             Network=Server=TRUE   Client=FALSE
   dopewars acting as client, connecting to standalone server:
             Network=Client=TRUE   Server=FALSE
   dopewars in single-player or antique mode:
             Network=Server=Client=FALSE
*/
int Port=7902,Sanitized=0,ConfigVerbose=0;
char HiScoreFile[80],ServerName[80];
char Pager[80];
char WantHelp,WantVersion,WantAntique,WantColour,WantNetwork;
int NumLocation,NumGun,NumDrug;
struct PLAYER *Player,Noone;
int LoanSharkLoc=DEFLOANSHARK,BankLoc=DEFBANK,GunShopLoc=DEFGUNSHOP,
    RoughPubLoc=DEFROUGHPUB;
int DrugSortMethod=DS_ATOZ,FightTimeout=5,MaxClients=20,AITurnPause=5;
price_t StartCash=2000,StartDebt=5500;

struct LOCATION StaticLocation,*Location;
struct DRUG StaticDrug,*Drug;
struct GUN StaticGun,*Gun;
struct COPS Cops = { 70,2,65,2,5,2,30 };
struct NAMES Names = { 
   "bitch","bitches","gun","guns","drug","drugs","12-","-1984",
   "Hardass","Bob"
};
struct PRICES Prices = {
   20000,10000
};
struct BITCH Bitch = {
   50000,150000
};
struct METASERVER MetaServer = {
   1,80,"bellatrix.pcl.ox.ac.uk","/~ben/cgi-bin/server.pl","","",
   "dopewars server"
};
int NumTurns=31;

struct GLOBALS Globals[NUMGLOB] = {
   { &Port,NULL,NULL,-1,"Port","Network port to connect to",
     NULL,NULL,0,"",NULL },
   { NULL,NULL,HiScoreFile,80,"HiScoreFile","Name of the high score file",
     NULL,NULL,0,"",NULL },
   { NULL,NULL,ServerName,80,"Server","Name of the server to connect to",
     NULL,NULL,0,"",NULL },
   { &MetaServer.Active,NULL,NULL,-1,"MetaServer.Active",
     "Non-zero if server should report to a metaserver",
     NULL,NULL,0,"",NULL },
   { &MetaServer.Port,NULL,NULL,-1,"MetaServer.Port",
     "Port on which the metaserver listens",
     NULL,NULL,0,"",NULL },
   { NULL,NULL,MetaServer.Name,160,"MetaServer.Name",
     "Metaserver name to report server details to",NULL,NULL,0,"",NULL },
   { NULL,NULL,MetaServer.Path,160,"MetaServer.Path",
     "Path of the CGI script on the metaserver",NULL,NULL,0,"",NULL },
   { NULL,NULL,MetaServer.LocalName,160,"MetaServer.LocalName",
     "Preferred hostname of your server machine",NULL,NULL,0,"",NULL },
   { NULL,NULL,MetaServer.Password,80,"MetaServer.Password",
     "Authentication for LocalName with the metaserver",NULL,NULL,0,"",NULL },
   { NULL,NULL,MetaServer.Comment,160,"MetaServer.Comment",
     "Server description, reported to the metaserver",NULL,NULL,0,"",NULL },
   { NULL,NULL,Pager,80,"Pager","Program used to display multi-page output",
     NULL,NULL,0,"",NULL },
   { &NumTurns,NULL,NULL,-1,"NumTurns",
     "No. of game turns (if 0, game never ends)",
     NULL,NULL,0,"",NULL },
   { &Sanitized,NULL,NULL,-1,"Sanitized","Random events are sanitized",
     NULL,NULL,0,"",NULL },
   { &ConfigVerbose,NULL,NULL,-1,"ConfigVerbose",
     "Be verbose in processing config file",NULL,NULL,0,"",NULL },
   { &NumLocation,NULL,NULL,-1,"NumLocation","Number of locations in the game",
     (void **)(&Location),NULL,sizeof(struct LOCATION),"",NULL },
   { &NumGun,NULL,NULL,-1,"NumGun","Number of guns in the game",
     (void **)(&Gun),NULL,sizeof(struct GUN),"",NULL },
   { &NumDrug,NULL,NULL,-1,"NumDrug","Number of drugs in the game",
     (void **)(&Drug),NULL,sizeof(struct DRUG),"",NULL },
   { &LoanSharkLoc,NULL,NULL,-1,"LoanShark","Location of the Loan Shark",
     NULL,NULL,0,"",NULL },
   { &BankLoc,NULL,NULL,-1,"Bank","Location of the bank",
     NULL,NULL,0,"",NULL },
   { &GunShopLoc,NULL,NULL,-1,"GunShop","Location of the gun shop",
     NULL,NULL,0,"",NULL },
   { &RoughPubLoc,NULL,NULL,-1,"RoughPub","Location of the pub",
     NULL,NULL,0,"",NULL },
   { &DrugSortMethod,NULL,NULL,DS_MAX,"DrugSortMethod",
     "Sort key for listing available drugs",
     NULL,NULL,0,"",NULL },
   { &FightTimeout,NULL,NULL,-1,"FightTimeout",
     "No. of seconds in which to return fire",
     NULL,NULL,0,"",NULL },
   { &MaxClients,NULL,NULL,-1,"MaxClients",
     "Maximum number of TCP/IP connections",
     NULL,NULL,0,"",NULL },
   { &AITurnPause,NULL,NULL,-1,"AITurnPause",
     "Seconds between turns of AI players",
     NULL,NULL,0,"",NULL },
   { NULL,&StartCash,NULL,-1,"StartCash",
     "Amount of cash that each player starts with",
     NULL,NULL,0,"",NULL },
   { NULL,&StartDebt,NULL,-1,"StartDebt",
     "Amount of debt that each player starts with",
     NULL,NULL,0,"",NULL },
   { NULL,NULL,&(StaticLocation.Name[0]),30,"Name","Name of each location",
     (void **)(&Location),&StaticLocation,
     sizeof(struct LOCATION),"Location",&NumLocation },
   { &(StaticLocation.PolicePresence),NULL,NULL,100,"PolicePresence",
     "Police presence at each location (%)",
     (void **)(&Location),&StaticLocation,
     sizeof(struct LOCATION),"Location",&NumLocation },
   { &(StaticLocation.MinDrug),NULL,NULL,-1,"MinDrug",
     "Minimum number of drugs at each location",
     (void **)(&Location),&StaticLocation,
     sizeof(struct LOCATION),"Location",&NumLocation },
   { &(StaticLocation.MaxDrug),NULL,NULL,-1,"MaxDrug",
     "Maximum number of drugs at each location",
     (void **)(&Location),&StaticLocation,
     sizeof(struct LOCATION),"Location",&NumLocation },
   { NULL,NULL,&(StaticDrug.Name[0]),30,"Name",
     "Name of each drug",
     (void **)(&Drug),&StaticDrug,
     sizeof(struct DRUG),"Drug",&NumDrug },
   { NULL,&(StaticDrug.MinPrice),NULL,-1,"MinPrice",
     "Minimum normal price of each drug",
     (void **)(&Drug),&StaticDrug,
     sizeof(struct DRUG),"Drug",&NumDrug },
   { NULL,&(StaticDrug.MaxPrice),NULL,-1,"MaxPrice",
     "Maximum normal price of each drug",
     (void **)(&Drug),&StaticDrug,
     sizeof(struct DRUG),"Drug",&NumDrug },
   { &(StaticDrug.Cheap),NULL,NULL,-1,"Cheap",
     "Non-zero if this drug can be specially cheap",
     (void **)(&Drug),&StaticDrug,
     sizeof(struct DRUG),"Drug",&NumDrug },
   { &(StaticDrug.Expensive),NULL,NULL,-1,"Expensive",
     "Non-zero if this drug can be specially expensive",
     (void **)(&Drug),&StaticDrug,
     sizeof(struct DRUG),"Drug",&NumDrug },
   { NULL,NULL,&(StaticDrug.CheapStr[0]),STRLEN,"CheapStr",
     "Message displayed when this drug is specially cheap",
     (void **)(&Drug),&StaticDrug,
     sizeof(struct DRUG),"Drug",&NumDrug },
   { NULL,NULL,&(Drugs.ExpensiveStr1[0]),STRLEN,"Drugs.ExpensiveStr1",
     "Format string used for expensive drugs 50% of time",
     NULL,NULL,0,"",NULL },
   { NULL,NULL,&(Drugs.ExpensiveStr2[0]),STRLEN,"Drugs.ExpensiveStr2",
     "Format string used for expensive drugs 50% of time",
     NULL,NULL,0,"",NULL },
   { &(Drugs.CheapDivide),NULL,NULL,-1,"Drugs.CheapDivide",
     "Divider for drug price when it's specially cheap",
     NULL,NULL,0,"",NULL },
   { &(Drugs.ExpensiveMultiply),NULL,NULL,-1,"Drugs.ExpensiveMultiply",
     "Multiplier for specially expensive drug prices",
     NULL,NULL,0,"",NULL },
   { NULL,NULL,&(StaticGun.Name[0]),80,"Name",
     "Name of each gun",
     (void **)(&Gun),&StaticGun,
     sizeof(struct GUN),"Gun",&NumGun },
   { NULL,&(StaticGun.Price),NULL,-1,"Price",
     "Price of each gun",
     (void **)(&Gun),&StaticGun,
     sizeof(struct GUN),"Gun",&NumGun },
   { &(StaticGun.Space),NULL,NULL,-1,"Space",
     "Space taken by each gun",
     (void **)(&Gun),&StaticGun,
     sizeof(struct GUN),"Gun",&NumGun },
   { &(StaticGun.Damage),NULL,NULL,-1,"Damage",
     "Damage done by each gun",
     (void **)(&Gun),&StaticGun,
     sizeof(struct GUN),"Gun",&NumGun },
   { &(Cops.EscapeProb),NULL,NULL,100,"Cops.EscapeProb",
     "% probability of escaping from Officer Hardass",
     NULL,NULL,0,"",NULL },
   { &(Cops.DeputyEscape),NULL,NULL,100,"Cops.DeputyEscape",
     "Modifier to EscapeProb for each extra deputy",
     NULL,NULL,0,"",NULL },
   { &(Cops.HitProb),NULL,NULL,100,"Cops.HitProb",
     "% probability that Officer Hardass hits you",
     NULL,NULL,0,"",NULL },
   { &(Cops.DeputyHit),NULL,NULL,100,"Cops.DeputyHit",
     "Modifier to HitProb for each extra deputy",
     NULL,NULL,0,"",NULL },
   { &(Cops.Damage),NULL,NULL,100,"Cops.Damage",
     "Maximum damage done to you by each cop",
     NULL,NULL,0,"",NULL },
   { &(Cops.Toughness),NULL,NULL,100,"Cops.Toughness",
     "Toughness of (difficulty of hitting) each cop",
     NULL,NULL,0,"",NULL },
   { &(Cops.DropProb),NULL,NULL,100,"Cops.DropProb",
     "% probability that the cops catch you dropping drugs",
     NULL,NULL,0,"",NULL },
   { NULL,NULL,&(Names.Bitch[0]),NMLEN,"Names.Bitch",
     "Word used to denote a single \"bitch\"",NULL,NULL,0,"",NULL },
   { NULL,NULL,&(Names.Bitches[0]),NMLEN,"Names.Bitches",
     "Word used to denote two or more \"bitches\"",NULL,NULL,0,"",NULL },
   { NULL,NULL,&(Names.Gun[0]),NMLEN,"Names.Gun",
     "Word used to denote a single gun or equivalent",NULL,NULL,0,"",NULL },
   { NULL,NULL,&(Names.Guns[0]),NMLEN,"Names.Guns",
     "Word used to denote two or more guns",NULL,NULL,0,"",NULL },
   { NULL,NULL,&(Names.Drug[0]),NMLEN,"Names.Drug",
     "Word used to denote a single drug or equivalent",NULL,NULL,0,"",NULL },
   { NULL,NULL,&(Names.Drugs[0]),NMLEN,"Names.Drugs",
     "Word used to denote two or more drugs",NULL,NULL,0,"",NULL },
   { NULL,NULL,&(Names.Month[0]),NMLEN,"Names.Month",
     "Text prefixed to the turn number (i.e. the month)",NULL,NULL,0,"",NULL },
   { NULL,NULL,&(Names.Year[0]),NMLEN,"Names.Year",
     "Text appended to the turn number (i.e. the year)",NULL,NULL,0,"",NULL },
   { NULL,NULL, &(Names.Officer[0]),NMLEN,"Names.Officer",
     "Name of the police officer",NULL,NULL,0,"",NULL },
   { NULL,NULL, &(Names.ReserveOfficer[0]),NMLEN,"Names.ReserveOfficer",
     "Name of the reserve police officer",NULL,NULL,0,"",NULL },
   { NULL,&Prices.Spy,NULL,-1,"Prices.Spy",
     "Cost for a bitch to spy on the enemy",
     NULL,NULL,0,"",NULL },
   { NULL,&Prices.Tipoff,NULL,-1,"Prices.Tipoff",
     "Cost for a bitch to tipoff the cops to an enemy",
     NULL,NULL,0,"",NULL },
   { NULL,&Bitch.MinPrice,NULL,-1,"Bitch.MinPrice",
     "Minimum price to hire a bitch",
     NULL,NULL,0,"",NULL },
   { NULL,&Bitch.MaxPrice,NULL,-1,"Bitch.MaxPrice",
     "Maximum price to hire a bitch",
     NULL,NULL,0,"",NULL }
};

char *Discover[NUMDISCOVER] = {
   "escaped", "defected", "was shot" };
char *Playing[NUMPLAYING] = {
   "`Are you Experienced` by Jimi Hendrix",
   "`Cheeba Cheeba` by Tone Loc",
   "`Comin` in to Los Angeles` by Arlo Guthrie",
   "`Commercial` by Spanky and Our Gang",
   "`Late in the Evening` by Paul Simon",
   "`Light Up` by Styx",
   "`Mexico` by Jefferson Airplane",
   "`One toke over the line` by Brewer & Shipley",
   "`The Smokeout` by Shel Silverstein",
   "`White Rabbit` by Jefferson Airplane",
   "`Itchycoo Park` by Small Faces",
   "`White Punks on Dope` by the Tubes",
   "`Legend of a Mind` by the Moody Blues",
   "`Eight Miles High` by the Byrds",
   "`Acapulco Gold` by Riders of the Purple Sage",
   "`Kicks` by Paul Revere & the Raiders",
   "the Nixon tapes",
   "`Legalize It` by Mojo Nixon & Skid Roper"
};


char *StoppedTo[NUMSTOPPEDTO] = {
   "have a beer",
   "smoke a joint",
   "smoke a cigar",
   "smoke a Djarum",
   "smoke a cigarette"
};

struct GUN DefaultGun[NUMGUN] = {
   { "Baretta",3000,4,5 },
   { ".38 Special",3500,4,9 },
   { "Ruger",2900,4,4 },
   { "Saturday Night Special",3100,4,7 }
};

struct HISCORE MultiScore[NUMHISCORE],AntiqueScore[NUMHISCORE];

struct LOCATION DefaultLocation[NUMLOCATION] = {
   { "Bronx",10,NUMDRUG/2+1,NUMDRUG },
   { "Ghetto",5,NUMDRUG/2+2,NUMDRUG },
   { "Central Park",15,NUMDRUG/2,NUMDRUG },
   { "Manhattan",90,NUMDRUG/2-2,NUMDRUG-2 },
   { "Coney Island",20,NUMDRUG/2,NUMDRUG },
   { "Brooklyn",70,NUMDRUG/2-2,NUMDRUG-1 },
   { "Queens",50,NUMDRUG/2,NUMDRUG },
   { "Staten Island",20,NUMDRUG/2,NUMDRUG }
};

struct DRUG DefaultDrug[NUMDRUG] = {
   { "Acid",1000,4400,1,0,"The market is flooded with cheap home-made acid!" },
   { "Cocaine",15000,29000,0,1,"" },
   { "Hashish",480,1280,1,0,"The Marrakesh Express has arrived!" },
   { "Heroin",5500,13000,0,1,"" },
   { "Ludes",11,60,1,0,
     "Rival drug dealers raided a pharmacy and are selling cheap ludes!" },
   { "MDA",1500,4400,0,0,"" },
   { "Opium",540,1250,0,1,"" },
   { "PCP",1000,2500,0,0,"" },
   { "Peyote",220,700,0,0,"" },
   { "Shrooms",630,1300,0,0,"" },
   { "Speed",90,250,0,1,"" },
   { "Weed",315,890,1,0,"Columbian freighter dusted the Coast Guard! \
Weed prices have bottomed out!" }
};

struct DRUGS Drugs = {
   "Cops made a big %s bust! Prices are outrageous!",
   "Addicts are buying %s at ridiculous prices!",
   4,4 };

char *SubwaySaying[NUMSUBWAY] = {
   "Wouldn\'t it be funny if everyone suddenly quacked at once?",
   "The Pope was once Jewish, you know",
   "I\'ll bet you have some really interesting dreams",
   "So I think I\'m going to Amsterdam this year",
   "Son, you need a yellow haircut",
   "I think it\'s wonderful what they\'re doing with incense these days",
   "I wasn\'t always a woman, you know",
   "Does your mother know you\'re a dope dealer?",
   "Are you high on something?",
   "Oh, you must be from California",
   "I used to be a hippie, myself",
   "There\'s nothing like having lots of money",
   "You look like an aardvark!",
   "I don\'t believe in Ronald Reagan",
   "Courage!  Bush is a noodle!",
   "Haven\'t I seen you on TV?",
   "I think hemorrhoid commercials are really neat!",
   "We\'re winning the war for drugs!",
   "A day without dope is like night",
   "We only use 20% of our brains, so why not burn out the other 80%",
   "I\'m soliciting contributions for Zombies for Christ",
   "I\'d like to sell you an edible poodle",
   "Winners don\'t do drugs... unless they do",
   "Kill a cop for Christ!",
   "I am the walrus!",
   "Jesus loves you more than you will know",
   "I feel an unaccountable urge to dye my hair blue",
   "Wasn\'t Jane Fonda wonderful in Barbarella",
   "Just say No... well, maybe... ok, what the hell!",
   "Would you like a jelly baby?",
   "Drugs can be your friend!"
};

int ResizedFlag;

void ResizeHandle(int sig) {
/* Handles a SIGWINCH signal, which is sent to indicate that the   */
/* size of the curses screen has changed.                          */
   ResizedFlag=1;
}

int brandom(int bot,int top) {
/* Returns a random integer not less than bot and less than top */
   return (int)((float)(top-bot)*rand()/(RAND_MAX+1.0))+bot;
}

int GetKey(char *allowed) {
/* Waits for keyboard input; will only accept a key listed in the */
/* "allowed" string. Returns the key pressed. Case insensitive.   */
   int i,c;
   curs_set(1);
   c=0;
   if (!allowed || strlen(allowed)==0) return 0;
   while (1) {
      c=bgetch(); c=toupper(c);
      for (i=0;i<strlen(allowed);i++) if (allowed[i]==c) {
         addch(c | TextAttr);
         curs_set(0); return c;
      }
   }
   curs_set(0);
   return 0;
}

int CountPlayers(struct PLAYER *First) {
/* Returns the total numbers of players in the list starting at "First" */
   struct PLAYER *tmp;
   int count=0;
   for (tmp=First;tmp;tmp=tmp->Next) count++;
   return count;
}

struct PLAYER *AddPlayer(int fd,struct PLAYER **First) {
/* Creates a new PLAYER structure, initialises it, and adds it to the */
/* linked list starting at "First". If this function is called by the */
/* server, then it should pass the file descriptor of the socket used */
/* to communicate with the client player. Returns a pointer to the    */
/* new structure.  */
   struct PLAYER *NewPlayer,*tmp;
   NewPlayer=(struct PLAYER *)malloc(sizeof(struct PLAYER));
   NewPlayer->fd=-1;
   NewPlayer->Next=NULL;
   NewPlayer->Name[0]=0;
   NewPlayer->IsAt=0;
   NewPlayer->Attacked=NULL;
   NewPlayer->EventNum=E_NONE;
   NewPlayer->Guns=(Inventory *)calloc(NumGun,sizeof(Inventory));
   NewPlayer->Drugs=(Inventory *)calloc(NumDrug,sizeof(Inventory));
   if (!NewPlayer->Guns || !NewPlayer->Drugs) {
      fprintf(stderr,"Error: memory allocation in AddPlayer failed\n");
      exit(1);
   }
   InitList(&(NewPlayer->SpyList));
   InitList(&(NewPlayer->TipList));
   if (Server) {
      NewPlayer->fd=fd;
   } 
   if (*First==NULL) {
      *First=NewPlayer;
   } else {
      tmp=*First;
      while (tmp->Next) tmp=tmp->Next;
      tmp->Next=NewPlayer;
   }
   return NewPlayer;
}

void UpdatePlayer(struct PLAYER *Play) {
/* Redimensions the Gun and Drug lists for "Play" */
   Play->Guns=(Inventory *)realloc(Play->Guns,NumGun*sizeof(Inventory));
   Play->Drugs=(Inventory *)realloc(Play->Drugs,NumDrug*sizeof(Inventory));
}

void RemovePlayer(struct PLAYER *Play,struct PLAYER **First) {
/* Removes the PLAYER structure pointed to by "Play" from the linked */
/* list starting at "First". The client socket is freed if called    */
/* from the server.                                                  */
   struct PLAYER *tmp;
   if (*First==Play) {
      *First=Play->Next;
   } else {
      tmp=*First;
      while (tmp && tmp->Next != Play) tmp=tmp->Next;
      if (!tmp) return;
      tmp->Next=Play->Next;
   }  
   if (Server && Play->fd) {
      close(Play->fd);
   }
   ClearList(&(Play->SpyList));
   ClearList(&(Play->TipList));
   free(Play);
}

void CopyPlayer(struct PLAYER *Dest,struct PLAYER *Src) {
/* Copies player "Src" to player "Dest"        */
   if (!Dest || !Src) return;
   Dest->Turn=Src->Turn;
   Dest->Cash=Src->Cash;
   Dest->Debt=Src->Debt;
   Dest->Bank=Src->Bank;
   Dest->Health=Src->Health;
   ClearInventory(Dest->Guns,Dest->Drugs);
   AddInventory(Dest->Guns,Src->Guns,NumGun);
   AddInventory(Dest->Drugs,Src->Drugs,NumDrug);
   Dest->CoatSize=Src->CoatSize;
   Dest->IsAt=Src->IsAt;
   strcpy(Dest->Name,Src->Name);
   Dest->Bitches.Carried=Src->Bitches.Carried;
   Dest->Flags=Src->Flags;
}

void InitialisePlayer(struct PLAYER *Play) {
/* Initialises the fields of the PLAYER structure pointed to by "Play" */
   Play->Turn=1; Play->Cash=StartCash;
   Play->Debt=StartDebt; Play->Bank=0;
   Play->Health=100;
   ClearInventory(Play->Guns,Play->Drugs);
   Play->CoatSize=100; Play->IsAt=0;
   Play->Name[0]=0;
   Play->Bitches.Carried=8;
   Play->Flags=0;
}

struct PLAYER *GetPlayerByName(char *Name,struct PLAYER *First) {
/* Searches the linked list starting at "First" for a PLAYER structure */
/* with the name "Name". Returns a pointer to this structure, or NULL  */
/* if no match can be found.                                           */
   struct PLAYER *tmp;
   if (Name==NULL) return &Noone;
   if (Name[0]==0) return &Noone;
   for (tmp=First;tmp;tmp=tmp->Next) {
      if (strcmp(tmp->Name,Name)==0) return tmp;
   }
   return NULL;
}

char IsValidPlayer(struct PLAYER *Play,struct PLAYER *First) {
/* Returns TRUE if "Play" is within the linked list starting at "First" */
   struct PLAYER *tmp;
   if (!Play || !First) return FALSE;
   for (tmp=First;tmp;tmp=tmp->Next) {
      if (tmp==Play) return TRUE;
   }
   return FALSE;
}

void clear_line(int line) {
/* Clears one whole line on the curses screen */
   int i;
   move(line,0);
   for (i=0;i<Width;i++) addch(' ');
}

void clear_exceptfor(int skip) {
/* Clears the bottom of the screen (i.e. from line 16 to line 23) */
/* except for the top "skip" lines                                */
   int i;
   for (i=16+skip;i<=23;i++) clear_line(i);
}


void clear_bottom() {
/* Clears screen lines 16 to 23 */
   int i;
   for (i=16;i<=23;i++) clear_line(i);
}

void clear_screen() {
/* Clears the entire screen; 24 lines of 80 characters each */
   int i;
   for (i=0;i<Depth;i++) clear_line(i);
}

void nice_wait() {
/* Displays a prompt on the bottom screen line and waits for the user */
/* to press a key                                                     */
   attrset(PromptAttr);
   mvaddstr(23,32,"Press any key...");
   bgetch();
   attrset(TextAttr);
}

void DisplayFightMessage(char *text) {
/* Handles the display of messages pertaining to player-player fights   */
/* in the lower part of screen (fighting sub-screen). Adds the new line */
/* of text in "text" and scrolls up previous messages if necessary      */
/* If "text" is NULL, initialises the area                              */
/* If "text" is a blank string, redisplays the message area             */
/* Messages are displayed from lines 16 to 20; line 22 is used for      */
/* the prompt for the user                                              */
   static char Messages[5][79];
   static int x,y;
   int i;
   if (text==NULL) {
      x=0; y=15;
      for (i=0;i<5;i++) Messages[i][0]='\0';
      return;
   }
   if (text[0]) {
      if (y==20) for (i=0;i<4;i++) {
         strcpy(Messages[i],Messages[i+1]);
      }
      if (y<20) y++;
      strncpy(Messages[y-16],text,78); Messages[y-16][78]='\0';
   } else {
      attrset(TextAttr);
      clear_bottom();
      for (i=16;i<=20;i++) {
         mvaddstr(i,1,Messages[i-16]);
      }
   }
}

void display_message(char *buf) {
/* Displays a network message "buf" in the message area (lines   */
/* 10 to 14) scrolling previous messages up                      */
/* If "buf" is NULL, clears the message area                     */
/* If "buf" is a blank string, redisplays the message area       */
   int x,y;
   int wid;
   static char Messages[5][200];
   wid = Width-4 < 200 ? Width-4 : 200;
   if (!buf) {
      for (y=0;y<5;y++) {
         memset(Messages[y],' ',200);
         if (Network) {
            mvaddch(y+10,0,' ' | TextAttr);
            addch(ACS_VLINE | StatsAttr);
            for (x=0;x<wid;x++) {
               addch(' ' | StatsAttr);
            }
            addch(ACS_VLINE | StatsAttr);
         }
      }
      return;
   }
   if (!Network) return;
   if (buf[0]!=0) {
      memmove(Messages[0],Messages[1],200*4);
      memset(Messages[4],' ',200);
      memcpy(Messages[4],buf,strlen(buf)>wid ? wid : strlen(buf));
   }
   for (y=0;y<5;y++) for (x=0;x<wid;x++) {
      mvaddch(y+10,x+2,Messages[y][x] | StatsAttr);
   }
   refresh();
}

void start_curses() {
/* Initialises the curses library for accessing the screen */
   cur_screen=newterm(NULL,stdout,stdin);
/*   initscr();*/
   if (WantColour) {
      start_color();
      init_pair(1,COLOR_MAGENTA,COLOR_WHITE);
      init_pair(2,COLOR_BLACK,COLOR_WHITE);
      init_pair(3,COLOR_BLACK,COLOR_WHITE);
      init_pair(4,COLOR_BLUE,COLOR_WHITE);
      init_pair(5,COLOR_WHITE,COLOR_BLUE);
      init_pair(6,COLOR_RED,COLOR_WHITE);
   }
   cbreak();
   noecho();
   nodelay(stdscr,FALSE);
   keypad(stdscr,TRUE);
   curs_set(0);
}

void end_curses() {
/* Shuts down the curses screen library */
   keypad(stdscr,FALSE);
   curs_set(1);
   erase();
   refresh();
   endwin();
}

void nice_input(char *prompt,char *str,int maxlen,int sy,int sx,
                char digitsonly,char displaystr) {
/* Displays the given "prompt" (if non-NULL) at coordinates sx,sy and   */
/* allows the user to input a string, which is stored in "str". No more */
/* than "maxlen" characters will be read (not including terminating     */
/* NULL). If "digitsonly" is TRUE, the user will be permitted only to   */
/* input numbers, although the suffixes m and k are allowed (the number */
/* inputted is then automatically multiplied by 1000000 or 1000         */
/* respectively); if "displaystr" is TRUE, the starting value of "str"  */
/* is displayed as the default response.                                */
   int i,c,x;
   int DecimalPoint,Suffix;
   int Zeroes,FracLen;
   DecimalPoint=Suffix=0;
   x=sx;
   move(sy,x);
   if (prompt) {
      attrset(PromptAttr);
      addstr(prompt);
      x+=strlen(prompt);
   }
   attrset(TextAttr);
   if (displaystr) {
      addstr(str);
      i=strlen(str);
   } else i=0;
   curs_set(1);
   while(1) {
      move(sy,x+i);
      c=bgetch();
      if (c==KEY_ENTER || c=='\n') {
         str[i]=0;
         break;
      } else if ((c==8 || c==KEY_BACKSPACE || c==127) && i>0) {
         move(sy,x+i-1);
         addch(' ');
         i--;
         if (DecimalPoint && str[i]=='.') DecimalPoint=0;
         if (Suffix) Suffix=0;
      } else if (i<maxlen && !Suffix) {
         if ((digitsonly && c>='0' && c<='9') || 
                 (!digitsonly && c>=32 && c!='^' && c<127)) {
            str[i++]=c;
            addch(c);
         } else if (digitsonly && c=='.' && !DecimalPoint) {
            str[i++]=c;
            addch(c);
            DecimalPoint=i;
         } else if (digitsonly && (c=='M' || c=='m' || c=='k' || c=='K')
                    && !Suffix) {
            str[i++]=c;
            addch(c);
            Suffix=toupper(c);
         }
      }
   }
   if (digitsonly && Suffix) {
      str[strlen(str)-1]=0;
      Zeroes=(Suffix=='K' ? 3 : 6);
      FracLen=(DecimalPoint==0 ? 0 : strlen(str)-DecimalPoint);
      Zeroes-=FracLen;
      if (DecimalPoint) {
         memmove(&str[DecimalPoint-1],&str[DecimalPoint],FracLen+1);
      }
      if (Zeroes<0) {
         i=strlen(str);
         memmove(&str[i+Zeroes+1],&str[i+Zeroes],1-Zeroes);
         str[i+Zeroes]='.';
      } else for (i=0;i<Zeroes;i++) strcat(str,"0");
   }
   curs_set(0);
   move(sy,x);
}

void display_intro() {
/* Displays a dopewars introduction screen */
   char text[80];
   attrset(TextAttr);
   clear_screen();
   attrset(TitleAttr);
   mvaddstr(1,32,"D O P E W A R S");

   attrset(TextAttr);

   mvaddstr(3,1,"Based on John E. Dell's old Drug Wars game, dopewars \
is a simulation of an");
   mvaddstr(4,1,"imaginary drug market.  dopewars is an All-American \
game which features");
   mvaddstr(5,1,"buying, selling, and trying to get past the cops!");

   mvaddstr(7,1,"The first thing you need to do is pay off your \
debt to the Loan Shark. After");
   mvaddstr(8,1,"that, your goal is to make as much money as \
possible (and stay alive)! You");
   mvaddstr(9,1,"have one month of game time to make your fortune.");

   mvaddstr(11,18,"Copyright (C) 1998-2000  Ben Webb \
ben@bellatrix.pcl.ox.ac.uk");
   sprintf(text,"Version %s",VERSION);
   mvaddstr(11,2,text);
   mvaddstr(12,12,"dopewars is released under the GNU General Public Licence");

   mvaddstr(14,7,"Drug Dealing and Research     Dan Wolf");
   mvaddstr(15,7,"Play Testing                  Phil Davis           \
Owen Walsh");
   mvaddstr(16,7,"Extensive Play Testing        Katherine Holt       \
Caroline Moore");
   mvaddstr(17,7,"Constructive Criticism        Andrea Elliot-Smith  \
Pete Winn");
   mvaddstr(18,7,"Unconstructive Criticism      James Matthews");

   mvaddstr(20,3,"For information on the command line options, type \
dopewars -h at your");
   mvaddstr(21,1,"Unix prompt. This will display a help screen, listing \
the available options.");

   nice_wait();
   attrset(TextAttr); clear_screen(); refresh();
}

int jet(struct PLAYER *Play,char AllowReturn) {
/* Displays the list of locations and prompts the user to select one. */
/* If "AllowReturn" is TRUE, then if the current location is selected */
/* simply drop back to the main game loop, otherwise send a request   */
/* to the server to move to the new location. If FALSE, the user MUST */
/* choose a new location to move to. The active client player is      */
/* passed in "Play"                                                   */
/* Returns: 1 if the user chose to jet to a new location,             */
/*          0 if the action was cancelled instead.                    */
   int i,c;
   char text[80];
   attrset(TextAttr);
   clear_bottom();
   for (i=0;i<NumLocation;i++) {
      sprintf(text,"%d. %s",i+1,Location[i].Name);
      mvaddstr(17+i/3,(i%3)*20+12,text);
   }
   attrset(PromptAttr);
   mvaddstr(22,22,"Where to, dude ? ");
   attrset(TextAttr);
   curs_set(1);
   while (1) {
      c=bgetch();
      if (c>='1' && c<'1'+NumLocation) {
         addstr(Location[c-'1'].Name);
         if (Play->IsAt != c-'1') {
            curs_set(0);
            sprintf(text,"%d",c-'1');
            SendClientMessage(Play,C_NONE,C_REQUESTJET,NULL,text);
            return 1;
         }
      }
      if (AllowReturn) break;
   }
   curs_set(0);
   return 0;
}

void DropDrugs(struct PLAYER *Play) {
/* Prompts the user "Play" to drop some of the currently carried drugs  */
   int i,c,NumDrugs;
   char text[80];
   attrset(TextAttr);
   clear_bottom();
   mvaddstr(16,1,"You can\'t get any cash for the following carried ");
   addstr(Names.Drugs); addstr(":");
   NumDrugs=0;
   for (i=0;i<NumDrug;i++) {
      if (Play->Drugs[i].Carried>0 && Play->Drugs[i].Price==0) {
         sprintf(text,"%c. %-10s %-8d",NumDrugs+'A',Drug[i].Name,
                 Play->Drugs[i].Carried);
         mvaddstr(17+NumDrugs/3,(NumDrugs%3)*25+4,text);
         NumDrugs++;
      }
   }
   attrset(PromptAttr);
   mvaddstr(22,20,"What do you want to drop? ");
   curs_set(1);
   attrset(TextAttr);
   c=bgetch();
   c=toupper(c);
   if (c>='A' && c<'A'+NumDrugs) {
      for (i=0;i<NumDrug;i++) if (Play->Drugs[i].Carried>0 && 
                                  Play->Drugs[i].Price==0) {
         c--;
         if (c<'A') {
            addstr(Drug[i].Name);
            nice_input("How many do you drop? ",text,8,23,
                       8,1,0);
            c=atoi(text);
            if (c>0) {
               sprintf(text,"drug^%d^%d",i,-c);
               SendClientMessage(Play,C_NONE,C_BUYOBJECT,NULL,text);
            }
            break;
         }
      }
   }
}

void DealDrugs(struct PLAYER *Play,char Buy) {
/* Prompts the user (i.e. the owner of client "Play") to buy drugs if   */
/* "Buy" is TRUE, or to sell drugs otherwise. A list of available drugs */
/* is displayed, and on receiving the selection, the user is prompted   */
/* for the number of drugs desired. Finally a message is sent to the    */
/* server to buy or sell the required quantity.                         */
   int i,c,NumDrugsHere;
   char text[100],input[80];
   int DrugNum,CanCarry,CanAfford;

   NumDrugsHere=0;
   for (c=0;c<NumDrug;c++) if (Play->Drugs[c].Price>0) NumDrugsHere++;

   clear_line(22);
   attrset(PromptAttr);
   mvaddstr(22,20,"What do you wish to ");
   addstr(Buy ? "buy? " : "sell? ");
   curs_set(1);
   attrset(TextAttr);
   c=bgetch();
   c=toupper(c);
   if (c>='A' && c<'A'+NumDrugsHere) {
      DrugNum=-1;
      for (i=0;i<NumDrug;i++) {
         DrugNum=GetNextDrugIndex(DrugNum,Play);
         if (--c<'A') break;
      }
      addstr(Drug[DrugNum].Name);
      CanCarry=Play->CoatSize;
      CanAfford=Play->Cash/Play->Drugs[DrugNum].Price;

      if (Buy) {
         sprintf(text,"You can afford %d, and can carry %d. ",
                 CanAfford,CanCarry);
         mvaddstr(23,2,text);
         nice_input("How many do you buy? ",input,5,23,
                    2+strlen(text),1,0);
         c=atoi(input);
         if (c>=0) {
            sprintf(text,"drug^%d^%d",DrugNum,c);
            SendClientMessage(Play,C_NONE,C_BUYOBJECT,NULL,text);
         }
      } else {
         sprintf(text,"You have %d. ",
                 Play->Drugs[DrugNum].Carried);
         mvaddstr(23,2,text);
         nice_input("How many do you sell? ",input,
                    5,23,2+strlen(text),1,0);
         c=atoi(input);
         if (c>=0) {
            sprintf(text,"drug^%d^%d",DrugNum,-c);
            SendClientMessage(Play,C_NONE,C_BUYOBJECT,NULL,text);
         }
      }
   }
   curs_set(0);
}

price_t strtoprice(char *buf) {
/* Forms a price based on the string representation in "buf"  */
   int i;
   char digit,minus=0;
   price_t val=0;
   if (!buf) return 0;
   for (i=0;i<strlen(buf);i++) {
      digit=buf[i];
      if (digit>='0' && digit<='9') {
         val*=10;
         val+=(digit-'0');
      } else if (digit='-' && i==0) minus=1;
   }
   if (minus) return -val; else return val;
}

char *pricetostr(price_t price,char *buf,int maxlen) {
/* Prints "price" directly into the buffer "buf" and returns  */
/* a pointer to it. If the string representation of the price */
/* is longer than "maxlen" characters, it is truncated.       */
   int i;
   char digit,minus=0;
   if (!buf) return NULL;
   memset(buf,0,maxlen);
   if (price<0) {
      price=-price;
      minus=1;
   }
   for (i=maxlen-2;i>=0;i--) {
      digit='0'+(price%10);
      price /= 10;
      buf[i]=digit;
      if (price==0) {
         if (minus && i>0) {
            buf[--i]='-';
         }
         memmove(buf,&buf[i],maxlen-1-i);
         buf[maxlen-1-i]=0;
         return buf;
      }
   }
   return buf;
}

char *FormatPrice(price_t price,char *buffer) {
/* Takes the number in "price" and prints it into the string "buffer" */
/* adding commas to split up thousands, and adding a currency symbol  */
/* to the start. Returns a pointer to the string.                     */
   char text[80];
   price_t absprice;
   text[0]=0;
   if (price<0) absprice=-price; else absprice=price;
   while (text[0]==0 || absprice>0) {
      if (absprice>=1000) sprintf(buffer,"%03d",(int)(absprice%1000l));
      else sprintf(buffer,"%d",(int)(price%1000l));
      price/=1000l;
      absprice/=1000l;
      if (text[0]) strcat(buffer,",");      
      strcat(buffer,text);
      strcpy(text,buffer);
   }
   strcpy(buffer,"$");
   strcat(buffer,text);
   return buffer;
}

void print_location(char *text) {
/* Displays the string "text" at the top of the screen. Usually used for */
/* displaying the current location or the "Subway" flash.                */
   int i;
   attrset(LocationAttr);
   move(0,Width/2-9);
   for (i=0;i<18;i++) addch(' ');
   mvaddstr(0,(Width-strlen(text))/2,text);
   attrset(TextAttr);
}

int TotalGunsCarried(struct PLAYER *Player) {
/* Returns the total number of guns being carried by "Player" */
   int i,c;
   c=0;
   for (i=0;i<NumGun;i++) c+=Player->Guns[i].Carried;
   return c;
}

char *InitialCaps(char *string,char *buf) {
/* Capitalises the first character of "string" and writes the resultant */
/* string to "buf". Returns a pointer to "buf"                          */
   if (!string || !buf) return NULL;
   strcpy(buf,string);
   if (strlen(buf)>=1) buf[0]=toupper(buf[0]);
   return buf;
}

char StartsWithVowel(char *string) {
/* Returns TRUE if "string" starts with a vowel */
   int c;
   if (!string || strlen(string)<1) return FALSE;
   c=toupper(string[0]);
   return (c=='A' || c=='E' || c=='I' || c=='O' || c=='U');
}

void print_status(struct PLAYER *Play,char DispDrug) {
/* Displays the status of player "Play" - i.e. the current turn, the   */
/* location, bitches, available space, cash, guns, health and bank     */
/* details. If "DispDrugs" is TRUE, displays the carried drugs on the  */
/* right hand side of the screen; if FALSE, displays the carried guns. */
   char text[80],num[80],caps[80];
   int i,c;
   attrset(TitleAttr);
   sprintf(text,"%s%02d%s",Names.Month,Play->Turn,Names.Year);
   mvaddstr(0,3,text);

   attrset(StatsAttr);
   for (i=2;i<=14;i++) {
      mvaddch(i,1,ACS_VLINE);
      mvaddch(i,Width-2,ACS_VLINE);
   }
   mvaddch(1,1,ACS_ULCORNER);
   for (i=0;i<Width-4;i++) addch(ACS_HLINE);
   addch(ACS_URCORNER);

   mvaddch(1,Width/2,ACS_TTEE);
   for (i=2;i<=(Network ? 8 : 13);i++) {
      move(i,2);
      for (c=2;c<Width/2;c++) addch(' ');
      addch(ACS_VLINE);
      for (c=Width/2+1;c<Width-2;c++) addch(' ');
   }
   if (!Network) {
      mvaddch(14,1,ACS_LLCORNER);
      for (i=0;i<Width-4;i++) addch(ACS_HLINE);
      addch(ACS_LRCORNER);
      mvaddch(14,Width/2,ACS_BTEE);
   } else {
      mvaddch(9,1,ACS_LTEE);
      for (i=0;i<Width-4;i++) addch(ACS_HLINE);
      addch(ACS_RTEE);
      mvaddstr(9,15,"Messages");
      mvaddch(9,Width/2,ACS_BTEE);
      mvaddch(15,1,ACS_LLCORNER);
      for (i=0;i<Width-4;i++) addch(ACS_HLINE);
      addch(ACS_LRCORNER);
   }

   mvaddstr(1,Width/4-2,"Stats");

   attrset(StatsAttr);
   sprintf(text,"Cash %17s",FormatPrice(Play->Cash,num));
   mvaddstr(3,9,text);
   sprintf(text,"%-19s%3d",InitialCaps(Names.Guns,caps),TotalGunsCarried(Play));
   mvaddstr(Network ? 4 : 5,9,text);
   sprintf(text,"Health             %3d",Play->Health);
   mvaddstr(Network ? 5 : 7,9,text);
   sprintf(text,"Bank %17s",FormatPrice(Play->Bank,num));
   mvaddstr(Network ? 6 : 9,9,text);
   if (Play->Debt>0) attrset(DebtAttr);
   sprintf(text,"Debt %17s",FormatPrice(Play->Debt,num));
   mvaddstr(Network ? 7 : 11,9,text);
   attrset(TitleAttr);
   if (WantAntique) sprintf(text,"Space %6d",Play->CoatSize);
   else {
      sprintf(text,"%s %3d  Space %6d",InitialCaps(Names.Bitches,caps),
              Play->Bitches.Carried,Play->CoatSize);
   }
   mvaddstr(0,Width-2-strlen(text),text);
   print_location(Location[(int)Play->IsAt].Name);
   attrset(StatsAttr);

   c=0;
   if (DispDrug) {
      if (WantAntique) mvaddstr(1,Width*3/4-5,"Trenchcoat");
      else {
         InitialCaps(Names.Drugs,caps);
         mvaddstr(1,Width*3/4-strlen(caps)/2,caps);
      }
      for (i=0;i<NumDrug;i++) {
         if (Play->Drugs[i].Carried>0) {
            sprintf(text,"%-7s  %3d",Drug[i].Name,Play->Drugs[i].Carried);
            mvaddstr(3+c/2,Width/2+3+(c%2)*17,text);
            c++;
         }
      } 
   } else {
      InitialCaps(Names.Guns,caps);
      mvaddstr(1,Width*3/4-strlen(caps)/2,caps);
      for (i=0;i<NumGun;i++) {
         if (Play->Guns[i].Carried>0) {
            sprintf(text,"%-22s %3d",Gun[i].Name,Play->Guns[i].Carried);
            mvaddstr(3+c,Width/2+3,text);
            c++;
         }
      }
   }
   attrset(TextAttr);
   if (!Network) clear_line(15);
}

void DisplaySpyReports(char *Data,struct PLAYER *From) {
/* Parses details about player "From" from string "Data" and then */
/* displays the lot, drugs and guns.                              */ 
   char caps[80];
   ReceivePlayerData(Data,From);

   clear_bottom();
   mvaddstr(17,1,"Spy reports for ");
   addstr(From->Name);

   mvaddstr(19,20,InitialCaps(Names.Drugs,caps)); addstr("...");
   print_status(From,1); nice_wait();
   clear_line(19);
   mvaddstr(19,20,InitialCaps(Names.Guns,caps)); addstr("...");
   print_status(From,0); nice_wait();

   print_status(Player,1); refresh();
}

int read_string(FILE *fp,char *buf,int maxlen) {
/* Reads a NULL-terminated string of maximum length "maxlen" into the */
/* buffer "buf" from file "fp". Returns 0 on success, EOF on failure. */
   int i,c;
   i=0;
   while (i<maxlen) {
      c=fgetc(fp);
      if (c==EOF || c==0) break;
      else buf[i++]=(char)c;
   }
   buf[i]=0;
   if (c==EOF) return EOF; else return 0;
}

void ClearInventory(Inventory *Guns,Inventory *Drugs) {
/* This function simply clears the given inventories "Guns" */
/* and "Drugs" if they are non-NULL                         */
   int i;
   if (Guns) for (i=0;i<NumGun;i++) Guns[i].Carried=0;
   if (Drugs) for (i=0;i<NumDrug;i++) Drugs[i].Carried=0;
}

char IsInventoryClear(Inventory *Guns,Inventory *Drugs) {
/* Returns TRUE only if "Guns" and "Drugs" contain no objects */
   int i;
   if (Guns) for (i=0;i<NumGun;i++) if (Guns[i].Carried > 0) return FALSE;
   if (Drugs) for (i=0;i<NumDrug;i++) if (Drugs[i].Carried > 0) return FALSE;
   return TRUE;
}

void AddInventory(Inventory *Cumul,Inventory *Add,int Length) {
/* Adds inventory "Add" into the contents of inventory "Cumul" */
/* Each inventory is of length "Length"                        */
   int i;
   for (i=0;i<Length;i++) Cumul[i].Carried+=Add[i].Carried;
}

void ChangeSpaceForInventory(Inventory *Guns,Inventory *Drugs,
                             struct PLAYER *Play) {
/* Given the lists of "Guns" and "Drugs" (which the given player "Play" */
/* must have sufficient room to carry) updates the player's space to    */
/* reflect carrying them.                                               */
   int i;
   if (Guns) for (i=0;i<NumGun;i++) {
      Play->CoatSize-=Guns[i].Carried*Gun[i].Space;
   }
   if (Drugs) for (i=0;i<NumDrug;i++) {
      Play->CoatSize-=Drugs[i].Carried;
   }
}

void TruncateInventoryFor(Inventory *Guns,Inventory *Drugs,
                          struct PLAYER *Play) {
/* Discards items from "Guns" and/or "Drugs" (if non-NULL) if necessary */
/* such that player "Play" is able to carry them all. The cheapest      */
/* objects are discarded.                                               */
   int i,Total,CheapIndex;
   int CheapestGun;
   Total=0;
   if (Guns) for (i=0;i<NumGun;i++) Total+=Guns[i].Carried;
   Total+=TotalGunsCarried(Play);
   while (Guns && Total > Play->Bitches.Carried+2) {
      CheapIndex=-1;  
      for (i=0;i<NumGun;i++) if (Guns[i].Carried && (CheapIndex==-1 || 
                                 Gun[i].Price <= Gun[CheapIndex].Price)) {
         CheapIndex=i;
      }
      i=Total-Play->Bitches.Carried-2;
      if (Guns[CheapIndex].Carried > i) {
         Guns[CheapIndex].Carried-=i; Total-=i;
      } else {
         Total-=Guns[CheapIndex].Carried; Guns[CheapIndex].Carried=0;
      }
   }

   Total=Play->CoatSize;
   if (Guns) for (i=0;i<NumGun;i++) Total-=Guns[i].Carried*Gun[i].Space;
   if (Drugs) for (i=0;i<NumDrug;i++) Total-=Drugs[i].Carried;
   while (Total < 0) {
      CheapestGun=-1;
      CheapIndex=-1;
      if (Guns) for (i=0;i<NumGun;i++) if (Guns[i].Carried && (CheapIndex==-1 ||
                                 Gun[i].Price <= Gun[CheapIndex].Price)) {
         CheapIndex=i; CheapestGun=Gun[i].Price/Gun[i].Space;
      }
      if (Drugs) for (i=0;i<NumDrug;i++) if (Drugs[i].Carried &&
         (CheapIndex==-1 ||
          (CheapestGun==-1 && Drug[i].MinPrice<=Drug[CheapIndex].MinPrice) ||
          (CheapestGun>=0 && Drug[i].MinPrice<=CheapestGun))) {
         CheapIndex=i; CheapestGun=-1;
      }
      if (Guns && CheapestGun>=0) { 
         Guns[CheapIndex].Carried--;  
         Total+=Gun[CheapIndex].Space;
      } else {
         if (Drugs && Drugs[CheapIndex].Carried >= -Total) {
            Drugs[CheapIndex].Carried += Total; Total=0;
         } else {
            Total+=Drugs[CheapIndex].Carried; Drugs[CheapIndex].Carried=0;
         }
      }
   }
} 

void PrintInventory(Inventory *Guns,Inventory *Drugs) {
/* Displays the contents of "Guns" and "Drugs" if non-NULL */
/* at the bottom of the screen                             */
   int i,c;
   char text[80];
   c=0;
   attrset(TextAttr);
   if (Guns) for (i=0;i<NumGun;i++) if (Guns[i].Carried) {
      sprintf(text,"%d %s",Guns[i].Carried,Gun[i].Name);
      mvaddstr(18+c/3,2+(c%3)*25,text);
      c++;
   }
   if (Drugs) for (i=0;i<NumDrug;i++) if (Drugs[i].Carried) {
      sprintf(text,"%d %s",Drugs[i].Carried,Drug[i].Name);
      mvaddstr(18+c/3,2+(c%3)*25,text);
      c++;
   }
}

int IsCarryingRandom(struct PLAYER *Play,int amount) {
/* Returns an index into the drugs array of a random drug that "Play" is */
/* carrying at least "amount" of. If no suitable drug is found after 5   */
/* attempts, returns -1.                                                 */ 
   int i,ind;
   for (i=0;i<5;i++) {
      ind=brandom(0,NumDrug);
      if (Play->Drugs[ind].Carried >= amount) {
         return ind;
      }
   }
   return -1;
}

int want_to_quit() {
/* Asks the user if he/she _really_ wants to quit dopewars */
   attrset(TextAttr);
   clear_line(22);
   attrset(PromptAttr);
   mvaddstr(22,1,"Are you sure you want to quit? ");
   attrset(TextAttr);
   return (GetKey("YN")!='N');
}

struct PLAYER *ListPlayers(struct PLAYER *Play,char Select,char *Prompt) {
/* Displays the "Prompt" if non-NULL, and then lists all clients     */
/* currently playing dopewars, other than the current player "Play". */
/* If "Select" is TRUE, gives each player a letter and asks the user */
/* to select one, which is returned by the function.                 */
   struct PLAYER *tmp;
   char text[80];
   int i,c;

   attrset(TextAttr);
   clear_bottom();
   if (!FirstClient || (!FirstClient->Next && 
       strcmp(FirstClient->Name,Play->Name)==0)) {
      mvaddstr(18,15,"No other players are currently logged on!");
      nice_wait();
      return 0;
   }
   mvaddstr(16,1,"Players currently logged on:-");

   i=0;
   for (tmp=FirstClient;tmp;tmp=tmp->Next) {
      if (strcmp(tmp->Name,Play->Name)==0) continue;
      if (Select) sprintf(text,"%c. %s",'A'+i,tmp->Name);
      else strcpy(text,tmp->Name);
      mvaddstr(17+i/2,(i%2)*40+1,text);
      i++;
   }

   if (Prompt) { 
      attrset(PromptAttr); mvaddstr(22,10,Prompt); attrset(TextAttr); 
   }
   if (Select) {
      curs_set(1);
      attrset(TextAttr);
      c=0;
      while (c<'A' || c>='A'+i) { c=bgetch(); c=toupper(c); }
      if (Prompt) addch(c);
      tmp=FirstClient;
      while (c>='A') {
         if (tmp!=FirstClient) tmp=tmp->Next;
         while (strcmp(tmp->Name,Play->Name)==0) tmp=tmp->Next;
         c--;
      }
      return tmp;
   } else {
      nice_wait();
   }
   return NULL;
}

void change_name(char nullname) {
/* Prompts the user to change his or her name, and notifies the server */
   char NewName[80];
   nice_input("New name: ",NewName,30,23,0,0,0);
   if (NewName[0]) {
      SendClientMessage(nullname ? NULL : Player,C_NONE,C_NAME,NULL,NewName);
      strcpy(Player->Name,NewName);
   }
}

void GiveErrand(struct PLAYER *Play) {
/* Prompts the user (player "Play") to give an errand to one of his/her */
/* bitches. The decision is relayed to the server for implementation.   */
   int c,y;
   char num[80];
   struct PLAYER *To;
   attrset(TextAttr);
   clear_bottom();
   y=17;
   mvaddstr(y++,1,"Choose an errand to give one of your ");
   addstr(Names.Bitches); addstr("...");
   attrset(PromptAttr);
   if (Play->Bitches.Carried>0) {
      mvaddstr(y++,5,"S>py on another "); addstr(Names.Drug);
      addstr(" dealer                   (cost: ");
      addstr(FormatPrice(Prices.Spy,num)); addch(')');
      mvaddstr(y++,5,"T>ip off the cops to another "); addstr(Names.Drug);
      addstr(" dealer      (cost: ");
      addstr(FormatPrice(Prices.Tipoff,num)); addch(')');
      mvaddstr(y++,5,"G>et stuffed");
   }
   if (Play->Flags&SPYINGON) {
      mvaddstr(y++,2,"or C>ontact your spies and receive reports");
   }
   mvaddstr(y++,2,"or N>o errand ? ");
   curs_set(1);
   attrset(TextAttr);
   c=bgetch();
   c=toupper(c);
   curs_set(0);
   addch(c);
   if (Play->Bitches.Carried>0 || c=='C') switch (c) {
      case 'G':
         attrset(PromptAttr);
         addstr(" Are you sure? ");
         c=GetKey("YN");
         if (c=='Y') SendClientMessage(Play,C_NONE,C_SACKBITCH,NULL,NULL);
         break;
      case 'T':
         To=ListPlayers(Play,TRUE,"Whom do you want to tip the cops off to? ");
         if (To) SendClientMessage(Play,C_NONE,C_TIPOFF,To,NULL);
         break;
      case 'S':
         To=ListPlayers(Play,TRUE,"Whom do you want to spy on? ");
         if (To) SendClientMessage(Play,C_NONE,C_SPYON,To,NULL);
         break;
      case 'C':
         if (Play->Flags & SPYINGON) {
            SendClientMessage(Play,C_NONE,C_CONTACTSPY,NULL,NULL);
         }
         break;
   }
}

int GetNextDrugIndex(int OldIndex,struct PLAYER *Play) {
/* Returns an index into the "Drugs" array maintained by player "Play"  */
/* of the next available drug after "OldIndex", following the current   */
/* sort method (defined globally as "DrugSortMethod")                   */
   int i,MaxIndex;
   MaxIndex=-1;
   for (i=0;i<NumDrug;i++) {
      if (Play->Drugs[i].Price!=0 && i!=OldIndex && i!=MaxIndex && 
          (MaxIndex==-1 || 
              (DrugSortMethod==DS_ATOZ && 
               strcasecmp(Drug[MaxIndex].Name,Drug[i].Name)>0) || 
              (DrugSortMethod==DS_ZTOA && 
               strcasecmp(Drug[MaxIndex].Name,Drug[i].Name)<0) || 
              (DrugSortMethod==DS_CHEAPFIRST && 
               Play->Drugs[MaxIndex].Price > Play->Drugs[i].Price) ||
              (DrugSortMethod==DS_CHEAPLAST && 
               Play->Drugs[MaxIndex].Price < Play->Drugs[i].Price)) &&
          (OldIndex==-1 || 
              (DrugSortMethod==DS_ATOZ && 
               strcasecmp(Drug[OldIndex].Name,Drug[i].Name)<=0) ||
              (DrugSortMethod==DS_ZTOA && 
               strcasecmp(Drug[OldIndex].Name,Drug[i].Name)>=0) ||
              (DrugSortMethod==DS_CHEAPFIRST && 
               Play->Drugs[OldIndex].Price <= Play->Drugs[i].Price) ||
              (DrugSortMethod==DS_CHEAPLAST && 
               Play->Drugs[OldIndex].Price >= Play->Drugs[i].Price))) {
         MaxIndex=i;
      }
   }
   return MaxIndex;
}

#if NETWORKING
void SelectServerManually() {
/* Prompts the user to enter a server name and port to connect to */
   char text[40];
   if (ServerName[0]=='(') strcpy(ServerName,"localhost");
   attrset(TextAttr);
   clear_bottom();
   mvaddstr(17,1,"Please enter the hostname and port of a dopewars server:-");
   nice_input("Hostname: ",ServerName,60,18,1,0,1);
   sprintf(text,"%d",Port);
   nice_input("Port: ",text,10,19,1,1,1);
   Port=atoi(text);
}

char *SelectServerFromMetaServer() {
/* Contacts the dopewars metaserver, and obtains a list of valid */
/* server/port pairs, one of which the user should select.       */
/* Returns a pointer to a static string containing an error      */
/* message if the connection failed, otherwise NULL.             */
   static char NoHost[] = "Cannot locate metaserver";
   static char NoSocket[] = "Cannot create socket";
   static char NoService[] = "Metaserver not running HTTP or connection denied";
   static char NoServers[] = "No servers listed on metaserver";
   struct sockaddr_in HttpAddr;
   struct hostent *he;
   char ServerList;
   int c;
   struct SERVERLIST *FirstServer=NULL,*ThisServer,*NextServer;
   int HttpSock;
   char buf[BUFLEN];

   ServerName[0]=0;
   attrset(TextAttr);
   clear_bottom();
   mvaddstr(17,1,"Please wait... attempting to contact metaserver...");
   refresh();
   if ((he=gethostbyname(MetaServer.Name))==NULL) return NoHost;
   if ((HttpSock=socket(AF_INET,SOCK_STREAM,0))==-1) return NoSocket;
   HttpAddr.sin_family=AF_INET;
   HttpAddr.sin_port=htons(MetaServer.Port);
   HttpAddr.sin_addr=*((struct in_addr *)he->h_addr);
   memset(HttpAddr.sin_zero,0,sizeof(HttpAddr.sin_zero));
   if (connect(HttpSock,(struct sockaddr *)&HttpAddr,
       sizeof(struct sockaddr))==-1) {
      close(HttpSock);
      return NoService;
   }
   clear_line(17);
   mvaddstr(17,1,
            "Connection to metaserver established. Obtaining server list...");
   refresh();
   sprintf(buf,"GET %s?output=text&getlist=%d HTTP/1.0\n\n",
          MetaServer.Path,METAVERSION);
   SendSocket(HttpSock,buf,strlen(buf));
   ServerList=FALSE;
   while (bgets(buf,BUFLEN,HttpSock)) {
      chomp(buf); chomp(buf);
      if (ServerList) {
         ThisServer=(struct SERVERLIST *)malloc(sizeof(struct SERVERLIST));
         ThisServer->Name=strdup(buf);
         bgets(buf,BUFLEN,HttpSock); chomp(buf); chomp(buf);
         ThisServer->Port=atoi(buf);
         bgets(buf,BUFLEN,HttpSock); chomp(buf); chomp(buf);
         ThisServer->Version=strdup(buf);
         bgets(buf,BUFLEN,HttpSock);
         bgets(buf,BUFLEN,HttpSock);
         bgets(buf,BUFLEN,HttpSock); chomp(buf); chomp(buf);
         ThisServer->Comment=strdup(buf);
         ThisServer->Next=FirstServer ? FirstServer : NULL;
         FirstServer=ThisServer;
      } else if (strncmp(buf,"MetaServer:",11)==0) ServerList=TRUE;
   }
   close(HttpSock);
   ThisServer=FirstServer;
   while (ThisServer) {
      attrset(TextAttr);
      clear_bottom();
      mvaddstr(17,1,"Server : "); addstr(ThisServer->Name);
      sprintf(buf,"Port   : %d",ThisServer->Port);
      mvaddstr(18,1,buf);
      mvaddstr(19,1,"Version: "); addstr(ThisServer->Version);
      mvaddstr(20,1,"Comment: "); addstr(ThisServer->Comment);
      attrset(PromptAttr);
      mvaddstr(23,1,"N>ext server; P>revious server; S>elect this server... ");
      c=GetKey("NPS");
      switch(c) {
         case 'S': strcpy(ServerName,ThisServer->Name);
                   Port=ThisServer->Port;
                   ThisServer=NULL;
                   break;
         case 'N': ThisServer=ThisServer->Next;
                   if (!ThisServer) ThisServer=FirstServer;
                   break;
         case 'P': if (ThisServer==FirstServer) {
                      while (ThisServer->Next) {
                         ThisServer=ThisServer->Next;
                      }
                   } else {
                      NextServer=ThisServer;
                      ThisServer=FirstServer;
                      while (ThisServer->Next!=NextServer) {
                         ThisServer=ThisServer->Next;
                      }
                   }
                   break;
      }
   }
   if (!FirstServer) return NoServers;
   
   ThisServer=FirstServer;
   while (ThisServer) {
      NextServer=ThisServer->Next;
      free(ThisServer->Name);
      free(ThisServer->Version);
      free(ThisServer->Comment);
      free(ThisServer);
      ThisServer=NextServer;
   }
   clear_line(17);
   refresh();
   return NULL;
}

char ConnectToServer(struct PLAYER *Play) {
/* Connects to a dopewars server. Prompts the user to select a server */
/* if necessary. Returns TRUE, unless the user elected to quit the    */
/* program rather than choose a valid server.                         */
   char *pt,*MetaError=NULL;
   int c;
   if (strcasecmp(ServerName,"(MetaServer)")==0 || ConnectMethod==CM_META) {
      ConnectMethod=CM_META;
      MetaError=SelectServerFromMetaServer();
   } else if (strcasecmp(ServerName,"(Prompt)")==0 ||
              ConnectMethod==CM_PROMPT) {
      ConnectMethod=CM_PROMPT;
      SelectServerManually();
   } else if (strcasecmp(ServerName,"(Single)")==0 ||
              ConnectMethod==CM_SINGLE) {
      ConnectMethod=CM_SINGLE;
      return TRUE;
   }
   while (1) {
      attrset(TextAttr);
      clear_bottom();
      if (!MetaError) {
         mvaddstr(17,1,
                  "Please wait... attempting to contact dopewars server...");
         refresh();
         pt=SetupNetwork();
      }
      if (pt || MetaError) {
         clear_line(17);
         if (MetaError) {
            mvaddstr(17,1,"Error: ");
            addstr(MetaError);
         } else {
            mvaddstr(17,1,"Could not start multiplayer dopewars (");
            addstr(pt);
            addstr(") ");
         }
         pt=MetaError=NULL;
         attrset(PromptAttr);
         mvaddstr(18,1,"Will you... C>onnect to a different host and/or port");
         mvaddstr(19,13,"L>ist the servers on the metaserver, and select one");
         mvaddstr(20,13,"Q>uit (where you can start a server by typing ");
         mvaddstr(21,20,"dopewars -s < /dev/null & )");
         mvaddstr(22,10,"or P>lay single-player ? ");
         attrset(TextAttr);
         c=GetKey("CLQP");
         switch(c) {
            case 'Q': return FALSE;
            case 'P': ConnectMethod=CM_SINGLE;
                      return TRUE;
            case 'L': ConnectMethod=CM_META;
                      MetaError=SelectServerFromMetaServer();
                      break;
            case 'C': ConnectMethod=CM_PROMPT;
                      SelectServerManually();
                      break;
         }
      } else break;
   }
   return TRUE;
}
#endif /* NETWORKING */

void CheckForResize(struct PLAYER *Play) {
/* Checks to see if the curses window needs to be resized - i.e. if a */
/* SIGWINCH signal has been received                                  */
   sigset_t sigset;
   sigemptyset(&sigset);
   sigaddset(&sigset,SIGWINCH);
   sigprocmask(SIG_BLOCK,&sigset,NULL);
   if (ResizedFlag) {
      ResizedFlag=0;
      end_curses(); start_curses();
      Width=COLS; Depth=LINES;
      attrset(TextAttr); clear_screen();
      display_message("");
      DisplayFightMessage(NULL);
      print_status(Play,1);
   }
   sigprocmask(SIG_UNBLOCK,&sigset,NULL);
}

void do_game(struct PLAYER *Play) {
/* Loop which handles the user playing an interactive game (i.e. "Play" */
/* is a client connected to a server, either locally or remotely)       */
/* dopewars is essentially server-driven, so this loop simply has to    */
/* make the screen look pretty, respond to user keypresses, and react   */
/* to messages from the server.                                         */
   char text[BUFLEN],*pt,buf[BUFLEN];
   int i,c;
   char IsCarrying;
   char DisplayMode=DM_NONE;
#if NETWORKING || HAVE_SELECT
   fd_set readfs;
#endif
   int NumDrugsHere;
   int MaxSock;
   char HaveWorthless;
   struct PLAYER *tmp;
   struct sigaction sact;
   sigset_t sigset;

   ResizedFlag=0;
   sact.sa_handler=ResizeHandle;
   sact.sa_flags=0;
   sigemptyset(&sact.sa_mask);
   if (sigaction(SIGWINCH,&sact,NULL)==-1) {
      fprintf(stderr,"Cannot install SIGWINCH handler!\n");
   }
   strcpy(buf,Play->Name);
   InitialisePlayer(Play);
   attrset(TextAttr); clear_screen();
   display_message(NULL);
   DisplayFightMessage(NULL);
   print_status(Play,1);

   attrset(TextAttr);
   clear_bottom();
   do {
      nice_input("Hey dude, what's your name? ",buf,NAMELEN,17,1,0,1);
   } while (buf[0]==0);
#if NETWORKING
   if (WantNetwork) {
      if (!ConnectToServer(Play)) { end_curses(); exit(1); }
   }
#endif /* NETWORKING */
   print_status(Play,TRUE);
   display_message("");

   SendClientMessage(NULL,C_NONE,C_NAME,NULL,buf);
   strcpy(Play->Name,buf);

   while (1) {
      if (Play->Health==0) DisplayMode=DM_NONE;
      while (CheckWaitingClientMessage(Play,text)) {
         if (HandleClientMessage(text,Play,&DisplayMode)) return;
      }
      HaveWorthless=0;
      IsCarrying=0;
      for (i=0;i<NumDrug;i++) {
         if (Play->Drugs[i].Carried>0) {
            IsCarrying=1;
            if (Play->Drugs[i].Price==0) HaveWorthless=1;
         }
      }
      switch(DisplayMode) {
         case DM_STREET:
            attrset(TextAttr);
            NumDrugsHere=0;
            for (i=0;i<NumDrug;i++) if (Play->Drugs[i].Price>0) NumDrugsHere++;
            clear_bottom();
            mvaddstr(16,1,"Hey dude, the prices of "); addstr(Names.Drugs);
            addstr(" here are:");
            i=-1;
            for (c=0;c<NumDrugsHere;c++) {
               if ((i=GetNextDrugIndex(i,Play))==-1) break;
               sprintf(text,"%c. %-10s %8s",'A'+c,Drug[i].Name,
                       FormatPrice(Play->Drugs[i].Price,buf));
               mvaddstr(17+c/3,(c%3)*25+4,text);
            }
            attrset(PromptAttr);
            strcpy(text,"Will you B>uy");
            if (IsCarrying) strcat(text,", S>ell");
            if (HaveWorthless && !WantAntique) strcat(text,", D>rop");
            if (Network) strcat(text,", T>alk, P>age, L>ist");
            if (!WantAntique && (Play->Bitches.Carried>0 || 
                Play->Flags&SPYINGON)) {
               strcat(text,", G>ive");
            }
            if (Play->Flags & FIGHTING) {
               strcat(text,", F>ight");
/*            } else if (Play->Flags&TRADING) {
               strcat(text,", T>rade");*/
            } else {
               strcat(text,", J>et");
            }
            strcat(text,", or Q>uit? ");
            mvaddstr(22,40-strlen(text)/2,text);
            attrset(TextAttr);
            curs_set(1);
            break;
         case DM_FIGHT:
            DisplayFightMessage("");
            attrset(PromptAttr);
            strcpy(text,"Do you ");
            if (Play->Flags&CANSHOOT) {
               if (TotalGunsCarried(Play)>0) strcat(text,"F>ight, ");
               else strcat(text,"S>tand, ");
            }
            if (Play->Flags&FIGHTING) strcat(text,"R>un, ");
            strcat(text,"D>eal "); strcat(text,Names.Drugs);
            strcat(text,", or Q>uit? ");
            mvaddstr(22,40-strlen(text)/2,text);
            attrset(TextAttr);
            curs_set(1);
            break;
         case DM_DEAL:
            attrset(TextAttr);
            clear_bottom();
            mvaddstr(16,1,"Your trade:-");
            mvaddstr(19,1,"His trade:-");
            strcpy(text,"Do you A>dd, R>emove, O>K, D>eal ");
            strcat(text,Names.Drugs); strcat(text,", or Q>uit? ");
            attrset(PromptAttr);
            mvaddstr(22,40-strlen(text)/2,text);
            attrset(TextAttr);
            curs_set(1);
            break;
      }
      refresh();

#if NETWORKING
      FD_ZERO(&readfs);
      FD_SET(0,&readfs); MaxSock=1;
      if (Client) { FD_SET(ClientSock,&readfs); MaxSock=ClientSock+2; }
      if (bselect(MaxSock,&readfs,NULL,NULL,NULL)==-1) {
         if (errno==EINTR) {
            CheckForResize(Play);
            continue;
         }
         perror("bselect"); exit(1);
      }
      if (Client && FD_ISSET(ClientSock,&readfs)) {
         pt=bgets(text,BUFLEN,ClientSock);
         chomp(text);
         if (!pt) {
            attrset(TextAttr);
            clear_line(22);
            mvaddstr(22,0,"Connection to server lost! ");
            addstr("Reverting to single player mode");
            nice_wait();
            SwitchToSinglePlayer(Play);
         } else {
            if (HandleClientMessage(text,Play,&DisplayMode)) return;
         }
      } else if (FD_ISSET(0,&readfs)) {
#elif HAVE_SELECT
      FD_ZERO(&readfs);
      FD_SET(0,&readfs); MaxSock=1;
      if (bselect(MaxSock,&readfs,NULL,NULL,NULL)==-1) {
         if (errno==EINTR) {
            CheckForResize(Play);
            continue;
         }
         perror("bselect"); exit(1);
      }
#endif /* NETWORKING */
         c=bgetch(); c=toupper(c);
#if ! (NETWORKING || HAVE_SELECT)
         CheckForResize(Play);
#endif
         if (DisplayMode==DM_STREET) {
            if (c=='J' && !(Play->Flags&FIGHTING)) {
               if (jet(Play,TRUE)) DisplayMode=DM_NONE;
            } else if (c=='F' && Play->Flags&FIGHTING) {
               DisplayMode=DM_FIGHT;
            } else if (c=='T' && Play->Flags&TRADING) {
               DisplayMode=DM_DEAL;
            } else if (c=='B') {
               DealDrugs(Play,TRUE);
            } else if (c=='S' && IsCarrying) {
               DealDrugs(Play,FALSE);
            } else if (c=='D' && HaveWorthless && !WantAntique) {
               DropDrugs(Play);
            } else if (c=='G' && !WantAntique && Play->Bitches.Carried>0) {
               GiveErrand(Play);
            } else if (c=='Q') {
               if (want_to_quit()==1) {
                  DisplayMode=DM_NONE;
                  clear_bottom();
                  SendClientMessage(Play,C_NONE,C_WANTQUIT,NULL,NULL);
               }
            } else if (c=='L' && Network) {
               attrset(PromptAttr);
               mvaddstr(23,20,"List what? P>layers or S>cores? ");
               curs_set(1);
               i=bgetch(); i=toupper(i); 
               curs_set(0);
               if (i=='P') {
                  ListPlayers(Play,FALSE,NULL);
               } else if (i=='S') {
                  DisplayMode=DM_NONE;
                  SendClientMessage(Play,C_NONE,C_REQUESTSCORE,NULL,NULL);
               }
            } else if (c=='P' && Network) {
               tmp=ListPlayers(Play,TRUE,
                   "Whom do you want to page (talk privately to) ? ");
               if (tmp) {
                  nice_input("Talk: ",text,60,23,0,0,0);
                  if (text[0]) {
                     SendClientMessage(Play,C_NONE,C_MSGTO,tmp,text);
                     sprintf(buf,"%s->%s: %s",Play->Name,tmp->Name,text);
                     display_message(buf);
                  }
               }
            } else if (c=='T' && Client) {
               nice_input("Talk: ",text,60,23,0,0,0);
               if (text[0]) {
                  SendClientMessage(Play,C_NONE,C_MSG,NULL,text);
                  sprintf(buf,"%s: %s",Play->Name,text);
                  display_message(buf);
               }
            }
         } else if (DisplayMode==DM_FIGHT) {
            switch(c) {
               case 'D': 
                  DisplayMode=DM_STREET; 
                  break;
               case 'R':
                  DisplayMode=DM_NONE;
                  jet(Play,FALSE);
                  break;
               case 'F':
                  if (TotalGunsCarried(Play)>0 && Play->Flags&CANSHOOT) {
                     text[0]=c; text[1]='\0';
                     Play->Flags &= ~CANSHOOT;
                     SendClientMessage(Play,C_NONE,C_FIGHTACT,NULL,text);
                  }
                  break;
               case 'S':
                  if (TotalGunsCarried(Play)==0 && Play->Flags&CANSHOOT) {
                     text[0]=c; text[1]='\0';
                     Play->Flags &= ~CANSHOOT;
                     SendClientMessage(Play,C_NONE,C_FIGHTACT,NULL,text);
                  }
                  break;
               case 'Q':
                  if (want_to_quit()==1) {
                     DisplayMode=DM_NONE; clear_bottom();
                     SendClientMessage(Play,C_NONE,C_WANTQUIT,NULL,NULL);
                  }
                  break;
            }
         } else if (DisplayMode==DM_DEAL) {
            switch(c) {
               case 'D': 
                  DisplayMode=DM_STREET; 
                  break;
               case 'Q':
                  if (want_to_quit()==1) {
                     DisplayMode=DM_NONE; clear_bottom();
                     SendClientMessage(Play,C_NONE,C_WANTQUIT,NULL,NULL);
                  }
                  break;
            }
         }
#if NETWORKING
      }
#endif
      curs_set(0);
   }
}

void InitList(DopeList *List) {
/* A DopeList is akin to a Vector class; it is a list of DopeEntry   */
/* structures, which can be dynamically extended or compressed. This */
/* function initialises the newly-created list pointed to by "List"  */
/* (A DopeEntry contains a PLAYER pointer and a counter, and is used */
/* by the server to keep track of tipoffs and spies.)                */
   List->Data=NULL;
   List->Number=0;
}

void ClearList(DopeList *List) {
/* Clears the list pointed to by "List" */
   free(List->Data);
   InitList(List);
}

void AddListEntry(DopeList *List,DopeEntry *NewEntry) {
/* Adds a new DopeEntry (pointed to by "NewEntry") to the list "List". */
/* A copy of NewEntry is placed into the list, so the original         */
/* structure pointed to by NewEntry can be reused.                     */
   if (!NewEntry || !List) return;
   List->Number++;
   List->Data = (DopeEntry *)realloc(List->Data,List->Number*
                                                sizeof(DopeEntry));
   if (!List->Data) {
      puts("ERROR: realloc failed!");
      exit(1);
   }
   memcpy(&(List->Data[List->Number-1]),NewEntry,sizeof(DopeEntry));
}

void RemoveListEntry(DopeList *List,int Index) {
/* Removes the DopeEntry at index "Index" from list "List" */
   if (!List || Index<0 || Index>=List->Number) return;

   memmove(&(List->Data[Index]),&(List->Data[Index+1]),
           (List->Number-1-Index)*sizeof(DopeEntry));
   List->Number--;
   List->Data = (DopeEntry *)realloc(List->Data,List->Number*
                                                sizeof(DopeEntry));
   if (List->Number==0) List->Data=NULL;
}

int GetListEntry(DopeList *List,struct PLAYER *Play) {
/* Returns the index of the DopeEntry matching "Play" in list "List" */
/* or -1 if this is not found.                                       */
   int i;
   for (i=List->Number-1;i>=0;i--) {
      if (List->Data[i].Play==Play) return i;
   }
   return -1;
}

void RemoveListPlayer(DopeList *List,struct PLAYER *Play) {
/* Removes (if it exists) the DopeEntry in list "List" matching "Play" */
   RemoveListEntry(List,GetListEntry(List,Play));
}

void RemoveAllEntries(DopeList *List,struct PLAYER *Play) {
/* Similar to RemoveListPlayer, except that if the list contains "Play"     */
/* more than once, all the matching entries are removed, not just the first */
   int i=0;
   while (1) {
      i=GetListEntry(List,Play);
      if (i==-1) break;
      RemoveListEntry(List,i);
   }
}
     
int ReadNameValue(FILE *fp,char *name,int namelen,
                  char *value,int valuelen,char *sname,
                  int snamelen,int *Index,char *HasEquals) {
/* Reads a sname[index].name=value or name=value pair from file "fp" into */
/* "Index", "name", "value" and "sname". Only the first namelen, valuelen */
/* and snamelen respectively of the buffers are touched.                  */
/*  Returns 0 on success,                                                 */
/*         -1 on EOF,                                                     */
/*         -2 if a comment is read.                                       */
/* (*HasEquals) is set to 1 if and only if the line contains an "="       */
/* sname is returned blank, and Index=0, if a name=value pair is read.    */
   char line[900];
   if (fgets(line,900,fp)==NULL) return -1;
   return ParseNameValue(line,name,namelen,value,valuelen,sname,snamelen,
                         Index,HasEquals);
}


int ParseNameValue(char *line,char *name,int namelen,
                  char *value,int valuelen,char *sname,
                  int snamelen,int *Index,char *HasEquals) {
/* Extracts general sname[index].name=value or name=value data from      */
/* "line". Return values as for ReadNameValue above.                     */
   char *pt,*linept;
   char *lbrack,*rbrack,*dot;
   int len;
   sname[0]=name[0]=value[0]='\0';
   *Index=0;
   chomp(line); chomp(line);
   if (line[0]=='#') return -2;

   *HasEquals=0;
   linept=line;
/* Trim whitespace from start and end of both name and value */
/* Return if name is entirely whitespace */
   while (*linept && isspace(*linept)) linept++;
   if (*linept=='\0') return -3;
   len=strlen(linept);
   while (len>0 && isspace(linept[len-1])) len--;
   if (len==0) return -3;
   linept[len]='\0';

   pt=index(line,'=');
   if (pt) {
      *HasEquals=1;
      *pt='\0';
      pt++;
      while (*pt && isspace(*pt)) pt++;
      len=strlen(pt);
      while (len>0 && isspace(pt[len-1])) len--;
      pt[len]='\0';
      strncpy(value,pt,valuelen);
   }
   lbrack=index(linept,'[');
   rbrack=index(linept,']');
   dot=index(linept,'.');
   if (lbrack && !rbrack) ReportError("[ without ]!\n");
   if (lbrack && rbrack) {
      if (!dot) ReportError("Missing .\n");
      else {
         *rbrack='\0'; 
         *lbrack='\0';
         *Index=atoi(lbrack+1);
         *dot='\0'; 
         strncpy(sname,linept,snamelen);
         strncpy(name,dot+1,namelen);
      }
   } else {
      strncpy(name,linept,namelen);
   }
   name[namelen-1]=sname[snamelen-1]=value[valuelen-1]='\0';
   return 0;
}

void ReportError(char *text) {
/* Reports the error in "text" to a suitable error medium */
   fprintf(stderr,"Error: %s\n",text);
}

void *ResizeStruct(void *Ptr,int *OldNum,int NewNum,int SizeOne) {
/* "Ptr" is a pointer to an array of "OldNum" structs, each of "SizeOne" */
/* bytes. The array is redimensioned to "NewNum", updating "OldNum" in   */
/* the process, and a pointer to the new array is returned.              */
   void *NewMem;
   NewMem=realloc(Ptr,SizeOne*NewNum);
   if (!NewMem && NewNum!=0) {
      fprintf(stderr,"realloc failed!\n");
      exit(1);
   }
   if (NewNum>*OldNum) {
      memset(NewMem+SizeOne*(*OldNum),0,(NewNum-*OldNum)*SizeOne);
   }
   *OldNum=NewNum;
   return NewMem;
}

char HandleOption(char *name,char *sname,int Index,char *value,
                  char *ErrorSuffix,char Display,char InGame,char HasEquals) {
/* Processes the name[index]=value option. Returns TRUE if it is a         */
/* valid option. ErrorSuffix is text to describe any errors that occur.    */
/* "Display" is TRUE if the routine should print some feedback.            */
/* "InGame" should be TRUE if players are currently connected to the       */
/* server (commands that change some data should be disabled during games) */
/* "HasEquals" should be TRUE if value contains valid data to set          */
/* name[index] to (rather than displaying the contents of name[index])     */
   int i;
   struct PLAYER *tmp;
   char buf[500];
   for (i=0;i<NUMGLOB;i++) {
      if (strcasecmp(name,Globals[i].Name)==0 && (sname[0]==0 ||
          (strcasecmp(sname,Globals[i].NameStruct)==0 && 
           Globals[i].StructStaticPt && Globals[i].StructListPt))) {
         if (InGame && value[0]) {
            printf("This option should not be changed while players are \
connected. Wait\n");
            printf("for them all to log off, or push/kill them, first...\n");
            return TRUE;
         }
         if (sname[0]) {
            if (Globals[i].MaxIndex && (Index>*(Globals[i].MaxIndex)
                || Index<1)) {
               sprintf(buf,"Index into %s (%d) should be between 1 \
and %d %s- ignoring",Globals[i].NameStruct,Index,*(Globals[i].MaxIndex),
                       ErrorSuffix);                
               ReportError(buf);
               return TRUE;
            }
            Index--;
/* Nasty horrible kludge to access structure members - it's bound to */
/* cause a ton of segfaults... */
            if (Globals[i].IntVal) {
               if (HasEquals) {
                  *((int *)((((void *)Globals[i].IntVal)-
                            Globals[i].StructStaticPt) + 
                            *(Globals[i].StructListPt) + 
                            Index*Globals[i].LenStruct)) =atoi(value);
               } else {
                  printf("%s[%d].%s is %d\n",Globals[i].NameStruct,
                         Index+1,Globals[i].Name,
                         *((int *)((((void *)Globals[i].IntVal)-
                            Globals[i].StructStaticPt) + 
                            *(Globals[i].StructListPt) + 
                            Index*Globals[i].LenStruct)));
               }
            }
            if (Globals[i].PriceVal) {
               if (HasEquals) {
                  *((price_t *)((((void *)Globals[i].PriceVal)-
                            Globals[i].StructStaticPt) + 
                            *(Globals[i].StructListPt) + 
                            Index*Globals[i].LenStruct)) =strtoprice(value);
               } else {
                  printf("%s[%d].%s is %s\n",Globals[i].NameStruct,
                         Index+1,Globals[i].Name,FormatPrice(
                         *((price_t *)((((void *)Globals[i].PriceVal)-
                            Globals[i].StructStaticPt) + 
                            *(Globals[i].StructListPt) + 
                            Index*Globals[i].LenStruct)),buf));
               }
            }
            if (Globals[i].StringVal) {
               if (HasEquals) {
                  strncpy((char *)((((void *)Globals[i].StringVal)-
                          Globals[i].StructStaticPt) + 
                          *(Globals[i].StructListPt) + 
                          Index*Globals[i].LenStruct),
                          value,Globals[i].LenMax);
               } else {
                  printf("%s[%d].%s is %s\n",Globals[i].NameStruct,
                         Index+1,Globals[i].Name,
                         (char *)((((void *)Globals[i].StringVal)-
                         Globals[i].StructStaticPt) + 
                         *(Globals[i].StructListPt) + 
                         Index*Globals[i].LenStruct));
               }
            }
            if (HasEquals && Display) {
               printf("%s[%d].%s is now %s\n",sname,Index+1,
                      name,value);
            }
         } else {
            if (Globals[i].IntVal) {
               if (HasEquals) {
                  if (Globals[i].StructListPt &&
                      Globals[i].LenStruct) {
                     *(Globals[i].StructListPt) = 
                        ResizeStruct(*(Globals[i].StructListPt),
                                     Globals[i].IntVal,atoi(value),
                                     Globals[i].LenStruct);
                     if (Display) printf("Resized structure list to %d \
elements\n",*(Globals[i].IntVal));
                     for (tmp=FirstClient;tmp;tmp=tmp->Next) {
                        UpdatePlayer(tmp);
                     }
                     for (tmp=FirstServer;tmp;tmp=tmp->Next) {
                        UpdatePlayer(tmp);
                     }
                  }
                  *(Globals[i].IntVal) = atoi(value);
               } else {
                  printf("%s is %d\n",Globals[i].Name,
                         *(Globals[i].IntVal));
               }
            }
            if (Globals[i].PriceVal) {
               if (HasEquals) {
                  *(Globals[i].PriceVal) = strtoprice(value);
               } else {
                  printf("%s is %s\n",Globals[i].Name,
                         FormatPrice(*(Globals[i].PriceVal),buf));
               }
            }
            if (Globals[i].StringVal) {
               if (HasEquals) {
                  strncpy(Globals[i].StringVal,value,
                          Globals[i].LenMax);
               } else {
                  printf("%s is %s\n",Globals[i].Name,
                         Globals[i].StringVal);
               }
            }
            if (HasEquals && Display) {
               printf("%s is now %s\n",Globals[i].Name,value);
            }
         }
         return TRUE;
      }
   }
   return FALSE;
}

void ProcessConfigFile(char *ConfigFile) {
/* Opens and reads the options from the named "ConfigFile"   */
   FILE *fp;
   char ErrorSuffix[900];
   char name[80],sname[80],value[80],buf[500],HasEquals;
   int LineNumber,Index;
   fp=fopen(ConfigFile,"r");
   if (fp) {
      LineNumber=1;
      while (!feof(fp)) {
         sprintf(ErrorSuffix,"in config file %s, line %d ",ConfigFile,
                 LineNumber);
         if (ReadNameValue(fp,name,80,value,80,sname,80,&Index,&HasEquals)==0) {
            if (!HandleOption(name,sname,Index,value,ErrorSuffix,
                ConfigVerbose,FALSE,HasEquals)) {
               sprintf(buf,"Unknown option %s",ErrorSuffix);
               ReportError(buf);
            }
         }
         LineNumber++;
      }
      fclose(fp);
   }
}

void SetupParameters() {
/* Initialises the location of the high score file, the name of the   */
/* host running a dopewars server, and the port on which the server   */
/* is to be found. Defaults can be overridden by the file ~/.dopewars */
/* or by specifying command line options.                             */
   char ConfigFile[800],*pt;

/* First, set hard-coded default values */
   sprintf(HiScoreFile,"%s/dopewars.sco",DATADIR);
   strcpy(ServerName,"localhost");
   strcpy(Pager,"more");
   Location=ResizeStruct(Location,&NumLocation,NUMLOCATION,
                         sizeof(struct LOCATION));
   memcpy(Location,DefaultLocation,sizeof(struct LOCATION)*NumLocation);
   Gun=ResizeStruct(Gun,&NumGun,NUMGUN,sizeof(struct GUN));
   memcpy(Gun,DefaultGun,sizeof(struct GUN)*NumGun);
   Drug=ResizeStruct(Drug,&NumDrug,NUMDRUG,sizeof(struct DRUG));
   memcpy(Drug,DefaultDrug,sizeof(struct DRUG)*NumDrug);

/* Now read in the global configuration file */
   ProcessConfigFile("/etc/dopewars");

/* Finally, try to read in the .dopewars file in the user's home directory */
   pt=getenv("HOME");
   if (!pt) return;
   if (strlen(pt) > 770) {
      sprintf(ConfigFile,"Home directory %s too long.",pt);
      ReportError(ConfigFile);
      return;
   }
   sprintf(ConfigFile,"%s/.dopewars",pt);
   ProcessConfigFile(ConfigFile);
}

int main(int argc,char *argv[]) {
/* Main program entry point. Initialises variables and parses command line */
/* options, before starting a client, server, or AI player.                */
   int c;
   char Name[NAMELEN];
#if CYGWIN || HAVE_GETTIMEOFDAY
   struct timeval tp;

   gettimeofday(&tp,NULL);
   srand(tp.tv_usec);
#endif
   Location=NULL;
   Gun=NULL;
   Drug=NULL;
   NumLocation=NumGun=NumDrug=0;
   FirstClient=FirstServer=NULL;
   strcpy(Noone.Name,"Noone");
   SetupParameters();
   WantColour=WantNetwork=1; WantHelp=WantVersion=WantAntique=0;
   Server=AIPlayer=FALSE;
   while (1) {
      c=getopt(argc,argv,"anbchvf:o:sSp:g:");
      if (c==EOF) break;
      switch(c) {
         case 'n': WantNetwork=0; break;
         case 'b': WantColour=0; break;
         case 'c': AIPlayer=1; break;
         case 'a': WantAntique=1; WantNetwork=0; break;
         case 'v': WantVersion=1; break;
         case 'h':
         case '?': WantHelp=1; break;
         case 'f': strcpy(HiScoreFile,optarg); break;
         case 'o': strcpy(ServerName,optarg); break;
         case 's': Server=TRUE; NotifyMetaServer=TRUE; break;
         case 'S': Server=TRUE; NotifyMetaServer=FALSE; break;
         case 'p': Port=atoi(optarg); break;
         case 'g': ProcessConfigFile(optarg); break;
      }
   }
   if (WantVersion) {
      printf("dopewars version %s\n",VERSION);
      return 0;
   }
   if (WantAntique) Location=ResizeStruct(Location,&NumLocation,6,
                                          sizeof(struct LOCATION));
   if (WantHelp) {
      printf("dopewars version %s\n",VERSION);
      puts("Usage: dopewars [OPTION]...");
      puts("Drug dealing game based on \"Drug Wars\" by John E. Dell\n");
      
      puts("  -b       \"black and white\" - i.e. do not use pretty colours");
      puts("              (by default colours are used where the \
terminal supports them)");
      puts("  -n       be boring and don't connect to any available \
dopewars servers");
      puts("              (i.e. single player mode)");
      puts("  -a       \"antique\" dopewars - keep as closely to the \
original version as");
      puts("              possible (this also disables any networking)");
      puts("  -f file  specify a file to use as the high score table");
      printf("              (by default %s/dopewars.sco is used)\n",DATADIR);
      puts("  -o addr  specify a hostname where the server for \
multiplayer dopewars ");
      puts("              can be found (in human-readable - e.g. \
nowhere.com - format)");
      puts("  -s       run in server mode (note: for a \"non-interactive\" \
server, simply");
      puts("              run as dopewars -s < /dev/null >> logfile & )");
      puts("  -S       run a \"private\" server (i.e. do not notify the \
dopewars metaserver)");
      puts("  -p       specify the network port to use (default: 7902)");
      puts("  -g file  specify the pathname of a dopewars configuration file. \
This file is");
      puts("           read immediately when the -g option is encountered"); 
      puts("  -c       create and run a computer player");
      puts("  -h       display this help information");
      puts("  -v       output version information and exit\n");

      puts("dopewars is Copyright (C) Ben Webb 1998-2000, and released \
under the GNU GPL");
      puts("Report bugs to the author at ben@bellatrix.pcl.ox.ac.uk");
      return 0;
   }

#if NETWORKING
   StartNetworking();
#endif

   if (Server) {
#if NETWORKING
      WantAntique=0;
      ServerLoop();
#else
      puts("This binary has been compiled without networking support, and \
thus cannot act");
      puts("as a server. Recompile passing --enable-networking to the \
configure script.");
#endif /* NETWORKING */
   } else if (AIPlayer) {
      AIPlayerLoop();
   } else {
      start_curses();
      Width=COLS; Depth=LINES;

      display_intro();

      c='Y';
      Name[0]=0;
      while(c=='Y') {
         Player=AddPlayer(0,&FirstClient);
         strncpy(Player->Name,Name,NAMELEN);
         do_game(Player);
         strncpy(Name,Player->Name,NAMELEN);
         ClearWaitingClientMessages();
         ShutdownNetwork();
         CleanUpServer();
         attrset(TextAttr);
         mvaddstr(23,20,"Play again? ");
         c=GetKey("YN");
      }
      end_curses();
   }
#if NETWORKING
   StopNetworking();
#endif
   return 0;
}
