/* clientside.c   Handles the client side of Dopewars                   */
/* Copyright (C)  1998-2000  Ben Webb                                   */
/*                Email: ben@bellatrix.pcl.ox.ac.uk                     */
/*                WWW: http://bellatrix.pcl.ox.ac.uk/~ben/dopewars/     */

/* This program is free software; you can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License          */
/* as published by the Free Software Foundation; either version 2       */
/* of the License, or (at your option) any later version.               */

/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */

/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston,               */
/*                   MA  02111-1307, USA.                               */


#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <ctype.h>
#include "dopeos.h"
#include "clientside.h"
#include "serverside.h"
#include "dopewars.h"
#include "message.h"

struct PLAYER *FirstClient;
void PrepareHighScoreScreen();
void PrintHighScore(char *Data);

int HandleGenericClientMessage(struct PLAYER *From,char AICode,char Code,
                               struct PLAYER *To,char *Data) {
/* Handles messages that both human clients and AI players deal with in the */
/* same way. Returns TRUE if the message is handled.                        */
   struct PLAYER *tmp;
   int i;
   char Type,*pt,wrd[BUFLEN];
   switch(Code) {
      case C_LIST:
         tmp=AddPlayer(0,&FirstClient);
         strcpy(tmp->Name,Data);
         break;
      case C_DATA:
         pt=Data;
         pt=ExtractWord(wrd,BUFLEN,pt);
         i=atoi(wrd);
         pt=ExtractWord(wrd,BUFLEN,pt);
         Type=wrd[0];
         switch(Type) {
            case DT_LOCATION:
               strcpy(Location[i].Name,&wrd[1]);
               Location[i].PolicePresence=10;
               Location[i].MinDrug=NumDrug/2+1;
               Location[i].MaxDrug=NumDrug;
               break;
            case DT_GUN:
               strcpy(Gun[i].Name,&wrd[1]);
               pt=ExtractWord(wrd,BUFLEN,pt);
               Gun[i].Price=strtoprice(wrd);
               pt=ExtractWord(wrd,BUFLEN,pt);
               Gun[i].Space=atoi(wrd);
               pt=ExtractWord(wrd,BUFLEN,pt);
               Gun[i].Damage=atoi(wrd);
               break;
            case DT_DRUG:
               strcpy(Drug[i].Name,&wrd[1]);
               pt=ExtractWord(wrd,BUFLEN,pt);
               Drug[i].MinPrice=strtoprice(wrd);
               pt=ExtractWord(wrd,BUFLEN,pt);
               Drug[i].MaxPrice=strtoprice(wrd);
               break;
            case DT_PRICES:
               Prices.Spy=strtoprice(&wrd[1]);
               pt=ExtractWord(wrd,BUFLEN,pt);
               Prices.Tipoff=strtoprice(wrd);
               break;
         }
         break;   
      default:
         return FALSE;
   }
   return TRUE;
}

int HandleClientMessage(char *Message,struct PLAYER *ReallyTo,
                        char *DisplayMode) {
/* Given a message "Message" coming in on a socket which identifies it as   */
/* "really" for player "ReallyTo", performs processing and reacts properly; */
/* returns 0 on normal termination, or 1 if the message indicates that the  */
/* client should quit.                                                      */
/* "DisplayMode" is a pointer to the client's display mode, and is updated  */
/* if the mode should be changed as a result of an incoming message.        */
   char *pt,Data[BUFLEN],Code,wrd[BUFLEN],buf[BUFLEN];
   char AICode,Version[20];
   struct PLAYER *From,*To,*tmp;
   int i;
   if (ProcessMessage(Message,&From,&AICode,&Code,&To,Data,FirstClient)==-1) {
      attrset(TextAttr);
      clear_line(22);
      mvaddstr(22,0,"Bad network message. Oops. ");
      nice_wait(); return 0;
   }

   if (!HandleGenericClientMessage(From,AICode,Code,To,Data)) switch(Code) {
      case C_ENDLIST:
         if (FirstClient && FirstClient->Next) ListPlayers(To,FALSE,NULL);
         break;
      case C_STARTHISCORE:
         PrepareHighScoreScreen();
         break;
      case C_HISCORE:
         PrintHighScore(Data);
         break;
      case C_ENDHISCORE:
         if (strcmp(Data,"end")==0) return 1;
         else {
            nice_wait();
            clear_screen();
            display_message("");
            print_status(To,1);
            refresh();
         }
         break;
      case C_PUSH:
         attrset(TextAttr);
         clear_line(22);
         mvaddstr(22,0,"You have been pushed from the server. ");
         addstr("Reverting to single player mode.");
         nice_wait();
         SwitchToSinglePlayer(To);
         break;
      case C_QUIT:
         attrset(TextAttr);
         clear_line(22);
         mvaddstr(22,0,
            "The server has terminated. Reverting to single player mode.");
         nice_wait();
         SwitchToSinglePlayer(To);
         break;
      case C_MSG:
         sprintf(buf,"%s: %s",From->Name,Data);
         display_message(buf);
         break;
      case C_MSGTO:
         sprintf(buf,"%s->%s: %s",From->Name,To->Name,Data);
         display_message(buf);
         break;
      case C_INIT:
         strcpy(Version,VERSION);
         pt=Data;
         pt=ExtractWord(wrd,BUFLEN,pt);
         if (strcmp(Version,wrd)!=0) {
            sprintf(buf,"This server is version %s, while your client is \
version %s.^Be warned that different versions may not be fully compatible!^\
Refer to the website at http://bellatrix.pcl.ox.ac.uk/~ben/dopewars/^\
for the latest version.",wrd,Version); 
            PrintMessage(buf);
            nice_wait();
         }
         pt=ExtractWord(wrd,BUFLEN,pt);
         Location=ResizeStruct(Location,&NumLocation,atoi(wrd),
                               sizeof(struct LOCATION));
         pt=ExtractWord(wrd,BUFLEN,pt);
         Gun=ResizeStruct(Gun,&NumGun,atoi(wrd),sizeof(struct GUN));
         pt=ExtractWord(wrd,BUFLEN,pt);
         Drug=ResizeStruct(Drug,&NumDrug,atoi(wrd),sizeof(struct DRUG));
         for (tmp=FirstClient;tmp;tmp=tmp->Next) UpdatePlayer(tmp); 
         pt=ExtractWord(Names.Bitch,sizeof(Names.Bitch),pt);
         pt=ExtractWord(Names.Bitches,sizeof(Names.Bitches),pt);
         pt=ExtractWord(Names.Gun,sizeof(Names.Gun),pt);
         pt=ExtractWord(Names.Guns,sizeof(Names.Guns),pt);
         pt=ExtractWord(Names.Drug,sizeof(Names.Drug),pt);
         pt=ExtractWord(Names.Drugs,sizeof(Names.Drugs),pt);
         pt=ExtractWord(Names.Month,sizeof(Names.Month),pt);
         pt=ExtractWord(Names.Year,sizeof(Names.Year),pt);
         break;
      case C_JOIN:
         sprintf(buf,"%s joins the game!",Data);
         display_message(buf);
         tmp=AddPlayer(0,&FirstClient);
         strcpy(tmp->Name,Data);
         break;
      case C_LEAVE:
         if (From!=&Noone) {
            sprintf(buf,"%s has left the game.",From->Name);
            RemovePlayer(From,&FirstClient);
            display_message(buf);
         }
         break;
      case C_RENAME:
         sprintf(buf,"%s will now be known as %s.",From->Name,Data);
         strcpy(From->Name,Data);
         mvaddstr(22,0,buf); nice_wait();
         break;
      case C_PRINTMESSAGE:
         PrintMessage(Data);
         nice_wait();
         break;
      case C_FIGHTPRINT:
         pt=Data;
         pt=ExtractWord(wrd,BUFLEN,pt);
         while (wrd[0]) {
            DisplayFightMessage(wrd);
            pt=ExtractWord(wrd,BUFLEN,pt);
         }
         if (pt[0]) DisplayFightMessage(pt);
         if (From!=&Noone) {
            From->Flags |= FIGHTING;
            To->Flags |= CANSHOOT;
         }
         *DisplayMode=DM_FIGHT;
         break;
      case C_TRADE:
         *DisplayMode=DM_DEAL;
         break;
      case C_DRUGHERE:
         ReceiveDrugsHere(Data,To);
         *DisplayMode=DM_STREET;
         break;
      case C_CHANGEDISP:
         if (Data[0]=='N' && *DisplayMode==DM_STREET) *DisplayMode=DM_NONE;
         if (Data[0]=='Y' && *DisplayMode==DM_NONE) *DisplayMode=DM_STREET;
         break;
      case C_SUBWAYFLASH:
         DisplayFightMessage(NULL);
         for (tmp=FirstClient;tmp;tmp=tmp->Next) tmp->Flags &= ~FIGHTING;
         for (i=0;i<4;i++) {
            print_location("S U B W A Y");
            refresh();
            MicroSleep(100000);
            print_location("");
            refresh();
            MicroSleep(100000);
         }
         print_location(Location[(int)To->IsAt].Name);
         break;
      case C_QUESTION:
         pt=Data;
         pt=ExtractWord(wrd,BUFLEN,pt);
         PrintMessage(pt);
         addch(' ');
         i=GetKey(wrd);
         buf[0]=i; buf[1]=0;
         SendClientMessage(To,C_NONE,C_ANSWER,From==&Noone ? NULL : From,buf);
         break;
      case C_LOANSHARK:
         LoanShark(To);
         SendClientMessage(To,C_NONE,C_DONE,NULL,NULL);
         break;
      case C_BANK:
         Bank(To);
         SendClientMessage(To,C_NONE,C_DONE,NULL,NULL);
         break;
      case C_GUNSHOP:
         GunShop(To);
         SendClientMessage(To,C_NONE,C_DONE,NULL,NULL);
         break;
      case C_UPDATE:
         if (From==&Noone) {
            ReceivePlayerData(Data,To);
            print_status(To,1); refresh();
         } else {
            DisplaySpyReports(Data,From);
         }
         break;
      case C_NEWNAME:
         clear_line(22); clear_line(23);
         attrset(TextAttr);
         mvaddstr(22,0,"Unfortunately, somebody else is already \
using \"your\" name. Please change it.");
         change_name(1);
         break;
      default:
         sprintf(buf,"%s^%c^%s^%s",From->Name,Code,To->Name,Data);
         mvaddstr(22,0,buf); nice_wait();
         break;
   }
   return 0;
}

void PrepareHighScoreScreen() {
/* Responds to a "starthiscore" message by clearing the screen and */
/* displaying the title for the high scores screen                 */
   attrset(TextAttr);
   clear_screen();
   attrset(TitleAttr);
   mvaddstr(0,29,"H I G H   S C O R E S");
   attrset(TextAttr);
}

void PrintHighScore(char *Data) {
/* Prints a high score coded in "Data"; first word is the index of the  */
/* score (i.e. y screen coordinate), second word is the text, the first */
/* letter of which identifies whether it's to be printed bold or not.   */
   char *cp,wrd[BUFLEN];
   int index;
   cp=Data;
   cp=ExtractWord(wrd,BUFLEN,cp);
   index=atoi(wrd);
   if (!cp || strlen(cp)<2) return;
   move(index+2,0);
   attrset(TextAttr);
   if (cp[0]=='B') standout();
   addstr(&cp[1]); 
   if (cp[0]=='B') standend();
}

void PrintMessage(char *text) {
/* Prints a message "text" received via. a "printmessage" message in the */
/* bottom part of the screen.                                            */
   int i,line;
   attrset(TextAttr);
   clear_line(16);
   for (i=0;i<strlen(text);i++) {
      if (text[i]!='^') {
         clear_exceptfor(i+1);
         break;
      }
   }
   line=17; move(line,1);
   for (i=0;i<strlen(text);i++) {
      if (text[i]=='^') {
         line++; move(line,1);
      } else addch(text[i]);
   }
}

void GunShop(struct PLAYER *Play) {
/* Allows player "Play" to buy and sell guns interactively. Passes the */
/* decisions on to the server for sanity checking and implementation.  */
   int i,c,c2;
   char text[BUFLEN],num[80];
   print_status(Play,0);
   attrset(TextAttr);
   clear_bottom();
   for (i=0;i<NumGun;i++) {
      sprintf(text,"%c. %-22s %12s",'A'+i,Gun[i].Name,
              FormatPrice(Gun[i].Price,num));
      mvaddstr(17+i/2,(i%2)*40+1,text);
   }
   while (1) {
      strcpy(text,"Will you B>uy, S>ell, or L>eave? ");
      attrset(PromptAttr);
      clear_line(22);
      mvaddstr(22,40-strlen(text)/2,text);
      attrset(TextAttr);
      curs_set(1);
      c=bgetch(); c=toupper(c);
      curs_set(0);
      if (c=='L') break;
      if (c=='S' || c=='B') {
         clear_line(22);
         if (c=='S' && TotalGunsCarried(Play)==0) {
            mvaddstr(22,10,"You don't have any "); addstr(Names.Guns);
            addstr(" to sell!"); nice_wait();
            clear_line(23);
            continue;
         } else if (c=='B' && TotalGunsCarried(Play)>=Play->Bitches.Carried+2) {
            mvaddstr(22,10,"You'll need more ");
            addstr(Names.Bitches); addstr(" to carry any more ");
            addstr(Names.Guns); addstr("!");
            nice_wait();
            clear_line(23);
            continue;
         }
         attrset(PromptAttr);
         mvaddstr(22,20,"What do you wish to ");
         if (c=='B') addstr("buy? "); else addstr("sell? ");
         curs_set(1);
         attrset(TextAttr);
         c2=bgetch(); c2=toupper(c2);
         if (c2>='A' && c2<'A'+NumGun) {
            c2-='A';
            addstr(Gun[c2].Name);
            if (c=='B') {
               if (Gun[c2].Space > Play->CoatSize) {
                  clear_line(22);
                  mvaddstr(22,10,"You don't have enough space to carry \
that "); addstr(Names.Gun); addstr("!");
                  nice_wait();
                  clear_line(23);
                  continue;
               } else if (Gun[c2].Price > Play->Cash) {
                  clear_line(22);
                  mvaddstr(22,10,"You don't have enough cash to buy that ");
                  addstr(Names.Gun); addstr("!");
                  nice_wait();
                  clear_line(23);
                  continue;
               }
               Play->Cash -= Gun[c2].Price;
               Play->CoatSize -= Gun[c2].Space;
               Play->Guns[c2].Carried++;
            } else if (c=='S') {
               if (Play->Guns[c2].Carried == 0) {
                  clear_line(22);
                  mvaddstr(22,10,"You don't have any to sell!");
                  nice_wait(); clear_line(23); continue;
               }
               Play->Cash += Gun[c2].Price;
               Play->CoatSize += Gun[c2].Space;
               Play->Guns[c2].Carried--;
            }
            print_status(Play,0);
            sprintf(text,"gun^%d^%d",c2,c=='B' ? 1 : -1);
            SendClientMessage(Play,C_NONE,C_BUYOBJECT,NULL,text);
         }
      }
   }
   print_status(Play,1);
}

void LoanShark(struct PLAYER *Play) {
/* Allows player "Play" to pay off loans interactively. */
   char text[BUFLEN];
   price_t money;
   while (1) {
      clear_bottom();
      attrset(PromptAttr);
      nice_input("How much money do you give the loan shark? ",
                  text,40,19,1,1,0);
      attrset(TextAttr);
      money=strtoprice(text);
      if (money<0) money=0;
      if (money>Play->Debt) money=Play->Debt;
      if (money>Play->Cash) {
         mvaddstr(20,1,"You don't have that much money!");
         nice_wait();
      } else {
         SendClientMessage(Play,C_NONE,C_PAYLOAN,NULL,
                           pricetostr(money,text,BUFLEN));
         break;
      }
   }
}

void Bank(struct PLAYER *Play) {
/* Allows player "Play" to pay in or withdraw money from the bank */
/* interactively.                                                 */
   char text[BUFLEN];
   price_t money;
   int c;
   while (1) {
      clear_bottom();
      attrset(PromptAttr);
      mvaddstr(18,1,"Do you want to D>eposit in, W>ithdraw from, ");
      addstr("or L>eave the bank? ");
      attrset(TextAttr);
      c=GetKey("DWL");
      if (c=='L') return;
      nice_input("How much money? ",text,40,19,1,1,0);
      money=strtoprice(text);
      if (money<0) money=0;
      if (c=='W') money=-money;
      if (money>Play->Cash) {
         mvaddstr(20,1,"You don't have that much money!");
         nice_wait();
      } else if (-money > Play->Bank) {
         mvaddstr(20,1,"There isn't that much money in the bank...");
         nice_wait();
      } else if (money==0) {
         break;
      } else {
         SendClientMessage(Play,C_NONE,C_DEPOSIT,NULL,
                           pricetostr(money,text,BUFLEN));
         break;
      }
   }
}
