/*
**  Copyright (c) 2007, 2008 Sendmail, Inc. and its suppliers.
**    All rights reserved.
*/

#ifndef lint
static char t_setup_c_id[] = "@(#)$Id: t-setup.c,v 1.7 2008/01/15 20:58:46 msk Exp $";
#endif /* !lint */

/* system includes */
#include <sys/types.h>
#include <assert.h>
#include <stdio.h>

/* libdkim includes */
#include "dkim.h"
#include "t-testdata.h"

/*
**  MAIN -- program mainline
**
**  Parameters:
**  	The usual.
**
**  Return value:
**  	Exit status.
*/

int
main(int argc, char **argv)
{
	char *p;
	FILE *f;

	printf("*** test setup\n");

	f = fopen(KEYFILE, "w");
	assert(f != NULL);

	fprintf(f, "%s.%s.%s ", SELECTOR, DKIM_DNSKEYNAME, DOMAIN);
	for (p = PUBLICKEY; *p != '\0'; p++)
	{
		if (*p != '\n')
			putc(*p, f);
	}
	fprintf(f, "\n");

	fprintf(f, "%s.%s.%s ", SELECTOR2, DKIM_DNSKEYNAME, DOMAIN);
	for (p = PUBLICKEY2; *p != '\0'; p++)
	{
		if (*p != '\n')
			putc(*p, f);
	}
	fprintf(f, "\n");

	fprintf(f, "%s.%s.%s ", SELECTOR, DKIM_DNSKEYNAME, DOMAIN2);
	for (p = PUBLICKEYNOS; *p != '\0'; p++)
	{
		if (*p != '\n')
			putc(*p, f);
	}
	fprintf(f, "\n");

	fprintf(f, "%s.%s.%s ", DKIM_DNSPOLICYNAME, DKIM_DNSKEYNAME, DOMAIN2);
	fprintf(f, "dkim=all; r=%s\n", REPLYADDRESS);

	fclose(f);

	return 0;
}
