/*
**  Copyright (c) 2007 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: dkim-ar.h,v 1.6 2007/12/18 22:42:16 msk Exp $
*/

#ifndef _DKIM_AR_H_
#define _DKIM_AR_H_

#ifndef lint
static char dkim_ar_h_id[] = "@(#)$Id: dkim-ar.h,v 1.6 2007/12/18 22:42:16 msk Exp $";
#endif /* !lint */

/* system includes */
#include <sys/types.h>

/* dkim-filter includes */
#include "dkim-filter.h"

/* limits */
#define	MAXARESULTS	16
#define	MAXPROPS	16
#define	MAXAVALUE	256

/* ARES_METHOD_T -- type for specifying an authentication method */
typedef int ares_method_t;

#define	ARES_METHOD_UNKNOWN	(-1)
#define	ARES_METHOD_AUTH	0
#define	ARES_METHOD_DKIM	1
#define	ARES_METHOD_DOMAINKEYS	2
#define	ARES_METHOD_SENDERID	3
#define	ARES_METHOD_SPF		4
#define	ARES_METHOD_DKIMSSP	5
#define	ARES_METHOD_IPREV	6

/* ARES_RESULT_T -- type for specifying an authentication result */
typedef int ares_result_t;

#define	ARES_RESULT_UNKNOWN	(-1)
#define	ARES_RESULT_PASS	0
#define	ARES_RESULT_HARDFAIL	1
#define	ARES_RESULT_SOFTFAIL	2
#define	ARES_RESULT_NEUTRAL	3
#define	ARES_RESULT_TEMPERROR	4
#define	ARES_RESULT_PERMERROR	5

/* ARES_PTYPE_T -- type for specifying an authentication property */
typedef int ares_ptype_t;

#define	ARES_PTYPE_UNKNOWN	(-1)
#define	ARES_PTYPE_SMTP		0
#define	ARES_PTYPE_HEADER	1
#define	ARES_PTYPE_BODY		2
#define	ARES_PTYPE_POLICY	3

/* RESULT structure -- a single result */
struct result
{
	int		result_props;
	ares_method_t	result_method;
	ares_result_t	result_result;
	ares_ptype_t	result_ptype[MAXPROPS];
	char		result_property[MAXPROPS][MAXAVALUE + 1];
	char		result_value[MAXPROPS][MAXAVALUE + 1];
};

/* AUTHRES structure -- the entire header parsed */
struct authres
{
	int		ares_count;
	char		ares_host[DKIM_MAXHOSTNAMELEN + 1];
	struct result	ares_result[MAXARESULTS];
};

/*
**  ARES_PARSE -- parse an Authentication-Results: header, return a
**                structure containing a parsed result
**
**  Parameters:
**  	hdr -- NULL-terminated contents of an Authentication-Results:
**  	       header field
**  	ar -- a pointer to a (struct authres) loaded by values after parsing
**  
**  Return value:
**  	0 on success, -1 on failure.
*/

extern int ares_parse __P((u_char *hdr, struct authres *ar));

#endif /* _DKIM_AR_H_ */
