/*
**  Copyright (c) 2004, 2005, 2007 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: util.h,v 1.14 2007/09/26 22:57:12 msk Exp $
*/

#ifndef _UTIL_H_
#define _UTIL_H_

#ifndef lint
static char util_h_id[] = "@(#)$Id: util.h,v 1.14 2007/09/26 22:57:12 msk Exp $";
#endif /* !lint */

/* system includes */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>

/* libsm includes */
#include <sm/gen.h>

#ifdef POPAUTH
/* libdb includes */
# include <db.h>
#endif /* POPAUTH */

/* dkim-filter includes */
#include "dkim-filter.h"

/* PROTOTYPES */
extern bool dkimf_checkhost __P((Peer, char *));
extern bool dkimf_checkip __P((Peer, struct sockaddr *));
#ifdef POPAUTH
extern bool dkimf_checkpopauth __P((DB *, struct sockaddr *));
#endif /* POPAUTH */
extern bool dkimf_hostlist __P((char *, char **));
extern size_t dkimf_inet_ntoa __P((struct in_addr, char *, size_t));
#ifdef POPAUTH
extern int dkimf_initpopauth __P((void));
#endif /* POPAUTH */
extern bool dkimf_load_list __P((FILE *, char **, struct Peer **));
extern void dkimf_lowercase __P((u_char *));
extern void dkimf_mkpath __P((char *, size_t, char *, char *));
extern void dkimf_optlist __P((FILE *));
extern void dkimf_setmaxfd __P((void));
extern int dkimf_socket_cleanup __P((char *));
extern void dkimf_stripcr __P((char *));
extern void dkimf_trimspaces __P((u_char *));

#endif /* _UTIL_H_ */
