/*
**  Copyright (c) 2005-2007 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: dkim-filter.h,v 1.65 2007/05/23 18:16:02 msk Exp $
*/

#ifndef _DKIM_FILTER_H_
#define _DKIM_FILTER_H_

#ifndef lint
static char dkim_filter_h_id[] = "@(#)$Id: dkim-filter.h,v 1.65 2007/05/23 18:16:02 msk Exp $";
#endif /* !lint */

#define	DKIMF_PRODUCT	"Sendmail DKIM Filter"
#define	DKIMF_VERSION	"1.0.0"

/* libsm */
#include <sm/gen.h>

/* libdkim */
#include <dkim.h>

/* make sure we have TRUE and FALSE */
#ifndef FALSE
# define FALSE		0
#endif /* !FALSE */
#ifndef TRUE
# define TRUE		1
#endif /* !TRUE */

/* defaults, limits, etc. */
#define	BUFRSZ		256
#define	CBINTERVAL	3
#define CMDLINEOPTS	"a:Ab:c:C:d:DfFhi:I:k:Klm:M:o:p:P:qrRs:S:T:u:U:Vx:"
#define	DEFTIMEOUT	5
#define	HOSTUNKNOWN	"unknown-host"
#define	JOBIDUNKNOWN	"(unknown-jobid)"
#define	LOCALHOST	"127.0.0.1"
#define	MAXADDRESS	256
#define	MAXARGV		65536
#define	MAXHDRLEN	78
#define	MAXHEADER	4096
#define	MAXSIGNATURE	1024
#define	TEMPFILE	"/var/tmp/dkXXXXXX"
#define	UNKNOWN		"unknown"

#define AUTHRESULTSHDR	"Authentication-Results"

#define	XHEADERNAME	"X-DKIM"
#define	XSELECTCANONHDR	"X-Canonicalization"

/* POPAUTH db */
#if POPAUTH
# define POPAUTHDB	"/etc/mail/popip.db"
#endif /* POPAUTH */

/*
**  PEER -- peer list, listing clients to ignore
*/

typedef struct Peer * Peer;
struct Peer
{
	char *		peer_info;
	struct Peer *	peer_next;
};

/* externs */
extern bool dolog;
extern char *progname;

#endif /* _DKIM_FILTER_H_ */
