/*
 * File: pixmaps.h
 *
 * Copyright (C) 2000, 2001 Jorge Arellano Cid <jcid@inf.utfsm.cl>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __PIXMAPS_H__
#define __PIXMAPS_H__

/* XPM
static char * history_xpm[] = {
"11 20 6 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"O      c #FFFF9A690000",
"+      c #FFFFFFFF0000",
"@      c #FFFFFFFFFFFF",
"           ",
"     .     ",
"    .X.    ",
"   .XXX.   ",
"  .XXXXX.  ",
" .XXXXXXX. ",
" ...XXX... ",
"   .XXX.   ",
"   .XXX.   ",
"   .XXX.   ",
"   OOOOO   ",
"   .XXX.   ",
"   .XXX.   ",
" ...XXX... ",
" .XXXXXXX. ",
"  .XXXXX.  ",
"   .XXX.   ",
"    .X.    ",
"     .     ",
"           "};
*/
/* XPM */
static char * left_xpm[] = {
"26 20 6 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"O      c #FFFF9A690000",
"+      c #FFFFFFFF0000",
"@      c #FFFFFFFFFFFF",
"                          ",
"          ..              ",
"         .X.              ",
"        .XX.              ",
"       .XXX.              ",
"      .XXXX.              ",
"     .XXXXX........ +OO+O ",
"    .XXXXXXXXXXXXX. +OO+O ",
"   .XXXXXXXXXXXXXX. +OO+O ",
"  .XXXXXXXXXXXXXXX. +OO+O ",
"  .XXXXXXXXXXXXXXX. +OO+O ",
"   .XXXXXXXXXXXXXX. +OO+O ",
"    .XXXXXXXXXXXXX. +OO+O ",
"     .XXXXX........ +OO+O ",
"      .XXXX.              ",
"       .XXX.              ",
"        .XX.              ",
"         .X.              ",
"          ..              ",
"                          "};
/* XPM */
static char * right_xpm[] = {
"26 20 6 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"O      c #FFFF9A690000",
"+      c #FFFFFFFF0000",
"@      c #FFFFFFFFFFFF",
"                          ",
"              ..          ",
"              .X.         ",
"              .XX.        ",
"              .XXX.       ",
"              .XXXX.      ",
" O+OO+ ........XXXXX.     ",
" O+OO+ .XXXXXXXXXXXXX.    ",
" O+OO+ .XXXXXXXXXXXXXX.   ",
" O+OO+ .XXXXXXXXXXXXXXX.  ",
" O+OO+ .XXXXXXXXXXXXXXX.  ",
" O+OO+ .XXXXXXXXXXXXXX.   ",
" O+OO+ .XXXXXXXXXXXXX.    ",
" O+OO+ ........XXXXX.     ",
"              .XXXX.      ",
"              .XXX.       ",
"              .XX.        ",
"              .X.         ",
"              ..          ",
"                          "};
/* XPM */
static char * reload_xpm[] = {
"26 20 6 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"O      c #FFFF9A690000",
"+      c #FFFFFFFF0000",
"@      c #FFFFFFFFFFFF",
"         .    ....        ",
"         ..   .OOO.       ",
"      ....X.  .OOOO.      ",
"     .XXXXXX. .OOOOO.     ",
"    .XXXXXXXX....OOO.     ",
"   .XXXXXXXX.   .OOO.     ",
"   .XXX...X.  ...OOO...   ",
"   .XXX. ..    .OOOOO.    ",
"   ..... .      .OOO.     ",
"       .         .O.      ",
"      .O.         .       ",
"     .OOO.      . .....   ",
"    .OOOOO.    .. .XXX.   ",
"   ...OOO...  .X...XXX.   ",
"     .OOO.   .XXXXXXXX.   ",
"     .OOO....XXXXXXXX.    ",
"     .OOOOO. .XXXXXX.     ",
"      .OOOO.  .X....      ",
"       .OOO.   ..         ",
"        ....    .         "};
/* XPM */
static char * home_xpm[] = {
"26 20 9 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"O      c #FFFF9A690000",
"+      c #FFFFFFFF0000",
"z      c #0000FFFFFFFF",
"@      c #FFFFFFFFFFFF",
"I      c #FFFF00000000",
"#      c #FFFF0000FFFF",
"                          ",
"            XX            ",
"           ....           ",
"          ......          ",
"         ........         ",
"        ....oo....        ",
"       ....o..o....       ",
"      ..............      ",
"     ................     ",
"    .....zzzzzzzz.....    ",
"        .OOOOOOOO.        ",
"       .OOOOOOOOOO.       ",
"       .OOOOOOOOOO.       ",
"       .OOOO...OOO.       ",
"       .OOO.I@.OOO.       ",
"       .OOO.I#@.OO.       ",
"     X .OOO.I#@.OO.       ",
"   XXXX.OOO.I#@.OO. XXX   ",
" XXXXXX.OOO.I#@.OO.XXXXXX ",
"XXXXXXX............XXXXXXX"};
/* XPM */
static char * save_xpm[] = {
"26 20 6 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"O      c #FFFF9A690000",
"+      c #FFFFFFFF0000",
"@      c #FFFFFFFFFFFF",
"                          ",
"   ....................   ",
"   .XXXXXXXXXXXXXXXXXX.   ",
"   ...XXXXXXXXXXXXXXXX.   ",
"   .XX..............XX.   ",
"   .XX.@@@@@@@@@@@@.XX.   ",
"   .XX..............XX.   ",
"   .XX.@@@@@@@@@@@@.XX.   ",
"   .XX..............XX.   ",
"   .XX.@@@@@@@@@@@@.XX.   ",
"   .XX..............XX.   ",
"   .XXXXXXXXXXXXXXXXXX.   ",
"   .XXXXXXXXXXXXXXXXXX.   ",
"   .XXX...........XXXX.   ",
"   .XXX.OOOOOOOOOO.XXX.   ",
"   .XXX.O....OOOOO.XXX.   ",
"   .XXX.O.  .OOOOO.XXX.   ",
"   .XXX.O.  .OOOOO.XXX.   ",
"   .XXX.O.  .OOOOO.XXX.   ",
"    ..................    "};
/* XPM */
static char * stop_xpm[] = {
"26 20 6 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"O      c #FFFF9A690000",
"+      c #FFFFFFFF0000",
"@      c #FFFFFFFFFFFF",
"                          ",
"         ........         ",
"        .XXXXXXXX.        ",
"       .XXXX..XXXX.       ",
"      .XXXX.OO.XXXX.      ",
"     .XXXXX.OO.XXXXX.     ",
"    .XXXXXX.OO.XXXXXX.    ",
"    .XXXXXX.OO.XXXXXX.    ",
"    .XXXXXX.OO.XXXXXX.    ",
"    .XXXXXX.OO.XXXXXX.    ",
"    .XXXXXX.OO.XXXXXX.    ",
"    .XXXXXXX..XXXXXXX.    ",
"    .XXXXXXXXXXXXXXXX.    ",
"    .XXXXXXX..XXXXXXX.    ",
"     .XXXXX.OO.XXXXX.     ",
"      .XXXX.OO.XXXX.      ",
"       .XXXX..XXXX.       ",
"        .XXXXXXXX.        ",
"         ........         ",
"                          "};

/* Small icons here */

/* XPM */
static char * s_left_xpm[] = {
"17 15 5 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"o      c #FFFF9A690000",
"O      c #FFFFFFFF0000",
"                 ",
"      ..         ",
"     .X.         ",
"    .XX.         ",
"   .XXX...... oOo",
"  .XXXXXXXXX. oOo",
" .XXXXXXXXXX. oOo",
".XXXXXXXXXXX. oOo",
" .XXXXXXXXXX. oOo",
"  .XXXXXXXXX. oOo",
"   .XXX...... oOo",
"    .XX.         ",
"     .X.         ",
"      ..         ",
"                 "};
/* XPM */
static char * s_right_xpm[] = {
"17 15 5 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"o      c #FFFF9A690000",
"O      c #FFFFFFFF0000",
"                 ",
"         ..      ",
"         .X.     ",
"         .XX.    ",
"oOo ......XXX.   ",
"oOo .XXXXXXXXX.  ",
"oOo .XXXXXXXXXX. ",
"oOo .XXXXXXXXXXX.",
"oOo .XXXXXXXXXX. ",
"oOo .XXXXXXXXX.  ",
"oOo ......XXX.   ",
"         .XX.    ",
"         .X.     ",
"         ..      ",
"                 "};
/* XPM */
static char * s_home_xpm[] = {
"17 15 7 1",
"       c None",
".      c #9658A289BEFB",
"X      c #000000000000",
"o      c #FFFF0000FFFF",
"O      c #FFFF9A690000",
"+      c #FFFF00000000",
"@      c #FFFFFFFFFFFF",
"        .        ",
"       XXX       ",
"      XXXXX      ",
"     XXXoXXX     ",
"    XXXoXoXXX    ",
"   XXXXXXXXXXX   ",
"  XXXXXXXXXXXXX  ",
"     XOOOOOX     ",
"    XOOOOOOOX    ",
"    XOOOXXOOX    ",
"    XOOX+oXOX    ",
"    XOOXo@XOX    ",
"    XOOXo@XOX..  ",
" ...XOOXo@XOX....",
"....XXXXXXXXX...."};
/* XPM */
static char * s_reload_xpm[] = {
"17 15 4 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"o      c #FFFF9A690000",
"      .   ..     ",
"   ...X. .oo.    ",
"  .XXXXX..ooo.   ",
" .XXXXXX. .oo.   ",
" .XX..X.  .oo.   ",
" .XX. .  .oooo.  ",
"  ..      .oo.   ",
"   ..      ..    ",
"  .oo.      ..   ",
" .oooo.  . .XX.  ",
"  .oo.  .X..XX.  ",
"  .oo. .XXXXXX.  ",
"  .ooo..XXXXX.   ",
"   .oo. .X...    ",
"    ..   .       "};
/* XPM */
static char * s_save_xpm[] = {
"17 15 5 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"o      c #FFFFFFFFFFFF",
"O      c #FFFF9A690000",
" ............... ",
" ..XXXXXXXXXXXX. ",
" .X...........X. ",
" .X.ooooooooo.X. ",
" .X...........X. ",
" .X.ooooooooo.X. ",
" .X...........X. ",
" .XXXXXXXXXXXXX. ",
" .XXXXXXXXXXXXX. ",
" .XX........XXX. ",
" .XX.OOOOOOO.XX. ",
" .XX.O...OOO.XX. ",
" .XX.O. .OOO.XX. ",
"  .............  ",
"                 "};
/* XPM */
static char * s_stop_xpm[] = {
"17 15 4 1",
"       c None",
".      c #000000000000",
"X      c #9658A289BEFB",
"o      c #FFFF9A690000",
"                 ",
"     .......     ",
"    .XXX.XXX.    ",
"   .XXX.o.XXX.   ",
"  .XXXX.o.XXXX.  ",
"  .XXXX.o.XXXX.  ",
"  .XXXX.o.XXXX.  ",
"  .XXXX.o.XXXX.  ",
"  .XXXXX.XXXXX.  ",
"  .XXXXXXXXXXX.  ",
"  .XXXXX.XXXXX.  ",
"   .XXX.o.XXX.   ",
"    .XXX.XXX.    ",
"     .......     ",
"                 "};

/* XPM */
static char * s_new_xpm[] = {
"10 10 2 1",
"       c None",
"X      c #9658A289BEFB",
"XX      XX",
" XX X  XX ",
"  XX  XX  ",
"          ",
" X  XX X  ",
"  X XX  X ",
"          ",
"  XX  XX  ",
" XX  X XX ",
"XX      XX"};

#endif /* __BITVEC_H__ */
