#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# Copyright 2006-2007 (C) Raster Software Vigo (Sergio Costas)
# Copyright 2006-2007 (C) Peter Gill - win32 parts

# This file is part of DeVeDe
#
# DeVeDe is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# DeVeDe is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import sys
import os
import pygtk # for testing GTK version number
pygtk.require ('2.0')
import gtk
import gtk.glade
import gobject
import subprocess
import locale
import gettext
import stat
import shutil
import pickle
import cairo

try:
	import psyco
	psyco.full()
except ImportError:
	print 'Psyco not installed, the program will just run slower'

print "DeVeDe 3.9"
if sys.platform!="win32":
	print "Locale: "+str(os.environ["LANG"])

# append the directories where we install the devede's own modules
tipo=-1
try:
	fichero=open("/usr/local/share/devede/devede.glade","r")
	fichero.close()
	tipo=1
	found=True
except:
	found=False

if found==False:
	try:
		fichero=open("/usr/share/devede/devede.glade","r")
		fichero.close()
		tipo=0
		found=True
	except:
		found=False

if found==False:
	try:
		fichero=open("./devede.glade","r")
		fichero.close()
		tipo=2
		found=True
	except:
		found=False	

if tipo==0:
	#gettext.bindtextdomain('devede', '/usr/share/locale')
	#Note also before python 2.3 you need the following if
	#you need translations from non python code (glibc,libglade etc.)
	#there are other access points to this function
	#gtk.glade.bindtextdomain("devede","/usr/share/locale")
	#arbol=gtk.glade.XML("/usr/share/devede/devede.glade",domain="devede")
	# append the directories where we install the devede's own modules

	share_locale="/usr/share/locale"
	glade="/usr/share/devede/devede.glade"
	sys.path.append("/usr/lib/devede")
	font_path="/usr/share/devede"
	pic_path="/usr/share/devede"
elif tipo==1:
	# if the files aren't at /usr, try with /usr/local
	#gettext.bindtextdomain('devede', '/usr/share/locale')
	#Note also before python 2.3 you need the following if
	#you need translations from non python code (glibc,libglade etc.)
	#there are other access points to this function
	#gtk.glade.bindtextdomain("devede","/usr/share/locale")
	#arbol=gtk.glade.XML("/usr/local/share/devede/devede.glade",domain="devede")

	share_locale="/usr/share/locale" # Are you sure?
	# if the files aren't at /usr, try with /usr/local
	glade="/usr/local/share/devede/devede.glade"
	sys.path.append("/usr/local/lib/devede")
	font_path="/usr/local/share/devede"
	pic_path="/usr/local/share/devede"
elif tipo==2:
	# if the files aren't at /usr/local, try with ./
	#gettext.bindtextdomain('devede', './po/')
	#Note also before python 2.3 you need the following if
	#you need translations from non python code (glibc,libglade etc.)
	#there are other access points to this function
	#gtk.glade.bindtextdomain("devede","/usr/share/locale")
	#arbol=gtk.glade.XML("./devede.glade",domain="devede")
	
	# if the files aren't at /usr/local, try with ./
	share_locale="./po/"
	glade="./devede.glade"
	sys.path.append(os.getcwd())#("./")
	font_path=os.getcwd()#"./"
	pic_path=os.path.join(font_path, "pixmaps") #pic_path=font_path
else:
	print "Can't locate extra files. Aborting."
	sys.exit(1)


#####################
#   GetText Stuff   #
#####################

gettext.bindtextdomain('devede',share_locale)
locale.setlocale(locale.LC_ALL,"")
gettext.textdomain('devede')
gettext.install("devede",localedir=share_locale) # None is sys default locale
#   Note also before python 2.3 you need the following if
#   you need translations from non python code (glibc,libglade etc.)
#   there are other access points to this function
gtk.glade.bindtextdomain("devede",share_locale)
arbol=gtk.glade.XML(glade,domain="devede")
#   To actually call the gettext translation functions
#   just replace your strings "string" with gettext("string")
#   The following shortcut are usually used:
_ = gettext.gettext

try:
	import devede_other
except:
	print "Failed to load modules DEVEDE_OTHER. Exiting"
	sys.exit(1)
try:
	import devede_convert
except:
	print "Failed to load modules DEVEDE_CONVERT. Exiting"
	sys.exit(1)
try:
	import devede_newfiles
except:
	print "Failed to load module DEVEDE_NEWFILES. Exiting"
	sys.exit(1)
try:
	import devede_xml_menu
except:
	print "Failed to load module DEVEDE_XML_MENU"
	sys.exit(1)

try:
	import devede_disctype
except:
	print "Failed to load module DEVEDE_DISCTYPE"
	sys.exit(1)


home=devede_other.get_home_directory()

#locale.setlocale(locale.LC_ALL,"")
#gettext.textdomain('devede')
#_ = gettext.gettext

# global variables used (they are stored in a single dictionary to
# avoid true global variables):
# there are these two that aren't stored in the dictionary because they are very widely used:
# arbol
# structure

global_vars={}

if pic_path[-1]!=os.sep:
	pic_path+=os.sep

global_vars["PAL"]=True
global_vars["disctocreate"]=""
global_vars["path"]=pic_path
global_vars["menu_widescreen"]=False
global_vars["menu_PAL"]=True
global_vars["gladefile"]=glade
global_vars["erase_temporary_files"]=True
global_vars["number_actions"]=1
global_vars["menu_bgcolor"]=[0,0,0,49152]
global_vars["menu_font_color"]=[65535,65535,65535,65535]
global_vars["menu_selc_color"]=[0,65535,65535,65535]
global_vars["menu_alignment"]=2 # middle
global_vars["expand_advanced"]=False
global_vars["erase_files"]=True
global_vars["action_todo"]=2
global_vars["filmpath"]=""

if font_path[-1]!=os.sep:
	font_path+=os.sep
font_path+="devedesans.ttf"
global_vars["font_path"]=font_path

#if our font for subtitles isn't installed, we install it

try:
	if sys.platform!='win32':
		fichero=open(home+".spumux/devedesans.ttf")
		fichero.close()
	else: # get home
		t=os.path.join(os.environ["WINDIR"], "Fonts", "devedesans.ttf")
		fichero=open(t)
		fichero.close()
except:
	if sys.platform=='win32':
		t=os.path.join(os.environ["WINDIR"], "Fonts" )#=r'C:\WINDOWS\Fonts\\'
		# spummux needs font in the windows font directory
		print "\n\nFont Path: " , font_path
		print "\n\nT: " , t
		shutil.copyfile(font_path,t+os.sep+"devedesans.ttf")
	else:
		handle=subprocess.Popen("mkdir "+home+".spumux",bufsize=8192,shell=True)
		handle.wait()
		handle=subprocess.Popen("cp "+font_path+" "+home+".spumux/",bufsize=8192,shell=True)
		handle.wait()

devede_other.load_config(global_vars) # load configuration

errors="" # check for installed programs
if not sys.platform=='win32': 
	if 127==devede_other.check_program("mplayer -v"):
		errors+="mplayer\n"
	if 127==devede_other.check_program("mencoder -msglevel help"):
		errors+="mencoder\n"
	if 127==devede_other.check_program("dvdauthor --help"):
		errors+="dvdauthor\n"
	if 127==devede_other.check_program("vcdimager --help"):
		errors+="vcdimager\n"
	if 127==devede_other.check_program("mkisofs -help"):
		errors+="mkisofs\n"
	if 127==devede_other.check_program("spumux --help"):
		errors+="spumux\n"
	if 127==devede_other.check_program("convert --help"):
		errors+="convert (imagemagick)\n"
else:
	try:
		devede_other.check_program(["mplayer.exe", "-v"])
	except:
		errors+="mplayer\n"
	try:
		devede_other.check_program(["mencoder.exe", "-msglevel", "help"])
	except:
		errors+="mencoder\n"
	try:
		devede_other.check_program(["dvdauthor.exe", "--help"])
	except:
		errors+="dvdauthor\n"
	try:
		devede_other.check_program(["vcdimager.exe", "--help"])
	except:
		errors+="vcdimager\n"
	try:
		devede_other.check_program(["mkisofs.exe"])
	except:
		errors+="mkisofs\n"
	try:
		devede_other.check_program(["spumux.exe", "--help"])
	except:
		errors+="spumux\n"
	try:
		devede_other.check_program(["convert.exe", "--help"])
	except:
		errors+="convert (imagemagick)\n"

def program_exit(widget):
	
	gtk.main_quit()

if errors!="":
	w=arbol.get_widget("programs_label")
	w.set_text(errors)
	wprograms=arbol.get_widget("wprograms")
	wprograms.show()
	w=arbol.get_widget("program_exit")
	w.connect("clicked",program_exit)
	wprograms.connect("destroy",program_exit)
else:
	new_file=devede_disctype.disctype(global_vars)

gtk.main()
devede_other.save_config(global_vars)
