/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <signal.h>
#include <gnome.h>

#include "interface.h"
#include "support.h"
#include "main.h"
#include "init_fnc.h"

#include "gui_layout.h"
#include "dcgui.xpm"

GtkWidget *main_window=NULL;

GtkWidget *dl_popup=NULL;
GtkWidget *ul_popup=NULL;
GtkWidget *q_popup=NULL;
GtkWidget *user_popup=NULL;
GtkWidget *start_dl_popup=NULL;
GtkWidget *gdl_popup=NULL;

GString *dctc_dir;

GString *last_search[2]={NULL,NULL};		/* the last search is kept because if multi-hub search is enabled */
														/* the command(s) must be resent */
gint last_search_tag=-1;						/* when a search may start a multi-hub search, this value is the tag return by gtk_timeout_add */


/*******************************************************/
/* the following vars are used to manage I/O with dctc */
/*******************************************************/
DCTC_COM *current_dctc=NULL;

GdkColor light_red, white, black, light_grey, green;

static struct
{
   unsigned int r,v,b;
   GdkColor *ptr;
}alloc_color[]={
						{0xffff,0x0,0x0,&light_red},
						{0xffff,0xffff,0xffff,&white},
						{0,0,0,&black},
						{0xacac,0xacac,0xacac,&light_grey},
						{0x0,0xffff,0x0,&green},
                  {0,0,0,NULL}
               };


/*********************************************************/
/* we don't want to receive SIGPIPE, SIGHUP and SIG_CHLD */
/*********************************************************/
static void set_sig(void)
{
   struct sigaction act;
   sigset_t set;

   /* ignore SIGPIPE */
	/* ignore SIGCHLD */
	/* ignore SIGHUP */
   sigemptyset(&set);
   sigaddset(&set,SIGPIPE);
   sigaddset(&set,SIGCHLD);
   sigaddset(&set,SIGHUP);
   act.sa_handler=SIG_IGN;
   act.sa_mask=set;
   act.sa_flags=SA_RESTART;

   sigprocmask(SIG_UNBLOCK,&set,NULL);
	sigaction(SIGPIPE,&act,NULL);
	sigaction(SIGCHLD,&act,NULL);
	sigaction(SIGHUP,&act,NULL);
}

int
main (int argc, char *argv[])
{
	char *path;
	GdkColormap *colormap;
	int i;

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

	path=getenv("HOME");
	dctc_dir=g_string_new(NULL);
	g_string_sprintf(dctc_dir,"%s/.dctc/running",(path!=NULL)?path:".");

  gnome_init ("dc_gui", VERSION, argc, argv);

	set_sig();
  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
	main_window = create_app1 ();
	gui_full_restore(main_window,NULL);
	gtk_widget_realize(main_window);
#if 0
	gnome_window_icon_set_from_file(GTK_WINDOW(main_window),"icon.xpm");
#else
	{
		static GdkPixmap *win_pix=NULL;
		static GdkBitmap *win_bit=NULL;

		win_pix=gdk_pixmap_create_from_xpm_d(main_window->window,&win_bit,NULL,dcgui_xpm);

		gdk_window_set_icon_name (main_window->window, "DCgui " VERSION);
		gdk_window_set_icon(main_window->window,NULL,win_pix,win_bit);
	}
#endif
  	gtk_widget_show (main_window);

	dl_popup=create_dl_popup_menu ();
	ul_popup=create_ul_popup_menu ();
	q_popup=create_q_popup_menu ();
	user_popup=create_user_popup_menu ();
	start_dl_popup=create_start_dl_popup_menu ();
	gdl_popup=create_gdl_popup_menu ();

	/* preallocate some useful colors */
	colormap=gdk_window_get_colormap(main_window->window);
	i=0;
	while(alloc_color[i].ptr!=NULL)
	{
		alloc_color[i].ptr->red=(guint16)alloc_color[i].r;
		alloc_color[i].ptr->green=(guint16)alloc_color[i].v;
		alloc_color[i].ptr->blue=(guint16)alloc_color[i].b;
	
		/* Allocate color */
		gdk_color_alloc (colormap, alloc_color[i].ptr);
		i++;
	}

	/* fill running hub clist */
	fill_recent_hub_clist();
	fill_running_hub_clist();
	fix_pref_window();
	init_clist();

  gtk_main ();
  return 0;
}

