#ifndef __GUI_LAYOUT_H__
#define __GUI_LAYOUT_H__

/*************************************************************************/
/* the following functions save/restore the geometry of the given widget */
/* and all its childs                                                    */
/*************************************************************************/
/* to be saved, a widget must:                          */
/* 1) have a name (set with gtk_widget_set_name)        */
/* 2) be one of the following widget                    */
/*    - paned (h or v): the separator position is saved */
/*    - window: x,y,width and height are saved.         */
/*    - clist: column width are saved.                  */
/********************************************************/
/* prefix is a string preprended to the widget name */
/* before loading/saving it.                        */
/****************************************************/

/************************************************************************************/
/* this function must be called after all child widgets of widget have been created */
/************************************************************************************/
void gui_full_restore(GtkWidget *widget, char *prefix);

/*************************************************************/
/* this function must be called when the delete_event occurs */
/*************************************************************/
void gui_full_save(GtkWidget *widget, char *prefix);

#endif

