#include <stdio.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gnome.h>

#include "gui_layout.h"

#define PROGNAME "Dc_gui"

#define is_nonempty_string(x)		((x!=NULL)&&(strlen(x)!=0))

static char *current_wprefix="";

/* restore widget geometry according to geometry save into widget name (key) */
static void gui_restore_window_size (GtkWidget* widget, const gchar* key)
{
   gint x, y, w, h;
   GString * buf;
   gint screen_w = gdk_screen_width ();
   gint screen_h = gdk_screen_height ();
   const gint fuzz = 10;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (!GTK_WIDGET_REALIZED(widget));
   g_return_if_fail (is_nonempty_string(key));

   /* get the dimensions */
   buf = g_string_new (NULL);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_x", current_wprefix,key);
   x = gnome_config_get_int (buf->str);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_y", current_wprefix,key);
   y = gnome_config_get_int (buf->str);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_width", current_wprefix,key);
   w = gnome_config_get_int (buf->str);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_height", current_wprefix,key);
   h = gnome_config_get_int (buf->str);

   /* move & resize */
   if ((0<x && x<screen_w-fuzz) && (0<y && y<screen_h-fuzz))
      gtk_widget_set_uposition (widget, x, y);
   if (w>0 && h>0)
      gtk_window_set_default_size (GTK_WINDOW(widget), w, h);

   /* cleanup */
   g_string_free (buf, TRUE);
}

/* save widget geometry into widget name (key) */
static void gui_save_window_size (GtkWidget* widget, const gchar* key)
{
   GString * buf;
   gint x, y, w, h;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (widget->window!=NULL);
   g_return_if_fail (is_nonempty_string(key));

   buf = g_string_new (NULL);
   gdk_window_get_position (widget->window, &x, &y);
   gdk_window_get_size (widget->window, &w, &h);

   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_x", current_wprefix,key);
   gnome_config_set_int (buf->str, x);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_y", current_wprefix,key);
   gnome_config_set_int (buf->str, y);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_width", current_wprefix,key);
   gnome_config_set_int (buf->str, w);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_height", current_wprefix,key);
   gnome_config_set_int (buf->str, h);

   g_string_free (buf, TRUE);
   gnome_config_sync ();
}

/* restore column width according to type values */
static void gui_restore_column_widths (GtkWidget* clist, const gchar* type)
{
   int i;
   GtkCList * list = GTK_CLIST (clist);
   const int cols = list->columns;
   int * widths = g_new (int, cols);
   GString * buf = g_string_new (NULL);

   /* get width from config... */
   for (i=0; i!=cols; ++i) {
      g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_column_%d", current_wprefix,type, i);
      widths[i] = gnome_config_get_int (buf->str);
   }

   /* set ui.. */
   for (i=0; i!=cols; ++i)
      if (widths[i] != 0)
         gtk_clist_set_column_width (list, i, widths[i]);

	/* sort type: ascending/descending */
	g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_sort_type", current_wprefix,type);
	i=gnome_config_get_int(buf->str);
	gtk_clist_set_sort_type(list,i);

	/* sort column */
	g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_sort_column", current_wprefix,type);
	i=gnome_config_get_int(buf->str);
	gtk_clist_set_sort_column(list,i);

   /* cleanup */
   g_string_free (buf, TRUE);
   g_free (widths);
}

/* restore column width according into type values */
static void gui_save_column_widths (GtkWidget* clist, const gchar* type)
{
   int i;
   int cols = GTK_CLIST (clist)->columns;
   GtkCList * list = GTK_CLIST (clist);
   GString * buf = g_string_new (NULL);

   for (i=0; i<cols; i++)
   {
      g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_column_%d", current_wprefix,type, i);
      gnome_config_set_int (buf->str, (int)list->column[i].width);
   }

	/* sort type: ascending/descending */
	g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_sort_type", current_wprefix,type);
	gnome_config_set_int (buf->str, (int)list->sort_type);
	
	/* sort column */
	g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_sort_column", current_wprefix,type);
	gnome_config_set_int (buf->str, (int)list->sort_column);

   g_string_free (buf, TRUE);
   gnome_config_sync ();
}

/* restore separator position according to geometry save into widget name (key) */
static void gui_restore_hvpaned_separator_position (GtkWidget* widget, const gchar* key)
{
   gint w;
   GString * buf;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (!GTK_WIDGET_REALIZED(widget));
   g_return_if_fail (is_nonempty_string(key));

   /* get the dimensions */
   buf = g_string_new (NULL);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_sep_pos", current_wprefix,key);
   w = gnome_config_get_int (buf->str);

	if(w>0)
		gtk_paned_set_position(GTK_PANED(widget),w);

   /* cleanup */
   g_string_free (buf, TRUE);
}

/* save separator position into widget name (key) */
static void gui_save_hvpaned_separator_position (GtkWidget* widget, const gchar* key)
{
   GString * buf;
   gint h,w;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (widget->window!=NULL);
   g_return_if_fail (is_nonempty_string(key));

   buf = g_string_new (NULL);
	/* unfortunately, there is no gtk_paned_get_position */
	/* thus, the position is the width/height of the first child */
   gdk_window_get_size (GTK_PANED(widget)->child1->window, &w, &h);
	if(GTK_IS_VPANED(widget))
		w=h;

   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_sep_pos", current_wprefix,key);
   gnome_config_set_int (buf->str, w);

   g_string_free (buf, TRUE);
   gnome_config_sync ();
}

/* save gtk_entry content into widget name (key) */
static void gui_save_entry_content (GtkWidget* widget, const gchar* key)
{
	const gchar *cnt;

	cnt=gtk_entry_get_text(GTK_ENTRY(widget));
	if(cnt!=NULL)
	{
   	GString * buf;
   	buf = g_string_new (NULL);
   	g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_ent_cnt", current_wprefix,key);
   	gnome_config_set_string (buf->str, cnt);
   	g_string_free (buf, TRUE);
   	gnome_config_sync ();
	}
}

static void gui_restore_entry_content(GtkWidget* widget, const gchar* key)
{
	GString * buf;
	gchar *cnt;

  	buf = g_string_new (NULL);
  	g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_ent_cnt", current_wprefix,key);
	cnt=gnome_config_get_string(buf->str);

	if(cnt)
	{
		gtk_entry_set_text(GTK_ENTRY(widget),cnt);
		g_free(cnt);
	}
}

/* restore scale value according to geometry save into widget name (key) */
static void gui_restore_scale_value (GtkWidget* widget, const gchar* key)
{
   gfloat w;
   GString * buf;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
#if 0
   g_return_if_fail (!GTK_WIDGET_REALIZED(widget));
#endif
   g_return_if_fail (is_nonempty_string(key));

   /* get the dimensions */
   buf = g_string_new (NULL);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_scale_val", current_wprefix,key);
   w = gnome_config_get_float (buf->str);

	gtk_adjustment_set_value(gtk_range_get_adjustment(GTK_RANGE(widget)),w);

   /* cleanup */
   g_string_free (buf, TRUE);
}

/* save scale value into widget name (key) */
static void gui_save_scale_value (GtkWidget* widget, const gchar* key)
{
   GString * buf;
	gfloat val;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (is_nonempty_string(key));

   buf = g_string_new (NULL);
	val=gtk_range_get_adjustment(GTK_RANGE(widget))->value;

   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_scale_val", current_wprefix,key);
   gnome_config_set_float (buf->str, val);

   g_string_free (buf, TRUE);
   gnome_config_sync ();
}

/* restore scale value according to geometry save into widget name (key) */
static void gui_restore_toggle_button (GtkWidget* widget, const gchar* key)
{
   gfloat w;
   GString * buf;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
#if 0
   g_return_if_fail (!GTK_WIDGET_REALIZED(widget));
#endif
   g_return_if_fail (is_nonempty_string(key));

   /* get the dimensions */
   buf = g_string_new (NULL);
   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_toggle_val", current_wprefix,key);
   w = gnome_config_get_int (buf->str);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),w);

   /* cleanup */
   g_string_free (buf, TRUE);
}

/* save scale value into widget name (key) */
static void gui_save_toggle_button (GtkWidget* widget, const gchar* key)
{
   GString * buf;
	int val;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (is_nonempty_string(key));

   buf = g_string_new (NULL);
	val=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

   g_string_sprintf (buf, "/" PROGNAME "/Geometry/%s%s_toggle_val",current_wprefix, key);
   gnome_config_set_int (buf->str, val);

   g_string_free (buf, TRUE);
   gnome_config_sync ();
}

static void recursive_gui_restore(GtkWidget *widget, gpointer dummy)
{
	gchar *name;

	if(GTK_IS_CLIST(widget))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_restore_column_widths(widget,name);
	}
	else if(GTK_IS_WINDOW(widget))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_restore_window_size(widget,name);
	}
	else if(GTK_IS_VPANED(widget)||(GTK_IS_HPANED(widget)))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_restore_hvpaned_separator_position(widget,name);
	}
	else if(GTK_IS_ENTRY(widget))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_restore_entry_content(widget,name);
	}
	else if(GTK_IS_SCALE(widget))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_restore_scale_value(widget,name);
	}
	else if(
				(GTK_IS_RADIO_BUTTON(widget))||
				(GTK_IS_CHECK_BUTTON(widget))||
				(GTK_IS_TOGGLE_BUTTON(widget)) )
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_restore_toggle_button(widget,name);
	}
	
	if(!GTK_IS_ENTRY(widget)&&
		!GTK_IS_LABEL(widget)&&
		!GTK_IS_PROGRESS_BAR(widget)&&
		!GTK_IS_TEXT(widget)&&
		!GTK_IS_HSEPARATOR(widget)&&
		!GNOME_IS_STOCK(widget)&&
		!GTK_IS_HSCALE(widget)&&
		!GTK_IS_ARROW(widget))
		gtk_container_foreach(GTK_CONTAINER(widget),recursive_gui_restore,NULL);
}

/*************************************************************************/
/* the following functions save/restore the geometry of the given widget */
/* and all its childs                                                    */
/*************************************************************************/
void gui_full_restore(GtkWidget *widget, char *prefix)
{
	if(prefix==NULL)
		current_wprefix="";
	else
		current_wprefix=prefix;

	recursive_gui_restore(widget,NULL);
}

static void recursive_gui_save(GtkWidget *widget, gpointer dummy)
{
	gchar *name;

	if(GTK_IS_CLIST(widget))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_save_column_widths(widget,name);
	}
	else if(GTK_IS_WINDOW(widget))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_save_window_size(widget,name);
	}
	else if(GTK_IS_VPANED(widget)||(GTK_IS_HPANED(widget)))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_save_hvpaned_separator_position(widget,name);
	}
	else if(GTK_IS_ENTRY(widget))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_save_entry_content(widget,name);
	}
	else if(GTK_IS_SCALE(widget))
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_save_scale_value(widget,name);
	}
	else if(
				(GTK_IS_RADIO_BUTTON(widget))||
				(GTK_IS_CHECK_BUTTON(widget))||
				(GTK_IS_TOGGLE_BUTTON(widget)) )
	{
		name=gtk_widget_get_name(widget);
		if(name!=NULL)
			gui_save_toggle_button(widget,name);
	}
		
	
	if(!GTK_IS_ENTRY(widget)&&
		!GTK_IS_LABEL(widget)&&
		!GTK_IS_PROGRESS_BAR(widget)&&
		!GTK_IS_TEXT(widget)&&
		!GTK_IS_HSEPARATOR(widget)&&
		!GNOME_IS_STOCK(widget)&&
		!GTK_IS_HSCALE(widget)&&
		!GTK_IS_ARROW(widget))
		gtk_container_foreach(GTK_CONTAINER(widget),recursive_gui_save,NULL);
}

/*************************************************************************/
/* the following functions save/restore the geometry of the given widget */
/* and all its childs                                                    */
/*************************************************************************/
void gui_full_save(GtkWidget *widget,char *prefix)
{
	if(prefix==NULL)
		current_wprefix="";
	else
		current_wprefix=prefix;

	recursive_gui_save(widget,NULL);
}

