#ifndef __DCTC_COM_H__
#define __DCTC_COM_H__

typedef struct
{
	int dctc_fd;			/* socket to use to communicate with dctc */
	gint tag_read; 		/* if dctc_fd!=-1 and this value !=-1, it is a tag to */
								/* use with gdk_input_* for GDK_INPUT_READ event */
	gint tag_write;		/* if dctc_fd!=-1 and this value !=-1, it is a tag to */
								/* use with gdk_input_* for GDK_INPUT_WRITE event */
	GPtrArray *write_q;  /* this array contains the list of all strings */
								/* to send to dctc */
} DCTC_COM;

/**********************************************************/
/* allocate a new DCTC_COM structure for the given socket */
/**********************************************************/
DCTC_COM *create_new_dctc_com(int sock_fd);

/***************************************************/
/* close socket and free memory used by a DCTC_COM */
/***************************************************/
void close_and_free_dctc_com(DCTC_COM *cm);

#endif
