/*
 * OWL (OpenedHand Widget Library) Colour Selector Dialog.
 *
 * Author: Rob Bradford  <rob@openedhand.com>
 *
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _OWL_COLOUR_SELECTOR_DIALOG
#define _OWL_COLOUR_SELECTOR_DIALOG

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define OWL_TYPE_COLOUR_SELECTOR_DIALOG owl_colour_selector_dialog_get_type()

#define OWL_COLOUR_SELECTOR_DIALOG(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  OWL_TYPE_COLOUR_SELECTOR_DIALOG, OwlColourSelectorDialog))

#define OWL_COLOUR_SELECTOR_DIALOG_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  OWL_TYPE_COLOUR_SELECTOR_DIALOG, OwlColourSelectorDialogClass))

#define OWL_IS_COLOUR_SELECTOR_DIALOG(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  OWL_TYPE_COLOUR_SELECTOR_DIALOG))

#define OWL_IS_COLOUR_SELECTOR_DIALOG_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  OWL_TYPE_COLOUR_SELECTOR_DIALOG))

#define OWL_COLOUR_SELECTOR_DIALOG_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  OWL_TYPE_COLOUR_SELECTOR_DIALOG, OwlColourSelectorDialogClass))

typedef struct {
  GtkDialog parent;
} OwlColourSelectorDialog;

typedef struct {
  GtkDialogClass parent_class;
} OwlColourSelectorDialogClass;

typedef enum {
  OWL_COLOUR_SELECTOR_DIALOG_HORIZONTAL,
  OWL_COLOUR_SELECTOR_DIALOG_VERTICAL,
  OWL_COLOUR_SELECTOR_DIALOG_AUTOMATIC
} OwlColourSelectorDialogOrientation;

GType owl_colour_selector_dialog_get_type (void);

GtkWidget* owl_colour_selector_dialog_new_with_orientation (OwlColourSelectorDialogOrientation orientation);
GtkWidget* owl_colour_selector_dialog_new (void);
guint32 owl_colour_selector_dialog_get_colour (OwlColourSelectorDialog *self);
void owl_colour_selector_dialog_set_colour (OwlColourSelectorDialog *self, guint32 colour);

G_END_DECLS

#endif /* _OWL_COLOUR_SELECTOR_DIALOG */

